/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.messages;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedByte;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UTF8String;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class IMPINJ_ENABLE_EXTENSIONS
extends LLRPMessage {
    public static final UTF8String vendor = new UTF8String("Impinj");
    public static final UnsignedByte subtype = new UnsignedByte(new Integer(21).byteValue());
    public static final UnsignedInteger vendorIdentifier = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(IMPINJ_ENABLE_EXTENSIONS.class);
    public static final String RESPONSETYPE = "IMPINJ_ENABLE_EXTENSIONS_RESPONSE";
    private SignedByte messageSubtype;
    protected BitList reserved0 = new BitList(32);
    private List<Custom> customList = new LinkedList<Custom>();

    public IMPINJ_ENABLE_EXTENSIONS() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public IMPINJ_ENABLE_EXTENSIONS(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list.toByteArray());
    }

    public IMPINJ_ENABLE_EXTENSIONS(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public IMPINJ_ENABLE_EXTENSIONS(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        resultBits.append(vendorIdentifier.encodeBinary());
        resultBits.append(subtype.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        for (Custom field : this.customList) {
            resultBits.append(field.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.messageSubtype = new SignedByte(binary.subList(position += UnsignedInteger.length(), SignedByte.length()));
        position += SignedByte.length();
        position += this.reserved0.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            Custom custom = null;
            SignedShort type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 10 + 6, UnsignedShort.length()).toShort();
            tempLength = 8 * tempByteLength;
            if (type.equals(Custom.TYPENUM)) {
                custom = new Custom(binary.subList(position, tempLength));
            }
            if (!type.equals(Custom.TYPENUM)) break;
            this.customList.add(new Custom(binary.subList(position, tempLength)));
            position += tempLength;
        }
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/Impinj.xsd");
        }
        catch (InvalidLLRPMessageException invalidLLRPMessageException) {
            // empty catch block
        }
        try {
            Element root = document.getRootElement();
            List tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID"));
            Object temp = null;
            this.customList = new LinkedList<Custom>();
            tempList = root.getChildren("Custom", root.getNamespace());
            if (tempList == null || tempList.isEmpty()) {
                Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
                tempList = root.getChildren("Custom", llrpns);
            }
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.38");
            Element root = new Element("IMPINJ_ENABLE_EXTENSIONS", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.38"));
            if (this.version == null) {
                throw new MissingParameterException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new MissingParameterException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.customList == null) {
                LOGGER.info("customList not set");
            } else {
                for (Custom field : this.customList) {
                    root.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
                }
            }
            Document doc = new Document(root);
            try {
                this.isValidXMLMessage(doc, "org/llrp/ltk/Impinj.xsd");
            }
            catch (InvalidLLRPMessageException invalidLLRPMessageException) {
                // empty catch block
            }
            return doc;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "IMPINJ_ENABLE_EXTENSIONS";
    }

    @Override
    public SignedShort getTypeNum() {
        return new SignedShort(1023);
    }

    public SignedByte getMessageSubtype() {
        return this.messageSubtype;
    }
}

