/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.AntennaConfig;
import com.impinj.octane.OctaneSdkException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AntennaConfigGroup
implements Iterable<AntennaConfig> {
    private ArrayList<AntennaConfig> antennaConfigs = new ArrayList();
    private boolean antennaCollectionCreatedBySerializer = false;
    private double rxSensitivityinDbm;
    private double txPowerinDbm;
    private Boolean isMaxRxSensitivity;
    private Boolean isMaxTxPower;
    private boolean polarizationEnabled;

    AntennaConfigGroup() {
        this.antennaCollectionCreatedBySerializer = true;
        this.isMaxTxPower = false;
        this.isMaxRxSensitivity = false;
        this.polarizationEnabled = false;
    }

    AntennaConfigGroup(long numAntennas) {
        this.antennaCollectionCreatedBySerializer = false;
        short i = 1;
        while ((long)i <= numAntennas) {
            this.antennaConfigs.add(new AntennaConfig(i));
            i = (short)(i + 1);
        }
        this.isMaxTxPower = true;
        this.isMaxRxSensitivity = true;
        this.polarizationEnabled = false;
    }

    static short[] sectorToAntennaIds(short sector) throws OctaneSdkException {
        switch (sector) {
            case 1: {
                return new short[]{1, 2, 3, 4};
            }
            case 2: {
                return new short[]{5, 13, 21, 29, 37, 45};
            }
            case 3: {
                return new short[]{6, 14, 22, 30, 38, 46};
            }
            case 4: {
                return new short[]{7, 15, 23, 31, 39, 47};
            }
            case 5: {
                return new short[]{8, 16, 24, 32, 40, 48};
            }
            case 6: {
                return new short[]{9, 17, 25, 33, 41, 49};
            }
            case 7: {
                return new short[]{10, 18, 26, 34, 42, 50};
            }
            case 8: {
                return new short[]{11, 19, 27, 35, 43, 51};
            }
            case 9: {
                return new short[]{12, 20, 28, 36, 44, 52};
            }
        }
        throw new OctaneSdkException("Invalid sector specified (" + sector + ")");
    }

    static short[] ringToAntennaIds(short ring) throws OctaneSdkException {
        switch (ring) {
            case 1: {
                return new short[]{1, 2, 3, 4};
            }
            case 2: {
                return new short[]{5, 6, 7, 8, 9, 10, 11, 12};
            }
            case 3: {
                return new short[]{13, 14, 15, 16, 17, 18, 19, 20};
            }
            case 4: {
                return new short[]{21, 22, 23, 24, 25, 26, 27, 28};
            }
            case 5: {
                return new short[]{29, 30, 31, 32, 33, 34, 35, 36};
            }
            case 6: {
                return new short[]{37, 38, 39, 40, 41, 42, 43, 44};
            }
            case 7: {
                return new short[]{45, 46, 47, 48, 49, 50, 51, 52};
            }
        }
        throw new OctaneSdkException("Invalid ring specified (" + ring + ")");
    }

    @Override
    public Iterator<AntennaConfig> iterator() {
        return this.antennaConfigs.iterator();
    }

    protected void add(Object config) throws OctaneSdkException {
        if (!this.antennaCollectionCreatedBySerializer) {
            throw new OctaneSdkException("Illegal operation - cannot Add to AntennaConfigGroup object!");
        }
        this.antennaConfigs.add((AntennaConfig)config);
    }

    public ArrayList<AntennaConfig> getAntennaConfigs() {
        return this.antennaConfigs;
    }

    public void setAntennaConfigs(ArrayList<AntennaConfig> antennaConfigs) {
        this.antennaConfigs = antennaConfigs;
    }

    public double getRxSensitivityinDbm() {
        return this.rxSensitivityinDbm;
    }

    public void setRxSensitivityinDbm(double rxSensitivityinDbm) {
        this.rxSensitivityinDbm = rxSensitivityinDbm;
        for (int i = 0; i < this.antennaConfigs.size(); ++i) {
            this.antennaConfigs.get(i).setRxSensitivityinDbm(rxSensitivityinDbm);
        }
    }

    public double getTxPowerinDbm() {
        return this.txPowerinDbm;
    }

    public void setTxPowerinDbm(double txPowerinDbm) {
        this.txPowerinDbm = txPowerinDbm;
        for (AntennaConfig antennaConfig : this.antennaConfigs) {
            antennaConfig.setTxPowerinDbm(txPowerinDbm);
        }
    }

    public Boolean getIsMaxRxSensitivity() {
        return this.isMaxRxSensitivity;
    }

    public void setIsMaxRxSensitivity(Boolean maxRxSensitivity) {
        this.isMaxRxSensitivity = maxRxSensitivity;
        for (AntennaConfig antennaConfig : this.antennaConfigs) {
            antennaConfig.setIsMaxRxSensitivity(maxRxSensitivity);
        }
    }

    public Boolean getIsMaxTxPower() {
        return this.isMaxTxPower;
    }

    public void setIsMaxTxPower(Boolean maxTxPower) {
        this.isMaxTxPower = maxTxPower;
        for (AntennaConfig antennaConfig : this.antennaConfigs) {
            antennaConfig.setIsMaxTxPower(maxTxPower);
        }
    }

    public void enableAll() {
        for (AntennaConfig antennaConfig : this.antennaConfigs) {
            antennaConfig.setEnabled(true);
        }
    }

    public void disableAll() {
        for (AntennaConfig antennaConfig : this.antennaConfigs) {
            antennaConfig.setEnabled(false);
        }
    }

    private void checkIdListLength(int numberOfAntennas) throws OctaneSdkException {
        if (numberOfAntennas > this.antennaConfigs.size()) {
            throw new OctaneSdkException("Number of antenna IDs provided (" + numberOfAntennas + ") is greater than the number of available antennas (" + this.antennaConfigs.size() + ")");
        }
    }

    public AntennaConfig getAntenna(Number portNumber) throws OctaneSdkException {
        for (AntennaConfig antenna : this.antennaConfigs) {
            if (antenna.getPortNumber() != portNumber.shortValue()) continue;
            return antenna;
        }
        throw new OctaneSdkException("Invalid antenna port number specified.");
    }

    public void enableById(short[] ids) throws OctaneSdkException {
        this.checkIdListLength(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            this.getAntenna(ids[i]).setEnabled(true);
        }
    }

    public void enableById(List<? extends Number> ids) throws OctaneSdkException {
        this.checkIdListLength(ids.size());
        for (Number number : ids) {
            this.getAntenna(number).setEnabled(true);
        }
    }

    public void disableById(short[] ids) throws OctaneSdkException {
        this.checkIdListLength(ids.length);
        for (int i = 0; i < ids.length; ++i) {
            this.getAntenna(ids[i]).setEnabled(false);
        }
    }

    public void disableById(List<? extends Number> ids) throws OctaneSdkException {
        this.checkIdListLength(ids.size());
        for (Number number : ids) {
            this.getAntenna(number).setEnabled(false);
        }
    }

    @Deprecated
    public void enableBySector(short[] sectors) throws OctaneSdkException {
        for (short sector : sectors) {
            short[] ids = AntennaConfigGroup.sectorToAntennaIds(sector);
            this.enableById(ids);
        }
    }

    @Deprecated
    public void disableBySector(short[] sectors) throws OctaneSdkException {
        for (short sector : sectors) {
            short[] ids = AntennaConfigGroup.sectorToAntennaIds(sector);
            this.disableById(ids);
        }
    }

    @Deprecated
    public void enableByRing(short[] rings) throws OctaneSdkException {
        for (short ring : rings) {
            short[] ids = AntennaConfigGroup.ringToAntennaIds(ring);
            this.enableById(ids);
        }
    }

    @Deprecated
    public void disableByRing(short[] rings) throws OctaneSdkException {
        for (short ring : rings) {
            short[] ids = AntennaConfigGroup.ringToAntennaIds(ring);
            this.disableById(ids);
        }
    }

    public void enablePolarizedAntennas() {
        if (!this.polarizationEnabled) {
            short i;
            this.polarizationEnabled = true;
            for (i = 1001; i <= 1052; i = (short)(i + 1)) {
                if (this.antennaConfigs.contains(i)) continue;
                this.antennaConfigs.add(new AntennaConfig(i));
            }
            for (i = 2001; i <= 2052; i = (short)(i + 1)) {
                if (this.antennaConfigs.contains(i)) continue;
                this.antennaConfigs.add(new AntennaConfig(i));
            }
        }
    }

    public void disablePolarizedAntennas() {
        if (this.polarizationEnabled) {
            this.polarizationEnabled = false;
            for (int i = this.antennaConfigs.size() - 1; i >= 0; --i) {
                short port = this.antennaConfigs.get(i).getPortNumber();
                if (port <= 1000) continue;
                this.antennaConfigs.remove(i);
            }
        }
    }

    public boolean getPolarizationEnabled() {
        return this.polarizationEnabled;
    }
}

