/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionFieldOfView;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionUserTagPopulationLimit;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjDirectionConfig
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1569);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjDirectionConfig.class);
    protected UnsignedShort tagAgeIntervalSeconds;
    protected UnsignedShort updateIntervalSeconds;
    protected ImpinjDirectionFieldOfView fieldOfView;
    private ImpinjDirectionUserTagPopulationLimit impinjDirectionUserTagPopulationLimit;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjDirectionConfig() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjDirectionConfig(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjDirectionConfig(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1569);
        this.decodeXML(element);
    }

    public ImpinjDirectionConfig(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.tagAgeIntervalSeconds == null) {
            LOGGER.warn(" tagAgeIntervalSeconds not set");
        }
        resultBits.append(this.tagAgeIntervalSeconds.encodeBinary());
        if (this.updateIntervalSeconds == null) {
            LOGGER.warn(" updateIntervalSeconds not set");
        }
        resultBits.append(this.updateIntervalSeconds.encodeBinary());
        if (this.fieldOfView == null) {
            LOGGER.warn(" fieldOfView not set");
        }
        resultBits.append(this.fieldOfView.encodeBinary());
        if (this.impinjDirectionUserTagPopulationLimit != null) {
            LOGGER.info(" impinjDirectionUserTagPopulationLimit not set");
            resultBits.append(this.impinjDirectionUserTagPopulationLimit.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.tagAgeIntervalSeconds == null) {
            LOGGER.warn(" tagAgeIntervalSeconds not set");
            throw new MissingParameterException(" tagAgeIntervalSeconds not set");
        }
        element.addContent(this.tagAgeIntervalSeconds.encodeXML("TagAgeIntervalSeconds", ns));
        if (this.updateIntervalSeconds == null) {
            LOGGER.warn(" updateIntervalSeconds not set");
            throw new MissingParameterException(" updateIntervalSeconds not set");
        }
        element.addContent(this.updateIntervalSeconds.encodeXML("UpdateIntervalSeconds", ns));
        if (this.fieldOfView == null) {
            LOGGER.warn(" fieldOfView not set");
            throw new MissingParameterException(" fieldOfView not set");
        }
        element.addContent(this.fieldOfView.encodeXML("FieldOfView", ns));
        if (this.impinjDirectionUserTagPopulationLimit == null) {
            LOGGER.info("impinjDirectionUserTagPopulationLimit not set");
        } else {
            element.addContent(this.impinjDirectionUserTagPopulationLimit.encodeXML(this.impinjDirectionUserTagPopulationLimit.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.tagAgeIntervalSeconds = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.updateIntervalSeconds = new UnsignedShort(binary.subList(position += UnsignedShort.length(), UnsignedShort.length()));
        this.fieldOfView = new ImpinjDirectionFieldOfView(binary.subList(position += UnsignedShort.length(), ImpinjDirectionFieldOfView.length()));
        if ((position += ImpinjDirectionFieldOfView.length()) < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                UnsignedInteger vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                UnsignedInteger subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjDirectionUserTagPopulationLimit.VENDOR_ID) && subType.equals(ImpinjDirectionUserTagPopulationLimit.PARAMETER_SUBTYPE)) {
                    this.impinjDirectionUserTagPopulationLimit = new ImpinjDirectionUserTagPopulationLimit(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("TagAgeIntervalSeconds", element.getNamespace());
        if (temp != null) {
            this.tagAgeIntervalSeconds = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("UpdateIntervalSeconds", element.getNamespace())) != null) {
            this.updateIntervalSeconds = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("FieldOfView", element.getNamespace())) != null) {
            this.fieldOfView = new ImpinjDirectionFieldOfView(temp);
        }
        if ((temp = element.getChild("ImpinjDirectionUserTagPopulationLimit", element.getNamespace())) == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjDirectionUserTagPopulationLimit", llrpns);
        }
        if (temp != null) {
            this.impinjDirectionUserTagPopulationLimit = new ImpinjDirectionUserTagPopulationLimit(temp);
            LOGGER.info("setting parameter impinjDirectionUserTagPopulationLimit for parameter ImpinjDirectionConfig");
        } else {
            LOGGER.info("ImpinjDirectionConfig misses non optional parameter of type impinjDirectionUserTagPopulationLimit");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjDirectionConfig misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setTagAgeIntervalSeconds(UnsignedShort tagAgeIntervalSeconds) {
        this.tagAgeIntervalSeconds = tagAgeIntervalSeconds;
    }

    public void setUpdateIntervalSeconds(UnsignedShort updateIntervalSeconds) {
        this.updateIntervalSeconds = updateIntervalSeconds;
    }

    public void setFieldOfView(ImpinjDirectionFieldOfView fieldOfView) {
        this.fieldOfView = fieldOfView;
    }

    public void setImpinjDirectionUserTagPopulationLimit(ImpinjDirectionUserTagPopulationLimit impinjDirectionUserTagPopulationLimit) {
        this.impinjDirectionUserTagPopulationLimit = impinjDirectionUserTagPopulationLimit;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getTagAgeIntervalSeconds() {
        return this.tagAgeIntervalSeconds;
    }

    public UnsignedShort getUpdateIntervalSeconds() {
        return this.updateIntervalSeconds;
    }

    public ImpinjDirectionFieldOfView getFieldOfView() {
        return this.fieldOfView;
    }

    public ImpinjDirectionUserTagPopulationLimit getImpinjDirectionUserTagPopulationLimit() {
        return this.impinjDirectionUserTagPopulationLimit;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

