/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionReportData;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationReportData;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.EPCData;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjExtendedTagInformation
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1552);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjExtendedTagInformation.class);
    private List<EPCData> ePCDataList = new LinkedList<EPCData>();
    private ImpinjLocationReportData impinjLocationReportData;
    private ImpinjDirectionReportData impinjDirectionReportData;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjExtendedTagInformation() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjExtendedTagInformation(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjExtendedTagInformation(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1552);
        this.decodeXML(element);
    }

    public ImpinjExtendedTagInformation(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.ePCDataList == null) {
            LOGGER.info(" ePCDataList not set");
        }
        for (EPCData ePCData : this.ePCDataList) {
            resultBits.append(ePCData.encodeBinary());
        }
        if (this.impinjLocationReportData != null) {
            LOGGER.info(" impinjLocationReportData not set");
            resultBits.append(this.impinjLocationReportData.encodeBinary());
        }
        if (this.impinjDirectionReportData != null) {
            LOGGER.info(" impinjDirectionReportData not set");
            resultBits.append(this.impinjDirectionReportData.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.ePCDataList == null) {
            LOGGER.warn(" ePCDataList not set");
            throw new MissingParameterException("  ePCDataList not set");
        }
        for (EPCData ePCData : this.ePCDataList) {
            element.addContent(ePCData.encodeXML(ePCData.getClass().getName().replaceAll(ePCData.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.impinjLocationReportData == null) {
            LOGGER.info("impinjLocationReportData not set");
        } else {
            element.addContent(this.impinjLocationReportData.encodeXML(this.impinjLocationReportData.getClass().getSimpleName(), ns));
        }
        if (this.impinjDirectionReportData == null) {
            LOGGER.info("impinjDirectionReportData not set");
        } else {
            element.addContent(this.impinjDirectionReportData.encodeXML(this.impinjDirectionReportData.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        short tempByteLength;
        SignedShort _type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.ePCDataList = new LinkedList<EPCData>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (!_type.equals(EPCData.TYPENUM)) break;
            this.ePCDataList.add(new EPCData(binary.subList(position, tempLength)));
            position += tempLength;
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                UnsignedInteger vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjLocationReportData.VENDOR_ID) && subType.equals(ImpinjLocationReportData.PARAMETER_SUBTYPE)) {
                    this.impinjLocationReportData = new ImpinjLocationReportData(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                UnsignedInteger vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjDirectionReportData.VENDOR_ID) && subType.equals(ImpinjDirectionReportData.PARAMETER_SUBTYPE)) {
                    this.impinjDirectionReportData = new ImpinjDirectionReportData(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        this.ePCDataList = new LinkedList<EPCData>();
        tempList = element.getChildren("EPCData", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("EPCData", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn("ImpinjExtendedTagInformation misses non optional parameter of type ePCDataList");
            throw new MissingParameterException("ImpinjExtendedTagInformation misses non optional parameter of type ePCDataList");
        }
        for (Element e : tempList) {
            this.ePCDataList.add(new EPCData(e));
            LOGGER.debug("adding EPCData to ePCDataList ");
        }
        temp = element.getChild("ImpinjLocationReportData", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjLocationReportData", (Namespace)llrpns);
        }
        if (temp != null) {
            this.impinjLocationReportData = new ImpinjLocationReportData(temp);
            LOGGER.info("setting parameter impinjLocationReportData for parameter ImpinjExtendedTagInformation");
        } else {
            LOGGER.info("ImpinjExtendedTagInformation misses non optional parameter of type impinjLocationReportData");
        }
        temp = element.getChild("ImpinjDirectionReportData", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjDirectionReportData", (Namespace)llrpns);
        }
        if (temp != null) {
            this.impinjDirectionReportData = new ImpinjDirectionReportData(temp);
            LOGGER.info("setting parameter impinjDirectionReportData for parameter ImpinjExtendedTagInformation");
        } else {
            LOGGER.info("ImpinjExtendedTagInformation misses non optional parameter of type impinjDirectionReportData");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjExtendedTagInformation misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setEPCDataList(List<EPCData> ePCDataList) {
        this.ePCDataList = ePCDataList;
    }

    public void setImpinjLocationReportData(ImpinjLocationReportData impinjLocationReportData) {
        this.impinjLocationReportData = impinjLocationReportData;
    }

    public void setImpinjDirectionReportData(ImpinjDirectionReportData impinjDirectionReportData) {
        this.impinjDirectionReportData = impinjDirectionReportData;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public List<EPCData> getEPCDataList() {
        return this.ePCDataList;
    }

    public ImpinjLocationReportData getImpinjLocationReportData() {
        return this.impinjLocationReportData;
    }

    public ImpinjDirectionReportData getImpinjDirectionReportData() {
        return this.impinjDirectionReportData;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToEPCDataList(EPCData ePCData) {
        if (this.ePCDataList == null) {
            this.ePCDataList = new LinkedList<EPCData>();
        }
        this.ePCDataList.add(ePCData);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

