/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjArrayVersion;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;

public class ImpinjHubVersions
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1537);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjHubVersions.class);
    private List<ImpinjArrayVersion> impinjArrayVersionList = new LinkedList<ImpinjArrayVersion>();
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjHubVersions() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjHubVersions(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjHubVersions(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1537);
        this.decodeXML(element);
    }

    public ImpinjHubVersions(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.impinjArrayVersionList == null) {
            LOGGER.info(" impinjArrayVersionList not set");
        }
        for (ImpinjArrayVersion impinjArrayVersion : this.impinjArrayVersionList) {
            resultBits.append(impinjArrayVersion.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.impinjArrayVersionList == null) {
            LOGGER.warn(" impinjArrayVersionList not set");
            throw new MissingParameterException("  impinjArrayVersionList not set");
        }
        for (ImpinjArrayVersion impinjArrayVersion : this.impinjArrayVersionList) {
            element.addContent(impinjArrayVersion.encodeXML(impinjArrayVersion.getClass().getName().replaceAll(impinjArrayVersion.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.impinjArrayVersionList = new LinkedList<ImpinjArrayVersion>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (!_type.equals(ImpinjArrayVersion.TYPENUM)) break;
            this.impinjArrayVersionList.add(new ImpinjArrayVersion(binary.subList(position, tempLength)));
            position += tempLength;
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object llrpns;
        Object temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        this.impinjArrayVersionList = new LinkedList<ImpinjArrayVersion>();
        tempList = element.getChildren("ImpinjArrayVersion", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("ImpinjArrayVersion", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn("ImpinjHubVersions misses non optional parameter of type impinjArrayVersionList");
            throw new MissingParameterException("ImpinjHubVersions misses non optional parameter of type impinjArrayVersionList");
        }
        for (Element e : tempList) {
            this.impinjArrayVersionList.add(new ImpinjArrayVersion(e));
            LOGGER.debug("adding ImpinjArrayVersion to impinjArrayVersionList ");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjHubVersions misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setImpinjArrayVersionList(List<ImpinjArrayVersion> impinjArrayVersionList) {
        this.impinjArrayVersionList = impinjArrayVersionList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public List<ImpinjArrayVersion> getImpinjArrayVersionList() {
        return this.impinjArrayVersionList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToImpinjArrayVersionList(ImpinjArrayVersion impinjArrayVersion) {
        if (this.impinjArrayVersionList == null) {
            this.impinjArrayVersionList = new LinkedList<ImpinjArrayVersion>();
        }
        this.impinjArrayVersionList.add(impinjArrayVersion);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

