/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjLocationReportType;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationConfidence;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedInteger;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedLong;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjLocationReportData
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1545);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjLocationReportData.class);
    protected UnsignedLong lastSeenTimestampUTC;
    protected SignedInteger locXCentimeters;
    protected SignedInteger locYCentimeters;
    protected ImpinjLocationReportType type;
    private ImpinjLocationConfidence impinjLocationConfidence;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjLocationReportData() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjLocationReportData(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjLocationReportData(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1545);
        this.decodeXML(element);
    }

    public ImpinjLocationReportData(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.lastSeenTimestampUTC == null) {
            LOGGER.warn(" lastSeenTimestampUTC not set");
        }
        resultBits.append(this.lastSeenTimestampUTC.encodeBinary());
        if (this.locXCentimeters == null) {
            LOGGER.warn(" locXCentimeters not set");
        }
        resultBits.append(this.locXCentimeters.encodeBinary());
        if (this.locYCentimeters == null) {
            LOGGER.warn(" locYCentimeters not set");
        }
        resultBits.append(this.locYCentimeters.encodeBinary());
        if (this.type == null) {
            LOGGER.warn(" type not set");
        }
        resultBits.append(this.type.encodeBinary());
        if (this.impinjLocationConfidence == null) {
            LOGGER.warn(" impinjLocationConfidence not set");
        }
        resultBits.append(this.impinjLocationConfidence.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.lastSeenTimestampUTC == null) {
            LOGGER.warn(" lastSeenTimestampUTC not set");
            throw new MissingParameterException(" lastSeenTimestampUTC not set");
        }
        element.addContent(this.lastSeenTimestampUTC.encodeXML("LastSeenTimestampUTC", ns));
        if (this.locXCentimeters == null) {
            LOGGER.warn(" locXCentimeters not set");
            throw new MissingParameterException(" locXCentimeters not set");
        }
        element.addContent(this.locXCentimeters.encodeXML("LocXCentimeters", ns));
        if (this.locYCentimeters == null) {
            LOGGER.warn(" locYCentimeters not set");
            throw new MissingParameterException(" locYCentimeters not set");
        }
        element.addContent(this.locYCentimeters.encodeXML("LocYCentimeters", ns));
        if (this.type == null) {
            LOGGER.warn(" type not set");
            throw new MissingParameterException(" type not set");
        }
        element.addContent(this.type.encodeXML("Type", ns));
        if (this.impinjLocationConfidence == null) {
            LOGGER.info("impinjLocationConfidence not set");
            throw new MissingParameterException("impinjLocationConfidence not set");
        }
        element.addContent(this.impinjLocationConfidence.encodeXML(this.impinjLocationConfidence.getClass().getSimpleName(), ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.lastSeenTimestampUTC = new UnsignedLong(binary.subList(position, UnsignedLong.length()));
        this.locXCentimeters = new SignedInteger(binary.subList(position += UnsignedLong.length(), SignedInteger.length()));
        this.locYCentimeters = new SignedInteger(binary.subList(position += SignedInteger.length(), SignedInteger.length()));
        this.type = new ImpinjLocationReportType(binary.subList(position += SignedInteger.length(), ImpinjLocationReportType.length()));
        if (binary.get(position += ImpinjLocationReportType.length())) {
            _type = new SignedShort(binary.subList(position + 1, 7));
        } else {
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
            tempLength = 8 * tempByteLength;
        }
        if (Custom.TYPENUM.equals(_type)) {
            UnsignedInteger vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
            UnsignedInteger subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
            if (vendor.equals(ImpinjLocationConfidence.VENDOR_ID) && subType.equals(ImpinjLocationConfidence.PARAMETER_SUBTYPE)) {
                this.impinjLocationConfidence = new ImpinjLocationConfidence(binary.subList(position, tempLength));
                position += tempLength;
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("LastSeenTimestampUTC", element.getNamespace());
        if (temp != null) {
            this.lastSeenTimestampUTC = new UnsignedLong(temp);
        }
        if ((temp = element.getChild("LocXCentimeters", element.getNamespace())) != null) {
            this.locXCentimeters = new SignedInteger(temp);
        }
        if ((temp = element.getChild("LocYCentimeters", element.getNamespace())) != null) {
            this.locYCentimeters = new SignedInteger(temp);
        }
        if ((temp = element.getChild("Type", element.getNamespace())) != null) {
            this.type = new ImpinjLocationReportType(temp);
        }
        if ((temp = element.getChild("ImpinjLocationConfidence", element.getNamespace())) == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjLocationConfidence", llrpns);
        }
        if (temp == null) {
            LOGGER.warn("ImpinjLocationReportData misses non optional parameter of type impinjLocationConfidence");
            throw new MissingParameterException("ImpinjLocationReportData misses non optional parameter of type impinjLocationConfidence");
        }
        this.impinjLocationConfidence = new ImpinjLocationConfidence(temp);
        LOGGER.info("setting parameter impinjLocationConfidence for parameter ImpinjLocationReportData");
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjLocationReportData misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setLastSeenTimestampUTC(UnsignedLong lastSeenTimestampUTC) {
        this.lastSeenTimestampUTC = lastSeenTimestampUTC;
    }

    public void setLocXCentimeters(SignedInteger locXCentimeters) {
        this.locXCentimeters = locXCentimeters;
    }

    public void setLocYCentimeters(SignedInteger locYCentimeters) {
        this.locYCentimeters = locYCentimeters;
    }

    public void setType(ImpinjLocationReportType type) {
        this.type = type;
    }

    public void setImpinjLocationConfidence(ImpinjLocationConfidence impinjLocationConfidence) {
        this.impinjLocationConfidence = impinjLocationConfidence;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedLong getLastSeenTimestampUTC() {
        return this.lastSeenTimestampUTC;
    }

    public SignedInteger getLocXCentimeters() {
        return this.locXCentimeters;
    }

    public SignedInteger getLocYCentimeters() {
        return this.locYCentimeters;
    }

    public ImpinjLocationReportType getType() {
        return this.type;
    }

    public ImpinjLocationConfidence getImpinjLocationConfidence() {
        return this.impinjLocationConfidence;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

