/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.BytesToEnd_HEX;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;

public class CUSTOM_MESSAGE
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(1023);
    private static final Logger LOGGER = Logger.getLogger(CUSTOM_MESSAGE.class);
    public static final String RESPONSETYPE = "";
    protected UnsignedInteger vendorIdentifier;
    protected UnsignedByte messageSubtype;
    protected BytesToEnd_HEX data;

    public CUSTOM_MESSAGE() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public CUSTOM_MESSAGE(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list);
    }

    public CUSTOM_MESSAGE(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public CUSTOM_MESSAGE(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
            throw new InvalidLLRPMessageException(" vendorIdentifier not set  for Parameter of Type CUSTOM_MESSAGE");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.messageSubtype == null) {
            LOGGER.warn(" messageSubtype not set");
            throw new InvalidLLRPMessageException(" messageSubtype not set  for Parameter of Type CUSTOM_MESSAGE");
        }
        resultBits.append(this.messageSubtype.encodeBinary());
        if (this.data == null) {
            LOGGER.warn(" data not set");
            throw new InvalidLLRPMessageException(" data not set  for Parameter of Type CUSTOM_MESSAGE");
        }
        resultBits.append(this.data.encodeBinary());
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("CUSTOM_MESSAGE", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.vendorIdentifier == null) {
                LOGGER.warn(" vendorIdentifier not set");
                throw new MissingParameterException(" vendorIdentifier not set");
            }
            root.addContent(this.vendorIdentifier.encodeXML("VendorIdentifier", ns));
            if (this.messageSubtype == null) {
                LOGGER.warn(" messageSubtype not set");
                throw new MissingParameterException(" messageSubtype not set");
            }
            root.addContent(this.messageSubtype.encodeXML("MessageSubtype", ns));
            if (this.data == null) {
                LOGGER.warn(" data not set");
                throw new MissingParameterException(" data not set");
            }
            root.addContent(this.data.encodeXML("Data", ns));
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        boolean tempLength = false;
        this.vendorIdentifier = new UnsignedInteger(binary, position, UnsignedInteger.length());
        this.messageSubtype = new UnsignedByte(binary, position += UnsignedInteger.length(), UnsignedByte.length());
        this.data = new BytesToEnd_HEX(binary, position += UnsignedByte.length(), binary.length() - position);
        position += binary.length() - position;
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            Object tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute.trim()));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID").trim());
            temp = root.getChild("VendorIdentifier", root.getNamespace());
            if (temp == null) {
                LOGGER.warn("Element vendorIdentifier not provided in xml as child of " + root.getName());
                throw new MissingParameterException("Element vendorIdentifier not provided");
            }
            this.vendorIdentifier = new UnsignedInteger(temp);
            root.removeChild("VendorIdentifier", root.getNamespace());
            temp = root.getChild("MessageSubtype", root.getNamespace());
            if (temp == null) {
                LOGGER.warn("Element messageSubtype not provided in xml as child of " + root.getName());
                throw new MissingParameterException("Element messageSubtype not provided");
            }
            this.messageSubtype = new UnsignedByte(temp);
            root.removeChild("MessageSubtype", root.getNamespace());
            temp = root.getChild("Data", root.getNamespace());
            if (temp == null) {
                LOGGER.warn("Element data not provided in xml as child of " + root.getName());
                throw new MissingParameterException("Element data not provided");
            }
            this.data = new BytesToEnd_HEX(temp);
            root.removeChild("Data", root.getNamespace());
            if (root.getChildren().size() > 0) {
                String message = "CUSTOM_MESSAGE has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setVendorIdentifier(UnsignedInteger vendorIdentifier) {
        this.vendorIdentifier = vendorIdentifier;
    }

    public void setMessageSubtype(UnsignedByte messageSubtype) {
        this.messageSubtype = messageSubtype;
    }

    public void setData(BytesToEnd_HEX data) {
        this.data = data;
    }

    public UnsignedInteger getVendorIdentifier() {
        return this.vendorIdentifier;
    }

    public UnsignedByte getMessageSubtype() {
        return this.messageSubtype;
    }

    public BytesToEnd_HEX getData() {
        return this.data;
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "CUSTOM_MESSAGE";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

