/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.enumerations.StatusCode;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class FieldError
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(288);
    private static final Logger LOGGER = Logger.getLogger(FieldError.class);
    protected UnsignedShort fieldNum;
    protected StatusCode errorCode;

    public FieldError() {
    }

    public FieldError(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public FieldError(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public FieldError(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.fieldNum == null) {
            LOGGER.warn(" fieldNum not set");
            throw new MissingParameterException(" fieldNum not set  for Parameter of Type FieldError");
        }
        resultBits.append(this.fieldNum.encodeBinary());
        if (this.errorCode == null) {
            LOGGER.warn(" errorCode not set");
            throw new MissingParameterException(" errorCode not set  for Parameter of Type FieldError");
        }
        resultBits.append(this.errorCode.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.fieldNum == null) {
            LOGGER.warn(" fieldNum not set");
            throw new MissingParameterException(" fieldNum not set");
        }
        element.addContent(this.fieldNum.encodeXML("FieldNum", ns));
        if (this.errorCode == null) {
            LOGGER.warn(" errorCode not set");
            throw new MissingParameterException(" errorCode not set");
        }
        element.addContent(this.errorCode.encodeXML("ErrorCode", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.fieldNum = new UnsignedShort(binary, position, UnsignedShort.length());
        this.errorCode = new StatusCode(binary, position += UnsignedShort.length(), StatusCode.length());
        position += StatusCode.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("FieldNum", ns);
        if (temp != null) {
            this.fieldNum = new UnsignedShort(temp);
        }
        element.removeChild("FieldNum", ns);
        temp = element.getChild("ErrorCode", ns);
        if (temp != null) {
            this.errorCode = new StatusCode(temp);
        }
        element.removeChild("ErrorCode", ns);
        if (element.getChildren().size() > 0) {
            String message = "FieldError has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setFieldNum(UnsignedShort fieldNum) {
        this.fieldNum = fieldNum;
    }

    public void setErrorCode(StatusCode errorCode) {
        this.errorCode = errorCode;
    }

    public UnsignedShort getFieldNum() {
        return this.fieldNum;
    }

    public StatusCode getErrorCode() {
        return this.errorCode;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "FieldError";
    }

    public String toString() {
        String result = "FieldError: ";
        result = result + ", fieldNum: ";
        result = result + this.fieldNum;
        result = result + ", errorCode: ";
        result = result + this.errorCode;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

