/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.net;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.log4j.Logger;
import org.apache.mina.core.session.IdleStatus;
import org.apache.mina.core.session.IoSession;
import org.llrp.ltk.generated.messages.KEEPALIVE;
import org.llrp.ltk.generated.messages.KEEPALIVE_ACK;
import org.llrp.ltk.generated.messages.READER_EVENT_NOTIFICATION;
import org.llrp.ltk.generated.messages.RO_ACCESS_REPORT;
import org.llrp.ltk.generated.parameters.ConnectionAttemptEvent;
import org.llrp.ltk.net.LLRPConnection;
import org.llrp.ltk.net.LLRPIoHandlerAdapter;
import org.llrp.ltk.types.LLRPMessage;

public class LLRPIoHandlerAdapterImpl
extends LLRPIoHandlerAdapter {
    private Logger log = Logger.getLogger(LLRPIoHandlerAdapterImpl.class);
    private LLRPConnection connection;
    private BlockingQueue<LLRPMessage> synMessageQueue = new LinkedBlockingQueue<LLRPMessage>();
    private BlockingQueue<ConnectionAttemptEvent> connectionAttemptEventQueue = new LinkedBlockingQueue<ConnectionAttemptEvent>(1);
    private boolean keepAliveAck = true;
    private boolean keepAliveForward = false;

    public LLRPIoHandlerAdapterImpl(LLRPConnection connection) {
        this.connection = connection;
    }

    public LLRPIoHandlerAdapterImpl() {
    }

    @Override
    public void sessionOpened(IoSession session) throws Exception {
        this.log.debug("session is opened:" + session);
        this.connection.session = session;
    }

    @Override
    public void messageReceived(IoSession session, Object message) throws Exception {
        ConnectionAttemptEvent connectionAttemptEvent;
        LLRPMessage llrpMessage = (LLRPMessage)message;
        if (this.log.isDebugEnabled()) {
            this.log.debug("message " + message.getClass() + " received in session " + session);
            this.log.debug(llrpMessage.toXMLString());
        }
        if (llrpMessage instanceof RO_ACCESS_REPORT) {
            this.connection.getEndpoint().messageReceived(llrpMessage);
            return;
        }
        if (message instanceof KEEPALIVE) {
            if (this.keepAliveForward) {
                this.connection.getEndpoint().messageReceived(llrpMessage);
            }
            if (this.keepAliveAck) {
                session.write(new KEEPALIVE_ACK());
            }
            return;
        }
        if (llrpMessage instanceof READER_EVENT_NOTIFICATION && (connectionAttemptEvent = ((READER_EVENT_NOTIFICATION)message).getReaderEventNotificationData().getConnectionAttemptEvent()) != null) {
            this.connectionAttemptEventQueue.add(connectionAttemptEvent);
            this.connection.getEndpoint().messageReceived(llrpMessage);
            return;
        }
        String expectedSyncMessage = (String)session.getAttribute("synchronousMessageAnswer");
        if (!llrpMessage.getName().equals(expectedSyncMessage)) {
            this.log.debug("Calling messageReceived of endpoint ... " + session);
            this.connection.getEndpoint().messageReceived(llrpMessage);
        } else {
            this.synMessageQueue.add(llrpMessage);
            this.log.debug("Adding message " + message.getClass() + " to transaction queue " + session);
        }
    }

    @Override
    public void messageSent(IoSession session, Object message) throws Exception {
        if (this.log.isInfoEnabled()) {
            this.log.info("Message " + ((LLRPMessage)message).getName() + " successfully transmitted");
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(((LLRPMessage)message).toXMLString());
        }
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.connection.getEndpoint().errorOccured(cause.getClass().getName());
    }

    @Override
    public void sessionIdle(IoSession session, IdleStatus status) throws Exception {
        System.out.println("IDLE " + session.getIdleCount(status));
    }

    @Override
    public BlockingQueue<LLRPMessage> getSynMessageQueue() {
        return this.synMessageQueue;
    }

    @Override
    public BlockingQueue<ConnectionAttemptEvent> getConnectionAttemptEventQueue() {
        return this.connectionAttemptEventQueue;
    }

    @Override
    public boolean isKeepAliveAck() {
        return this.keepAliveAck;
    }

    @Override
    public void setKeepAliveAck(boolean keepAliveAck) {
        this.keepAliveAck = keepAliveAck;
    }

    @Override
    public boolean isKeepAliveForward() {
        return this.keepAliveForward;
    }

    @Override
    public void setKeepAliveForward(boolean keepAliveForward) {
        this.keepAliveForward = keepAliveForward;
    }

    @Override
    public LLRPConnection getConnection() {
        return this.connection;
    }

    @Override
    public void setConnection(LLRPConnection connection) {
        this.connection = connection;
    }
}

