/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.GpoConfig;
import com.impinj.octane.OctaneSdkException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class GpoConfigGroup
implements Iterable<GpoConfig> {
    static final int GPO_PORT_START_INDEX = 1;
    private List<GpoConfig> gpoConfigs = new ArrayList<GpoConfig>();
    private boolean gpoCollectionCreatedBySerializer = false;

    GpoConfigGroup() {
    }

    GpoConfigGroup(int numGpos) {
        for (int i = 0; i < numGpos; ++i) {
            this.gpoConfigs.add(new GpoConfig());
        }
    }

    public GpoConfig get(int i) {
        return this.gpoConfigs.get(i);
    }

    public void set(int i, GpoConfig newValue) {
        this.gpoConfigs.set(i, newValue);
    }

    protected void add(Object config) throws OctaneSdkException {
        if (!this.gpoCollectionCreatedBySerializer) {
            throw new OctaneSdkException("Illegal operation - cannot Add to GPOConfigGroup object!");
        }
        this.gpoConfigs.add((GpoConfig)config);
    }

    public GpoConfig getGpo(short portNumber) throws OctaneSdkException {
        for (GpoConfig gpo : this.gpoConfigs) {
            if (gpo.getPortNumber() != portNumber) continue;
            return gpo;
        }
        throw new OctaneSdkException("Invalid GPO port number specified.");
    }

    @Override
    public Iterator<GpoConfig> iterator() {
        return this.gpoConfigs.iterator();
    }
}

