/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

public class BlockPermalockMask {
    private short[] mask;

    public static BlockPermalockMask fromBlockNumber(short block) {
        return BlockPermalockMask.fromBlockNumberArray(new short[]{block});
    }

    public static BlockPermalockMask fromBlockNumberArray(short[] blocks) {
        BlockPermalockMask result = new BlockPermalockMask();
        int maxBlock = 0;
        for (short block : blocks) {
            maxBlock = (short)Math.max(block, maxBlock);
        }
        short[] mask = new short[maxBlock / 16 + 1];
        for (short block : blocks) {
            short index;
            short s = index = (short)(block / 16);
            mask[s] = (short)(mask[s] | (short)(32768 >> block - index * 16));
        }
        result.setMask(mask);
        return result;
    }

    public short[] getMask() {
        return this.mask;
    }

    private void setMask(short[] mask) {
        this.mask = mask;
    }

    public String toHexWordString() {
        String result = "";
        for (short word : this.mask) {
            result = result + String.format("%04x ", 0xFFFF & word).toUpperCase();
        }
        return result;
    }
}

