/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.custom.parameters.ImpinjAntennaPolarizationCapability;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;

public class ImpinjAntennaCapabilities
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1563);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjAntennaCapabilities.class);
    private List<ImpinjAntennaPolarizationCapability> impinjAntennaPolarizationCapabilityList = new LinkedList<ImpinjAntennaPolarizationCapability>();
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjAntennaCapabilities() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjAntennaCapabilities(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjAntennaCapabilities(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1563);
        this.decodeXML(element);
    }

    public ImpinjAntennaCapabilities(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.impinjAntennaPolarizationCapabilityList == null) {
            LOGGER.info(" impinjAntennaPolarizationCapabilityList not set");
        } else {
            for (ImpinjAntennaPolarizationCapability impinjAntennaPolarizationCapability : this.impinjAntennaPolarizationCapabilityList) {
                resultBits.append(impinjAntennaPolarizationCapability.encodeBinary());
            }
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.impinjAntennaPolarizationCapabilityList == null) {
            LOGGER.info("impinjAntennaPolarizationCapabilityList not set");
        } else {
            for (ImpinjAntennaPolarizationCapability impinjAntennaPolarizationCapability : this.impinjAntennaPolarizationCapabilityList) {
                element.addContent(impinjAntennaPolarizationCapability.encodeXML(impinjAntennaPolarizationCapability.getClass().getName().replaceAll(impinjAntennaPolarizationCapability.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.impinjAntennaPolarizationCapabilityList = new LinkedList<ImpinjAntennaPolarizationCapability>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (!_type.equals(ImpinjAntennaPolarizationCapability.TYPENUM)) break;
            this.impinjAntennaPolarizationCapabilityList.add(new ImpinjAntennaPolarizationCapability(binary.subList(position, tempLength)));
            position += tempLength;
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object llrpns;
        Object temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        this.impinjAntennaPolarizationCapabilityList = new LinkedList<ImpinjAntennaPolarizationCapability>();
        tempList = element.getChildren("ImpinjAntennaPolarizationCapability", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("ImpinjAntennaPolarizationCapability", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjAntennaCapabilities misses optional parameter of type impinjAntennaPolarizationCapabilityList");
        } else {
            for (Element e : tempList) {
                this.impinjAntennaPolarizationCapabilityList.add(new ImpinjAntennaPolarizationCapability(e));
                LOGGER.debug("adding ImpinjAntennaPolarizationCapability to impinjAntennaPolarizationCapabilityList ");
            }
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjAntennaCapabilities misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setImpinjAntennaPolarizationCapabilityList(List<ImpinjAntennaPolarizationCapability> impinjAntennaPolarizationCapabilityList) {
        this.impinjAntennaPolarizationCapabilityList = impinjAntennaPolarizationCapabilityList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public List<ImpinjAntennaPolarizationCapability> getImpinjAntennaPolarizationCapabilityList() {
        return this.impinjAntennaPolarizationCapabilityList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToImpinjAntennaPolarizationCapabilityList(ImpinjAntennaPolarizationCapability impinjAntennaPolarizationCapability) {
        if (this.impinjAntennaPolarizationCapabilityList == null) {
            this.impinjAntennaPolarizationCapabilityList = new LinkedList<ImpinjAntennaPolarizationCapability>();
        }
        this.impinjAntennaPolarizationCapabilityList.add(impinjAntennaPolarizationCapability);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

