/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitArray_HEX;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjAuthenticate
extends Custom
implements AccessCommandOpSpec {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1584);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjAuthenticate.class);
    protected UnsignedShort opSpecID;
    protected UnsignedInteger accessPassword;
    protected Bit sendRep;
    protected Bit incRepLen;
    private BitList reserved0 = new BitList(6);
    protected UnsignedByte cSI;
    protected BitArray_HEX message;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjAuthenticate() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjAuthenticate(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjAuthenticate(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1584);
        this.decodeXML(element);
    }

    public ImpinjAuthenticate(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
        }
        resultBits.append(this.opSpecID.encodeBinary());
        if (this.accessPassword == null) {
            LOGGER.warn(" accessPassword not set");
        }
        resultBits.append(this.accessPassword.encodeBinary());
        if (this.sendRep == null) {
            LOGGER.warn(" sendRep not set");
        }
        resultBits.append(this.sendRep.encodeBinary());
        if (this.incRepLen == null) {
            LOGGER.warn(" incRepLen not set");
        }
        resultBits.append(this.incRepLen.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.cSI == null) {
            LOGGER.warn(" cSI not set");
        }
        resultBits.append(this.cSI.encodeBinary());
        if (this.message == null) {
            LOGGER.warn(" message not set");
        }
        resultBits.append(this.message.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set");
        }
        element.addContent(this.opSpecID.encodeXML("OpSpecID", ns));
        if (this.accessPassword == null) {
            LOGGER.warn(" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set");
        }
        element.addContent(this.accessPassword.encodeXML("AccessPassword", ns));
        if (this.sendRep == null) {
            LOGGER.warn(" sendRep not set");
            throw new MissingParameterException(" sendRep not set");
        }
        element.addContent(this.sendRep.encodeXML("SendRep", ns));
        if (this.incRepLen == null) {
            LOGGER.warn(" incRepLen not set");
            throw new MissingParameterException(" incRepLen not set");
        }
        element.addContent(this.incRepLen.encodeXML("IncRepLen", ns));
        if (this.cSI == null) {
            LOGGER.warn(" cSI not set");
            throw new MissingParameterException(" cSI not set");
        }
        element.addContent(this.cSI.encodeXML("CSI", ns));
        if (this.message == null) {
            LOGGER.warn(" message not set");
            throw new MissingParameterException(" message not set");
        }
        element.addContent(this.message.encodeXML("Message", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.opSpecID = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        this.accessPassword = new UnsignedInteger(binary.subList(position += UnsignedShort.length(), UnsignedInteger.length()));
        this.sendRep = new Bit(binary.subList(position += UnsignedInteger.length(), Bit.length()));
        this.incRepLen = new Bit(binary.subList(position += Bit.length(), Bit.length()));
        position += Bit.length();
        this.cSI = new UnsignedByte(binary.subList(position += this.reserved0.length(), UnsignedByte.length()));
        short fieldCount = binary.subList(position += UnsignedByte.length(), UnsignedShort.length()).toShort();
        tempLength = BitArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.message = new BitArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("OpSpecID", element.getNamespace());
        if (temp != null) {
            this.opSpecID = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("AccessPassword", element.getNamespace())) != null) {
            this.accessPassword = new UnsignedInteger(temp);
        }
        if ((temp = element.getChild("SendRep", element.getNamespace())) != null) {
            this.sendRep = new Bit(temp);
        }
        if ((temp = element.getChild("IncRepLen", element.getNamespace())) != null) {
            this.incRepLen = new Bit(temp);
        }
        if ((temp = element.getChild("CSI", element.getNamespace())) != null) {
            this.cSI = new UnsignedByte(temp);
        }
        if ((temp = element.getChild("Message", element.getNamespace())) != null) {
            this.message = new BitArray_HEX(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjAuthenticate misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setOpSpecID(UnsignedShort opSpecID) {
        this.opSpecID = opSpecID;
    }

    public void setAccessPassword(UnsignedInteger accessPassword) {
        this.accessPassword = accessPassword;
    }

    public void setSendRep(Bit sendRep) {
        this.sendRep = sendRep;
    }

    public void setIncRepLen(Bit incRepLen) {
        this.incRepLen = incRepLen;
    }

    public void setCSI(UnsignedByte cSI) {
        this.cSI = cSI;
    }

    public void setMessage(BitArray_HEX message) {
        this.message = message;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getOpSpecID() {
        return this.opSpecID;
    }

    public UnsignedInteger getAccessPassword() {
        return this.accessPassword;
    }

    public Bit getSendRep() {
        return this.sendRep;
    }

    public Bit getIncRepLen() {
        return this.incRepLen;
    }

    public UnsignedByte getCSI() {
        return this.cSI;
    }

    public BitArray_HEX getMessage() {
        return this.message;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

