/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjOptimizedReadMode;
import org.llrp.ltk.generated.parameters.C1G2Read;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;

public class ImpinjEnableOptimizedRead
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(65);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjEnableOptimizedRead.class);
    protected ImpinjOptimizedReadMode optimizedReadMode;
    private List<C1G2Read> c1G2ReadList = new LinkedList<C1G2Read>();
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjEnableOptimizedRead() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjEnableOptimizedRead(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjEnableOptimizedRead(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(65);
        this.decodeXML(element);
    }

    public ImpinjEnableOptimizedRead(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.optimizedReadMode == null) {
            LOGGER.warn(" optimizedReadMode not set");
        }
        resultBits.append(this.optimizedReadMode.encodeBinary());
        if (this.c1G2ReadList == null) {
            LOGGER.info(" c1G2ReadList not set");
        } else {
            for (C1G2Read c1G2Read : this.c1G2ReadList) {
                resultBits.append(c1G2Read.encodeBinary());
            }
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.optimizedReadMode == null) {
            LOGGER.warn(" optimizedReadMode not set");
            throw new MissingParameterException(" optimizedReadMode not set");
        }
        element.addContent(this.optimizedReadMode.encodeXML("OptimizedReadMode", ns));
        if (this.c1G2ReadList == null) {
            LOGGER.info("c1G2ReadList not set");
        } else {
            for (C1G2Read c1G2Read : this.c1G2ReadList) {
                element.addContent(c1G2Read.encodeXML(c1G2Read.getClass().getName().replaceAll(c1G2Read.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        short tempByteLength;
        SignedShort _type;
        boolean atLeastOnce;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.optimizedReadMode = new ImpinjOptimizedReadMode(binary.subList(position, ImpinjOptimizedReadMode.length()));
        position += ImpinjOptimizedReadMode.length();
        this.c1G2ReadList = new LinkedList<C1G2Read>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (!_type.equals(C1G2Read.TYPENUM)) break;
            this.c1G2ReadList.add(new C1G2Read(binary.subList(position, tempLength)));
            position += tempLength;
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("OptimizedReadMode", element.getNamespace());
        if (temp != null) {
            this.optimizedReadMode = new ImpinjOptimizedReadMode(temp);
        }
        this.c1G2ReadList = new LinkedList<C1G2Read>();
        tempList = element.getChildren("C1G2Read", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("C1G2Read", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjEnableOptimizedRead misses optional parameter of type c1G2ReadList");
        } else {
            for (Element e : tempList) {
                this.c1G2ReadList.add(new C1G2Read(e));
                LOGGER.debug("adding C1G2Read to c1G2ReadList ");
            }
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", (Namespace)llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjEnableOptimizedRead misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setOptimizedReadMode(ImpinjOptimizedReadMode optimizedReadMode) {
        this.optimizedReadMode = optimizedReadMode;
    }

    public void setC1G2ReadList(List<C1G2Read> c1G2ReadList) {
        this.c1G2ReadList = c1G2ReadList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjOptimizedReadMode getOptimizedReadMode() {
        return this.optimizedReadMode;
    }

    public List<C1G2Read> getC1G2ReadList() {
        return this.c1G2ReadList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToC1G2ReadList(C1G2Read c1G2Read) {
        if (this.c1G2ReadList == null) {
            this.c1G2ReadList = new LinkedList<C1G2Read>();
        }
        this.c1G2ReadList.add(c1G2Read);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

