/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitArray_HEX;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjTruncatedReplyConfiguration
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1583);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjTruncatedReplyConfiguration.class);
    protected Bit gen2v2TagsOnly;
    private BitList reserved0 = new BitList(7);
    protected UnsignedByte ePCLength;
    protected UnsignedShort pointer;
    protected BitArray_HEX tagMask;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjTruncatedReplyConfiguration() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjTruncatedReplyConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjTruncatedReplyConfiguration(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1583);
        this.decodeXML(element);
    }

    public ImpinjTruncatedReplyConfiguration(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.gen2v2TagsOnly == null) {
            LOGGER.warn(" gen2v2TagsOnly not set");
        }
        resultBits.append(this.gen2v2TagsOnly.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.ePCLength == null) {
            LOGGER.warn(" ePCLength not set");
        }
        resultBits.append(this.ePCLength.encodeBinary());
        if (this.pointer == null) {
            LOGGER.warn(" pointer not set");
        }
        resultBits.append(this.pointer.encodeBinary());
        if (this.tagMask == null) {
            LOGGER.warn(" tagMask not set");
        }
        resultBits.append(this.tagMask.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
        Element element = new Element(name, ns);
        if (this.gen2v2TagsOnly == null) {
            LOGGER.warn(" gen2v2TagsOnly not set");
            throw new MissingParameterException(" gen2v2TagsOnly not set");
        }
        element.addContent(this.gen2v2TagsOnly.encodeXML("Gen2v2TagsOnly", ns));
        if (this.ePCLength == null) {
            LOGGER.warn(" ePCLength not set");
            throw new MissingParameterException(" ePCLength not set");
        }
        element.addContent(this.ePCLength.encodeXML("EPCLength", ns));
        if (this.pointer == null) {
            LOGGER.warn(" pointer not set");
            throw new MissingParameterException(" pointer not set");
        }
        element.addContent(this.pointer.encodeXML("Pointer", ns));
        if (this.tagMask == null) {
            LOGGER.warn(" tagMask not set");
            throw new MissingParameterException(" tagMask not set");
        }
        element.addContent(this.tagMask.encodeXML("TagMask", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.gen2v2TagsOnly = new Bit(binary.subList(position, Bit.length()));
        position += Bit.length();
        this.ePCLength = new UnsignedByte(binary.subList(position += this.reserved0.length(), UnsignedByte.length()));
        this.pointer = new UnsignedShort(binary.subList(position += UnsignedByte.length(), UnsignedShort.length()));
        short fieldCount = binary.subList(position += UnsignedShort.length(), UnsignedShort.length()).toShort();
        tempLength = BitArray_HEX.length() * fieldCount + UnsignedShort.length();
        this.tagMask = new BitArray_HEX(binary.subList(position, tempLength));
        position += tempLength;
        if (tempLength % 8 > 0) {
            position += 8 - tempLength % 8;
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("Gen2v2TagsOnly", element.getNamespace());
        if (temp != null) {
            this.gen2v2TagsOnly = new Bit(temp);
        }
        if ((temp = element.getChild("EPCLength", element.getNamespace())) != null) {
            this.ePCLength = new UnsignedByte(temp);
        }
        if ((temp = element.getChild("Pointer", element.getNamespace())) != null) {
            this.pointer = new UnsignedShort(temp);
        }
        if ((temp = element.getChild("TagMask", element.getNamespace())) != null) {
            this.tagMask = new BitArray_HEX(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjTruncatedReplyConfiguration misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setGen2v2TagsOnly(Bit gen2v2TagsOnly) {
        this.gen2v2TagsOnly = gen2v2TagsOnly;
    }

    public void setEPCLength(UnsignedByte ePCLength) {
        this.ePCLength = ePCLength;
    }

    public void setPointer(UnsignedShort pointer) {
        this.pointer = pointer;
    }

    public void setTagMask(BitArray_HEX tagMask) {
        this.tagMask = tagMask;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public Bit getGen2v2TagsOnly() {
        return this.gen2v2TagsOnly;
    }

    public UnsignedByte getEPCLength() {
        return this.ePCLength;
    }

    public UnsignedShort getPointer() {
        return this.pointer;
    }

    public BitArray_HEX getTagMask() {
        return this.tagMask;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

