/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.messages;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.parameters.ImpinjRequestedData;
import org.llrp.ltk.generated.enumerations.GetReaderConfigRequestedData;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class GET_READER_CONFIG
extends LLRPMessage {
    public static final SignedShort TYPENUM = new SignedShort(2);
    private static final Logger LOGGER = Logger.getLogger(GET_READER_CONFIG.class);
    public static final String RESPONSETYPE = "GET_READER_CONFIG_RESPONSE";
    protected UnsignedShort antennaID;
    protected GetReaderConfigRequestedData requestedData;
    protected UnsignedShort gPIPortNum;
    protected UnsignedShort gPOPortNum;
    protected List<Custom> customList = new LinkedList<Custom>();

    public GET_READER_CONFIG() {
        this.setVersion(new BitList(0, 0, 1));
    }

    public GET_READER_CONFIG(LLRPBitList list) throws InvalidLLRPMessageException {
        this.decodeBinary(list);
    }

    public GET_READER_CONFIG(byte[] byteArray) throws InvalidLLRPMessageException {
        this.decodeBinary(byteArray);
    }

    public GET_READER_CONFIG(Document document) throws InvalidLLRPMessageException {
        this.decodeXML(document);
    }

    @Override
    protected LLRPBitList encodeBinarySpecific() throws InvalidLLRPMessageException {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new InvalidLLRPMessageException(" antennaID not set  for Parameter of Type GET_READER_CONFIG");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.requestedData == null) {
            LOGGER.warn(" requestedData not set");
            throw new InvalidLLRPMessageException(" requestedData not set  for Parameter of Type GET_READER_CONFIG");
        }
        resultBits.append(this.requestedData.encodeBinary());
        if (this.gPIPortNum == null) {
            LOGGER.warn(" gPIPortNum not set");
            throw new InvalidLLRPMessageException(" gPIPortNum not set  for Parameter of Type GET_READER_CONFIG");
        }
        resultBits.append(this.gPIPortNum.encodeBinary());
        if (this.gPOPortNum == null) {
            LOGGER.warn(" gPOPortNum not set");
            throw new InvalidLLRPMessageException(" gPOPortNum not set  for Parameter of Type GET_READER_CONFIG");
        }
        resultBits.append(this.gPOPortNum.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Document encodeXML() throws InvalidLLRPMessageException {
        try {
            Namespace ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            Element root = new Element("GET_READER_CONFIG", ns);
            root.addNamespaceDeclaration(Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0"));
            root.addNamespaceDeclaration(Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44"));
            if (this.version == null) {
                throw new InvalidLLRPMessageException("Version not set");
            }
            root.setAttribute("Version", this.version.toInteger().toString());
            if (this.messageID == null) {
                throw new InvalidLLRPMessageException("MessageID not set");
            }
            root.setAttribute("MessageID", this.messageID.toString(10));
            if (this.antennaID == null) {
                LOGGER.warn(" antennaID not set");
                throw new MissingParameterException(" antennaID not set");
            }
            root.addContent(this.antennaID.encodeXML("AntennaID", ns));
            if (this.requestedData == null) {
                LOGGER.warn(" requestedData not set");
                throw new MissingParameterException(" requestedData not set");
            }
            root.addContent(this.requestedData.encodeXML("RequestedData", ns));
            if (this.gPIPortNum == null) {
                LOGGER.warn(" gPIPortNum not set");
                throw new MissingParameterException(" gPIPortNum not set");
            }
            root.addContent(this.gPIPortNum.encodeXML("GPIPortNum", ns));
            if (this.gPOPortNum == null) {
                LOGGER.warn(" gPOPortNum not set");
                throw new MissingParameterException(" gPOPortNum not set");
            }
            root.addContent(this.gPOPortNum.encodeXML("GPOPortNum", ns));
            if (this.customList == null) {
                LOGGER.info("customList not set");
            } else {
                for (Custom field : this.customList) {
                    root.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
                }
            }
            Document doc = new Document(root);
            if (this.isValidXMLMessage(doc, "org/llrp/ltk/llrp-1x0.xsd")) {
                return doc;
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) throws InvalidLLRPMessageException {
        int position = 0;
        int tempLength = 0;
        this.antennaID = new UnsignedShort(binary, position, UnsignedShort.length());
        this.requestedData = new GetReaderConfigRequestedData(binary, position += UnsignedShort.length(), GetReaderConfigRequestedData.length());
        this.gPIPortNum = new UnsignedShort(binary, position += GetReaderConfigRequestedData.length(), UnsignedShort.length());
        this.gPOPortNum = new UnsignedShort(binary, position += UnsignedShort.length(), UnsignedShort.length());
        position += UnsignedShort.length();
        this.customList = new LinkedList<Custom>();
        LOGGER.trace("decoding parameter customList ");
        while (position < binary.length()) {
            SignedShort type;
            boolean atLeastOnce = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                short tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(new ImpinjRequestedData().getParameterSubtype())) {
                    this.customList.add(new ImpinjRequestedData(cus));
                    atLeastOnce = true;
                    LOGGER.trace("adding ImpinjRequestedData to customList ");
                    position += tempLength;
                    atLeastOnce = true;
                    continue;
                }
                this.customList.add(cus);
                position += tempLength;
                atLeastOnce = true;
            }
            if (atLeastOnce) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace("GET_READER_CONFIG misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Document document) throws InvalidLLRPMessageException {
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        try {
            this.isValidXMLMessage(document, "org/llrp/ltk/llrp-1x0.xsd");
            Element root = (Element)document.getRootElement().clone();
            List tempList = null;
            String versionAttribute = root.getAttributeValue("Version");
            if (versionAttribute != null) {
                this.version = new BitList(3);
                this.version.setValue(new Integer(versionAttribute.trim()));
            } else {
                this.version = new BitList(0, 0, 1);
            }
            this.messageID = new UnsignedInteger(root.getAttributeValue("MessageID").trim());
            temp = root.getChild("AntennaID", root.getNamespace());
            if (temp == null) {
                LOGGER.warn("Element antennaID not provided in xml as child of " + root.getName());
                throw new MissingParameterException("Element antennaID not provided");
            }
            this.antennaID = new UnsignedShort(temp);
            root.removeChild("AntennaID", root.getNamespace());
            temp = root.getChild("RequestedData", root.getNamespace());
            if (temp == null) {
                LOGGER.warn("Element requestedData not provided in xml as child of " + root.getName());
                throw new MissingParameterException("Element requestedData not provided");
            }
            this.requestedData = new GetReaderConfigRequestedData(temp);
            root.removeChild("RequestedData", root.getNamespace());
            temp = root.getChild("GPIPortNum", root.getNamespace());
            if (temp == null) {
                LOGGER.warn("Element gPIPortNum not provided in xml as child of " + root.getName());
                throw new MissingParameterException("Element gPIPortNum not provided");
            }
            this.gPIPortNum = new UnsignedShort(temp);
            root.removeChild("GPIPortNum", root.getNamespace());
            temp = root.getChild("GPOPortNum", root.getNamespace());
            if (temp == null) {
                LOGGER.warn("Element gPOPortNum not provided in xml as child of " + root.getName());
                throw new MissingParameterException("Element gPOPortNum not provided");
            }
            this.gPOPortNum = new UnsignedShort(temp);
            root.removeChild("GPOPortNum", root.getNamespace());
            this.customList = new LinkedList<Custom>();
            tempList = root.getChildren("Custom", ns);
            if (tempList == null || tempList.isEmpty()) {
                LOGGER.trace("GET_READER_CONFIG misses optional parameter of type customList");
            } else {
                for (Object e : tempList) {
                    this.customList.add(new Custom((Element)e));
                    LOGGER.trace("adding Custom to customList ");
                }
            }
            root.removeChildren("Custom", ns);
            Namespace nsImpinjRequestedData = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.44");
            tempList = root.getChildren("ImpinjRequestedData", nsImpinjRequestedData);
            for (Element e : tempList) {
                this.customList.add(new ImpinjRequestedData(e));
                LOGGER.trace("adding ImpinjRequestedData to customList ");
            }
            root.removeChildren("ImpinjRequestedData", nsImpinjRequestedData);
            if (root.getChildren().size() > 0) {
                String message = "GET_READER_CONFIG has unknown element " + ((Element)root.getChildren().get(0)).getName();
                throw new InvalidLLRPMessageException(message);
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
        catch (MissingParameterException e) {
            throw new InvalidLLRPMessageException(e.getMessage());
        }
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setRequestedData(GetReaderConfigRequestedData requestedData) {
        this.requestedData = requestedData;
    }

    public void setGPIPortNum(UnsignedShort gPIPortNum) {
        this.gPIPortNum = gPIPortNum;
    }

    public void setGPOPortNum(UnsignedShort gPOPortNum) {
        this.gPOPortNum = gPOPortNum;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public GetReaderConfigRequestedData getRequestedData() {
        return this.requestedData;
    }

    public UnsignedShort getGPIPortNum() {
        return this.gPIPortNum;
    }

    public UnsignedShort getGPOPortNum() {
        return this.gPOPortNum;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    @Override
    public String getResponseType() {
        return RESPONSETYPE;
    }

    @Override
    public String getName() {
        return "GET_READER_CONFIG";
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }
}

