/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import java.util.HashMap;
import java.util.Map;

public enum TagModelName {
    Other(0),
    Monza4QT(4357),
    Monza4U(4356),
    Monza4E(4364),
    Monza4D(4352),
    Monza5(4400),
    Monza5U(4402),
    MonzaX_2K_Dura(4416),
    MonzaX_8K_Dura(4432),
    MonzaR6(4448),
    MonzaR6_P(4464),
    MonzaR6_A(4465),
    MonzaS6_C(4467);

    private static Map<Integer, TagModelName> map;
    private final int modelTidAsInteger;

    private TagModelName(int modelTidAsInt) {
        this.modelTidAsInteger = modelTidAsInt;
    }

    private TagModelName() {
        this.modelTidAsInteger = 0;
    }

    public static TagModelName valueOf(int modelTidAsInt) {
        TagModelName tagModelName = map.get(modelTidAsInt);
        if (tagModelName == null) {
            tagModelName = Other;
        }
        return tagModelName;
    }

    public static TagModelName fromTID(String tid) {
        String w2 = tid.substring(4, 8).toUpperCase();
        Integer w2Int = Integer.parseInt(w2, 16);
        return TagModelName.valueOf(w2Int);
    }

    static {
        map = new HashMap<Integer, TagModelName>();
        for (TagModelName tagModelName : TagModelName.values()) {
            map.put(tagModelName.modelTidAsInteger, tagModelName);
        }
    }
}

