/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableGPSCoordinates;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableOptimizedRead;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnablePeakRSSI;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableRFDopplerFrequency;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableRFPhaseAngle;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableSerializedTID;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableTxPower;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjTagReportContentSelector
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(50);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjTagReportContentSelector.class);
    private ImpinjEnableSerializedTID impinjEnableSerializedTID;
    private ImpinjEnableRFPhaseAngle impinjEnableRFPhaseAngle;
    private ImpinjEnablePeakRSSI impinjEnablePeakRSSI;
    private ImpinjEnableGPSCoordinates impinjEnableGPSCoordinates;
    private ImpinjEnableOptimizedRead impinjEnableOptimizedRead;
    private ImpinjEnableRFDopplerFrequency impinjEnableRFDopplerFrequency;
    private ImpinjEnableTxPower impinjEnableTxPower;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjTagReportContentSelector() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjTagReportContentSelector(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjTagReportContentSelector(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(50);
        this.decodeXML(element);
    }

    public ImpinjTagReportContentSelector(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.impinjEnableSerializedTID != null) {
            LOGGER.info(" impinjEnableSerializedTID not set");
            resultBits.append(this.impinjEnableSerializedTID.encodeBinary());
        }
        if (this.impinjEnableRFPhaseAngle != null) {
            LOGGER.info(" impinjEnableRFPhaseAngle not set");
            resultBits.append(this.impinjEnableRFPhaseAngle.encodeBinary());
        }
        if (this.impinjEnablePeakRSSI != null) {
            LOGGER.info(" impinjEnablePeakRSSI not set");
            resultBits.append(this.impinjEnablePeakRSSI.encodeBinary());
        }
        if (this.impinjEnableGPSCoordinates != null) {
            LOGGER.info(" impinjEnableGPSCoordinates not set");
            resultBits.append(this.impinjEnableGPSCoordinates.encodeBinary());
        }
        if (this.impinjEnableOptimizedRead != null) {
            LOGGER.info(" impinjEnableOptimizedRead not set");
            resultBits.append(this.impinjEnableOptimizedRead.encodeBinary());
        }
        if (this.impinjEnableRFDopplerFrequency != null) {
            LOGGER.info(" impinjEnableRFDopplerFrequency not set");
            resultBits.append(this.impinjEnableRFDopplerFrequency.encodeBinary());
        }
        if (this.impinjEnableTxPower != null) {
            LOGGER.info(" impinjEnableTxPower not set");
            resultBits.append(this.impinjEnableTxPower.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.46");
        Element element = new Element(name, ns);
        if (this.impinjEnableSerializedTID == null) {
            LOGGER.info("impinjEnableSerializedTID not set");
        } else {
            element.addContent(this.impinjEnableSerializedTID.encodeXML(this.impinjEnableSerializedTID.getClass().getSimpleName(), ns));
        }
        if (this.impinjEnableRFPhaseAngle == null) {
            LOGGER.info("impinjEnableRFPhaseAngle not set");
        } else {
            element.addContent(this.impinjEnableRFPhaseAngle.encodeXML(this.impinjEnableRFPhaseAngle.getClass().getSimpleName(), ns));
        }
        if (this.impinjEnablePeakRSSI == null) {
            LOGGER.info("impinjEnablePeakRSSI not set");
        } else {
            element.addContent(this.impinjEnablePeakRSSI.encodeXML(this.impinjEnablePeakRSSI.getClass().getSimpleName(), ns));
        }
        if (this.impinjEnableGPSCoordinates == null) {
            LOGGER.info("impinjEnableGPSCoordinates not set");
        } else {
            element.addContent(this.impinjEnableGPSCoordinates.encodeXML(this.impinjEnableGPSCoordinates.getClass().getSimpleName(), ns));
        }
        if (this.impinjEnableOptimizedRead == null) {
            LOGGER.info("impinjEnableOptimizedRead not set");
        } else {
            element.addContent(this.impinjEnableOptimizedRead.encodeXML(this.impinjEnableOptimizedRead.getClass().getSimpleName(), ns));
        }
        if (this.impinjEnableRFDopplerFrequency == null) {
            LOGGER.info("impinjEnableRFDopplerFrequency not set");
        } else {
            element.addContent(this.impinjEnableRFDopplerFrequency.encodeXML(this.impinjEnableRFDopplerFrequency.getClass().getSimpleName(), ns));
        }
        if (this.impinjEnableTxPower == null) {
            LOGGER.info("impinjEnableTxPower not set");
        } else {
            element.addContent(this.impinjEnableTxPower.encodeXML(this.impinjEnableTxPower.getClass().getSimpleName(), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        UnsignedInteger subType;
        UnsignedInteger vendor;
        short tempByteLength;
        SignedShort _type;
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjEnableSerializedTID.VENDOR_ID) && subType.equals(ImpinjEnableSerializedTID.PARAMETER_SUBTYPE)) {
                    this.impinjEnableSerializedTID = new ImpinjEnableSerializedTID(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjEnableRFPhaseAngle.VENDOR_ID) && subType.equals(ImpinjEnableRFPhaseAngle.PARAMETER_SUBTYPE)) {
                    this.impinjEnableRFPhaseAngle = new ImpinjEnableRFPhaseAngle(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjEnablePeakRSSI.VENDOR_ID) && subType.equals(ImpinjEnablePeakRSSI.PARAMETER_SUBTYPE)) {
                    this.impinjEnablePeakRSSI = new ImpinjEnablePeakRSSI(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjEnableGPSCoordinates.VENDOR_ID) && subType.equals(ImpinjEnableGPSCoordinates.PARAMETER_SUBTYPE)) {
                    this.impinjEnableGPSCoordinates = new ImpinjEnableGPSCoordinates(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjEnableOptimizedRead.VENDOR_ID) && subType.equals(ImpinjEnableOptimizedRead.PARAMETER_SUBTYPE)) {
                    this.impinjEnableOptimizedRead = new ImpinjEnableOptimizedRead(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjEnableRFDopplerFrequency.VENDOR_ID) && subType.equals(ImpinjEnableRFDopplerFrequency.PARAMETER_SUBTYPE)) {
                    this.impinjEnableRFDopplerFrequency = new ImpinjEnableRFDopplerFrequency(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        if (position < binary.length()) {
            if (binary.get(position)) {
                _type = new SignedShort(binary.subList(position + 1, 7));
            } else {
                _type = new SignedShort(binary.subList(position + 6, 10));
                tempByteLength = binary.subList(position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (Custom.TYPENUM.equals(_type)) {
                vendor = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length(), UnsignedInteger.length()));
                subType = new UnsignedInteger(binary.subList(position + 6 + 10 + UnsignedShort.length() + UnsignedInteger.length(), UnsignedInteger.length()));
                if (vendor.equals(ImpinjEnableTxPower.VENDOR_ID) && subType.equals(ImpinjEnableTxPower.PARAMETER_SUBTYPE)) {
                    this.impinjEnableTxPower = new ImpinjEnableTxPower(binary.subList(position, tempLength));
                    position += tempLength;
                }
            }
        }
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            _type = new SignedShort(binary.subList(position + 6, 10));
            tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Namespace llrpns;
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("ImpinjEnableSerializedTID", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjEnableSerializedTID", llrpns);
        }
        if (temp != null) {
            this.impinjEnableSerializedTID = new ImpinjEnableSerializedTID(temp);
            LOGGER.info("setting parameter impinjEnableSerializedTID for parameter ImpinjTagReportContentSelector");
        } else {
            LOGGER.info("ImpinjTagReportContentSelector misses non optional parameter of type impinjEnableSerializedTID");
        }
        temp = element.getChild("ImpinjEnableRFPhaseAngle", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjEnableRFPhaseAngle", llrpns);
        }
        if (temp != null) {
            this.impinjEnableRFPhaseAngle = new ImpinjEnableRFPhaseAngle(temp);
            LOGGER.info("setting parameter impinjEnableRFPhaseAngle for parameter ImpinjTagReportContentSelector");
        } else {
            LOGGER.info("ImpinjTagReportContentSelector misses non optional parameter of type impinjEnableRFPhaseAngle");
        }
        temp = element.getChild("ImpinjEnablePeakRSSI", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjEnablePeakRSSI", llrpns);
        }
        if (temp != null) {
            this.impinjEnablePeakRSSI = new ImpinjEnablePeakRSSI(temp);
            LOGGER.info("setting parameter impinjEnablePeakRSSI for parameter ImpinjTagReportContentSelector");
        } else {
            LOGGER.info("ImpinjTagReportContentSelector misses non optional parameter of type impinjEnablePeakRSSI");
        }
        temp = element.getChild("ImpinjEnableGPSCoordinates", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjEnableGPSCoordinates", llrpns);
        }
        if (temp != null) {
            this.impinjEnableGPSCoordinates = new ImpinjEnableGPSCoordinates(temp);
            LOGGER.info("setting parameter impinjEnableGPSCoordinates for parameter ImpinjTagReportContentSelector");
        } else {
            LOGGER.info("ImpinjTagReportContentSelector misses non optional parameter of type impinjEnableGPSCoordinates");
        }
        temp = element.getChild("ImpinjEnableOptimizedRead", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjEnableOptimizedRead", llrpns);
        }
        if (temp != null) {
            this.impinjEnableOptimizedRead = new ImpinjEnableOptimizedRead(temp);
            LOGGER.info("setting parameter impinjEnableOptimizedRead for parameter ImpinjTagReportContentSelector");
        } else {
            LOGGER.info("ImpinjTagReportContentSelector misses non optional parameter of type impinjEnableOptimizedRead");
        }
        temp = element.getChild("ImpinjEnableRFDopplerFrequency", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjEnableRFDopplerFrequency", llrpns);
        }
        if (temp != null) {
            this.impinjEnableRFDopplerFrequency = new ImpinjEnableRFDopplerFrequency(temp);
            LOGGER.info("setting parameter impinjEnableRFDopplerFrequency for parameter ImpinjTagReportContentSelector");
        } else {
            LOGGER.info("ImpinjTagReportContentSelector misses non optional parameter of type impinjEnableRFDopplerFrequency");
        }
        temp = element.getChild("ImpinjEnableTxPower", element.getNamespace());
        if (temp == null) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            temp = element.getChild("ImpinjEnableTxPower", llrpns);
        }
        if (temp != null) {
            this.impinjEnableTxPower = new ImpinjEnableTxPower(temp);
            LOGGER.info("setting parameter impinjEnableTxPower for parameter ImpinjTagReportContentSelector");
        } else {
            LOGGER.info("ImpinjTagReportContentSelector misses non optional parameter of type impinjEnableTxPower");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjTagReportContentSelector misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setImpinjEnableSerializedTID(ImpinjEnableSerializedTID impinjEnableSerializedTID) {
        this.impinjEnableSerializedTID = impinjEnableSerializedTID;
    }

    public void setImpinjEnableRFPhaseAngle(ImpinjEnableRFPhaseAngle impinjEnableRFPhaseAngle) {
        this.impinjEnableRFPhaseAngle = impinjEnableRFPhaseAngle;
    }

    public void setImpinjEnablePeakRSSI(ImpinjEnablePeakRSSI impinjEnablePeakRSSI) {
        this.impinjEnablePeakRSSI = impinjEnablePeakRSSI;
    }

    public void setImpinjEnableGPSCoordinates(ImpinjEnableGPSCoordinates impinjEnableGPSCoordinates) {
        this.impinjEnableGPSCoordinates = impinjEnableGPSCoordinates;
    }

    public void setImpinjEnableOptimizedRead(ImpinjEnableOptimizedRead impinjEnableOptimizedRead) {
        this.impinjEnableOptimizedRead = impinjEnableOptimizedRead;
    }

    public void setImpinjEnableRFDopplerFrequency(ImpinjEnableRFDopplerFrequency impinjEnableRFDopplerFrequency) {
        this.impinjEnableRFDopplerFrequency = impinjEnableRFDopplerFrequency;
    }

    public void setImpinjEnableTxPower(ImpinjEnableTxPower impinjEnableTxPower) {
        this.impinjEnableTxPower = impinjEnableTxPower;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public ImpinjEnableSerializedTID getImpinjEnableSerializedTID() {
        return this.impinjEnableSerializedTID;
    }

    public ImpinjEnableRFPhaseAngle getImpinjEnableRFPhaseAngle() {
        return this.impinjEnableRFPhaseAngle;
    }

    public ImpinjEnablePeakRSSI getImpinjEnablePeakRSSI() {
        return this.impinjEnablePeakRSSI;
    }

    public ImpinjEnableGPSCoordinates getImpinjEnableGPSCoordinates() {
        return this.impinjEnableGPSCoordinates;
    }

    public ImpinjEnableOptimizedRead getImpinjEnableOptimizedRead() {
        return this.impinjEnableOptimizedRead;
    }

    public ImpinjEnableRFDopplerFrequency getImpinjEnableRFDopplerFrequency() {
        return this.impinjEnableRFDopplerFrequency;
    }

    public ImpinjEnableTxPower getImpinjEnableTxPower() {
        return this.impinjEnableTxPower;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

