/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedInteger;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedInteger;

public class ImpinjTiltConfiguration
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1522);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjTiltConfiguration.class);
    protected SignedInteger xAxis;
    protected SignedInteger yAxis;
    protected SignedInteger zAxis;
    private List<Custom> customList = new LinkedList<Custom>();

    public ImpinjTiltConfiguration() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjTiltConfiguration(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjTiltConfiguration(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1522);
        this.decodeXML(element);
    }

    public ImpinjTiltConfiguration(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.xAxis == null) {
            LOGGER.warn(" xAxis not set");
        }
        resultBits.append(this.xAxis.encodeBinary());
        if (this.yAxis == null) {
            LOGGER.warn(" yAxis not set");
        }
        resultBits.append(this.yAxis.encodeBinary());
        if (this.zAxis == null) {
            LOGGER.warn(" zAxis not set");
        }
        resultBits.append(this.zAxis.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.46");
        Element element = new Element(name, ns);
        if (this.xAxis == null) {
            LOGGER.warn(" xAxis not set");
            throw new MissingParameterException(" xAxis not set");
        }
        element.addContent(this.xAxis.encodeXML("XAxis", ns));
        if (this.yAxis == null) {
            LOGGER.warn(" yAxis not set");
            throw new MissingParameterException(" yAxis not set");
        }
        element.addContent(this.yAxis.encodeXML("YAxis", ns));
        if (this.zAxis == null) {
            LOGGER.warn(" zAxis not set");
            throw new MissingParameterException(" zAxis not set");
        }
        element.addContent(this.zAxis.encodeXML("ZAxis", ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.xAxis = new SignedInteger(binary.subList(position, SignedInteger.length()));
        this.yAxis = new SignedInteger(binary.subList(position += SignedInteger.length(), SignedInteger.length()));
        this.zAxis = new SignedInteger(binary.subList(position += SignedInteger.length(), SignedInteger.length()));
        position += SignedInteger.length();
        this.customList = new LinkedList<Custom>();
        while (position < binary.length()) {
            boolean atLeastOnce = false;
            SignedShort _type = new SignedShort(binary.subList(position + 6, 10));
            short tempByteLength = binary.subList(position + 16, 16).toShort();
            tempLength = 8 * tempByteLength;
            if (_type == null || !_type.equals(Custom.TYPENUM)) continue;
            Custom cus = new Custom(binary.subList(position, tempLength));
            this.customList.add(cus);
            position += tempLength;
            atLeastOnce = true;
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        List tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("XAxis", element.getNamespace());
        if (temp != null) {
            this.xAxis = new SignedInteger(temp);
        }
        if ((temp = element.getChild("YAxis", element.getNamespace())) != null) {
            this.yAxis = new SignedInteger(temp);
        }
        if ((temp = element.getChild("ZAxis", element.getNamespace())) != null) {
            this.zAxis = new SignedInteger(temp);
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", element.getNamespace());
        if (tempList == null || tempList.isEmpty()) {
            Namespace llrpns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
            tempList = element.getChildren("Custom", llrpns);
        }
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.debug("ImpinjTiltConfiguration misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.debug("adding Custom to customList ");
            }
        }
    }

    public void setXAxis(SignedInteger xAxis) {
        this.xAxis = xAxis;
    }

    public void setYAxis(SignedInteger yAxis) {
        this.yAxis = yAxis;
    }

    public void setZAxis(SignedInteger zAxis) {
        this.zAxis = zAxis;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public SignedInteger getXAxis() {
        return this.xAxis;
    }

    public SignedInteger getYAxis() {
        return this.yAxis;
    }

    public SignedInteger getZAxis() {
        return this.zAxis;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

