/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.generated.interfaces.AirProtocolOpSpec;
import org.llrp.ltk.generated.interfaces.C1G2OpSpec;
import org.llrp.ltk.generated.parameters.C1G2LockPayload;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class C1G2Lock
extends TLVParameter
implements AccessCommandOpSpec,
C1G2OpSpec,
AirProtocolOpSpec {
    public static final SignedShort TYPENUM = new SignedShort(344);
    private static final Logger LOGGER = Logger.getLogger(C1G2Lock.class);
    protected UnsignedShort opSpecID;
    protected UnsignedInteger accessPassword;
    protected List<C1G2LockPayload> c1G2LockPayloadList = new LinkedList<C1G2LockPayload>();

    public C1G2Lock() {
    }

    public C1G2Lock(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public C1G2Lock(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public C1G2Lock(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set  for Parameter of Type C1G2Lock");
        }
        resultBits.append(this.opSpecID.encodeBinary());
        if (this.accessPassword == null) {
            LOGGER.warn(" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set  for Parameter of Type C1G2Lock");
        }
        resultBits.append(this.accessPassword.encodeBinary());
        if (this.c1G2LockPayloadList == null) {
            LOGGER.warn(" c1G2LockPayloadList not set");
            throw new MissingParameterException(" c1G2LockPayloadList not set");
        }
        for (C1G2LockPayload field : this.c1G2LockPayloadList) {
            resultBits.append(field.encodeBinary());
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.opSpecID == null) {
            LOGGER.warn(" opSpecID not set");
            throw new MissingParameterException(" opSpecID not set");
        }
        element.addContent(this.opSpecID.encodeXML("OpSpecID", ns));
        if (this.accessPassword == null) {
            LOGGER.warn(" accessPassword not set");
            throw new MissingParameterException(" accessPassword not set");
        }
        element.addContent(this.accessPassword.encodeXML("AccessPassword", ns));
        if (this.c1G2LockPayloadList == null) {
            LOGGER.warn(" c1G2LockPayloadList not set");
            throw new MissingParameterException("  c1G2LockPayloadList not set");
        }
        for (C1G2LockPayload field : this.c1G2LockPayloadList) {
            element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.opSpecID = new UnsignedShort(binary, position, UnsignedShort.length());
        this.accessPassword = new UnsignedInteger(binary, position += UnsignedShort.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
        this.c1G2LockPayloadList = new LinkedList<C1G2LockPayload>();
        LOGGER.trace("decoding parameter c1G2LockPayloadList ");
        while (position < binary.length()) {
            SignedShort type;
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                short tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2LockPayload.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2LockPayload.length();
                }
                this.c1G2LockPayloadList.add(new C1G2LockPayload(binary, position, tempLength));
                LOGGER.trace("adding C1G2LockPayload to c1G2LockPayloadList ");
                foundOne = true;
                position += tempLength;
            }
            if (foundOne) continue;
            break;
        }
        if (this.c1G2LockPayloadList.isEmpty()) {
            LOGGER.warn("encoded message does not contain parameter for non optional c1G2LockPayloadList");
            throw new MissingParameterException("C1G2Lock misses non optional parameter of type C1G2LockPayload");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("OpSpecID", ns);
        if (temp != null) {
            this.opSpecID = new UnsignedShort(temp);
        }
        element.removeChild("OpSpecID", ns);
        temp = element.getChild("AccessPassword", ns);
        if (temp != null) {
            this.accessPassword = new UnsignedInteger(temp);
        }
        element.removeChild("AccessPassword", ns);
        this.c1G2LockPayloadList = new LinkedList<C1G2LockPayload>();
        tempList = element.getChildren("C1G2LockPayload", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.warn("C1G2Lock misses non optional parameter of type c1G2LockPayloadList");
            throw new MissingParameterException("C1G2Lock misses non optional parameter of type c1G2LockPayloadList");
        }
        for (Element e : tempList) {
            this.c1G2LockPayloadList.add(new C1G2LockPayload(e));
            LOGGER.trace("adding C1G2LockPayload to c1G2LockPayloadList ");
        }
        element.removeChildren("C1G2LockPayload", ns);
        if (element.getChildren().size() > 0) {
            String message = "C1G2Lock has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setOpSpecID(UnsignedShort opSpecID) {
        this.opSpecID = opSpecID;
    }

    public void setAccessPassword(UnsignedInteger accessPassword) {
        this.accessPassword = accessPassword;
    }

    public void setC1G2LockPayloadList(List<C1G2LockPayload> c1G2LockPayloadList) {
        this.c1G2LockPayloadList = c1G2LockPayloadList;
    }

    public UnsignedShort getOpSpecID() {
        return this.opSpecID;
    }

    public UnsignedInteger getAccessPassword() {
        return this.accessPassword;
    }

    public List<C1G2LockPayload> getC1G2LockPayloadList() {
        return this.c1G2LockPayloadList;
    }

    public void addToC1G2LockPayloadList(C1G2LockPayload c1G2LockPayload) {
        if (this.c1G2LockPayloadList == null) {
            this.c1G2LockPayloadList = new LinkedList<C1G2LockPayload>();
        }
        this.c1G2LockPayloadList.add(c1G2LockPayload);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "C1G2Lock";
    }

    public String toString() {
        String result = "C1G2Lock: ";
        result = result + ", opSpecID: ";
        result = result + this.opSpecID;
        result = result + ", accessPassword: ";
        result = result + this.accessPassword;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

