/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.BitSet;

public class LLRPBitList {
    BitSet bits;
    Integer length;

    public LLRPBitList() {
        this.bits = new BitSet(0);
        this.bits.clear(0);
        this.length = 0;
    }

    public LLRPBitList(byte[] bytes, int maxlength) {
        if (maxlength > bytes.length) {
            maxlength = bytes.length;
        }
        this.length = maxlength * 8;
        this.bits = BitSet.valueOf(bytes);
    }

    public LLRPBitList(byte[] bytes) {
        this(bytes, bytes.length);
    }

    public LLRPBitList(String bitString) {
        this.length = bitString.length();
        this.bits = new BitSet(bitString.length());
        for (int i = 0; i < bitString.length(); ++i) {
            if (bitString.charAt(i) != '1') continue;
            this.bits.set(LLRPBitList.flipBitOrder(i));
        }
    }

    public LLRPBitList(int n) {
        this.bits = new BitSet(n);
        this.length = n;
    }

    public void add(boolean bit) {
        if (bit) {
            this.bits.set(LLRPBitList.flipBitOrder(this.length));
        }
        Integer n = this.length;
        Integer n2 = this.length = Integer.valueOf(this.length + 1);
    }

    public void append(LLRPBitList other) {
        int oldLength = this.length;
        int otherLength = other.length;
        this.length = this.length + otherLength;
        for (int i = 0; i < otherLength; ++i) {
            if (!other.get(i)) continue;
            this.bits.set(LLRPBitList.flipBitOrder(oldLength + i));
        }
    }

    public void clear(int position) {
        this.bits.clear(LLRPBitList.flipBitOrder(position));
    }

    public void clear(Integer i) {
        this.clear((int)i);
    }

    public Object clone() {
        try {
            super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        LLRPBitList n = new LLRPBitList();
        n.bits = (BitSet)this.bits.clone();
        n.length = this.length;
        return n;
    }

    public boolean equals(LLRPBitList other) {
        if (other.length.compareTo(this.length) != 0) {
            return false;
        }
        return this.bits.equals(other.bits);
    }

    public boolean get(int position) {
        return this.bits.get(LLRPBitList.flipBitOrder(position));
    }

    public boolean get(Integer i) {
        return this.get((int)i);
    }

    public int length() {
        return this.length;
    }

    public void pad(int number) {
        LLRPBitList pad = new LLRPBitList(number);
        pad.append(this);
        this.length = this.length + number;
        this.bits = pad.bits;
    }

    public void pad(Integer i) {
        this.pad((int)i);
    }

    public void set(int position) {
        if (position > this.length) {
            this.length = position + 1;
        }
        this.bits.set(LLRPBitList.flipBitOrder(position));
    }

    public void set(Integer i) {
        this.set((int)i);
    }

    public LLRPBitList subList(Integer from, Integer subLength) {
        if (from < 0 || from + subLength > this.length) {
            return new LLRPBitList();
        }
        LLRPBitList subList = new LLRPBitList(subLength);
        if (from % 8 != 0 || subLength % 8 != 0) {
            for (int i = 0; i < subLength; ++i) {
                if (!this.bits.get(LLRPBitList.flipBitOrder(from + i))) continue;
                subList.bits.set(LLRPBitList.flipBitOrder(i));
            }
        } else {
            subList.bits = this.bits.get(from, from + subLength);
        }
        return subList;
    }

    public byte[] toByteArray() {
        byte[] unpaddedByteArray = this.bits.toByteArray();
        byte[] bufferOut = new byte[this.length / 8];
        int minimumBufferSize = Math.min(bufferOut.length, unpaddedByteArray.length);
        System.arraycopy(unpaddedByteArray, 0, bufferOut, 0, minimumBufferSize);
        return bufferOut;
    }

    private ByteBuffer toByteBuffer(int minimumSizeBytes) {
        byte[] currentBytes = this.bits.toByteArray();
        int paddedArraySizeBytes = this.length / 8 + (this.length % 8 == 0 ? 0 : 1);
        int bufferSizeBytes = Math.max(paddedArraySizeBytes, minimumSizeBytes);
        ByteBuffer byteBufferOut = ByteBuffer.allocate(bufferSizeBytes);
        byteBufferOut.position(bufferSizeBytes - paddedArraySizeBytes);
        byteBufferOut.put(currentBytes, 0, currentBytes.length);
        return byteBufferOut;
    }

    public BigInteger toBigInteger() {
        ByteBuffer byteBuffer = this.toByteBuffer(8);
        BigInteger bigInteger = new BigInteger(byteBuffer.array());
        return bigInteger;
    }

    public long toLong() {
        ByteBuffer byteBuffer = this.toByteBuffer(8);
        return byteBuffer.getLong(byteBuffer.array().length - 8) >>> LLRPBitList.numberOfMisalignedBits(this.length);
    }

    public int toInt() {
        ByteBuffer byteBuffer = this.toByteBuffer(4);
        return byteBuffer.getInt(byteBuffer.array().length - 4) >>> LLRPBitList.numberOfMisalignedBits(this.length);
    }

    public short toShort() {
        ByteBuffer byteBuffer = this.toByteBuffer(2);
        int unshiftedValueOut = 0xFFFF & byteBuffer.getShort(byteBuffer.array().length - 2);
        return (short)(unshiftedValueOut >>> LLRPBitList.numberOfMisalignedBits(this.length));
    }

    public short toShort(int bitIndex, int numberOfBits) {
        ByteBuffer byteBuffer = this.toByteBuffer(4);
        int mask = -1 >>> bitIndex % 8;
        int out = mask & byteBuffer.getInt(bitIndex / 8);
        return (short)(out >>> 32 - numberOfBits - bitIndex % 8);
    }

    private static int flipBitOrder(int index) {
        return index - 2 * (index % 8) + 8 - 1;
    }

    private static int numberOfMisalignedBits(int length) {
        return (8 - length % 8) % 8;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.length; ++i) {
            s = this.bits.get(LLRPBitList.flipBitOrder(i)) ? s + "1" : s + "0";
        }
        return s;
    }

    public int hashCode() {
        return this.bits.hashCode();
    }
}

