/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.types;

import org.apache.log4j.Logger;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.LLRPParameter;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.UnsignedShort;

public abstract class TLVParameter
extends LLRPParameter {
    private static Logger logging = Logger.getLogger(TLVParameter.class);
    protected final int RESERVEDLENGTH = 6;
    protected final int TYPENUMBERLENGTH = 10;
    private BitList reserved = new BitList(6);

    @Override
    public final void decodeBinary(LLRPBitList binary) {
        SignedShort tN = new SignedShort(binary, 6, 10);
        if (!tN.equals(this.getTypeNum())) {
            logging.error("incorrect type. Expected " + this.getTypeNum().toShort() + " message indicates " + tN.toShort());
            throw new IllegalArgumentException("incorrect type. Expected " + this.getTypeNum().toShort() + " message indicates " + tN.toShort());
        }
        int byteLength = new SignedShort(binary, 16, UnsignedShort.length()).toInteger();
        this.bitLength = new UnsignedShort(8 * byteLength);
        if (this.bitLength.toInteger().intValue() != binary.length()) {
            logging.error("incorrect length. Expected " + binary.length() + " message indicates " + this.bitLength.toInteger());
            throw new IllegalArgumentException("incorrect length");
        }
        int headLength = 16 + UnsignedShort.length();
        this.decodeBinarySpecific(binary.subList(headLength, binary.length() - headLength));
    }

    @Override
    public final LLRPBitList encodeBinary() {
        LLRPBitList result = new LLRPBitList();
        result.append(this.reserved.encodeBinary());
        LLRPBitList le = this.getTypeNum().encodeBinary();
        result.append(le.subList(6, 10));
        result.append(this.bitLength.encodeBinary());
        result.append(this.encodeBinarySpecific());
        this.finalizeEncode(result);
        return result;
    }

    protected abstract void decodeBinarySpecific(LLRPBitList var1);

    protected abstract LLRPBitList encodeBinarySpecific();

    private void finalizeEncode(LLRPBitList result) {
        int lengthBits = result.length();
        int lengthBytes = lengthBits / 8;
        if (lengthBits % 8 > 0) {
            ++lengthBytes;
        }
        LLRPBitList binLength = new UnsignedShort(lengthBytes).encodeBinary();
        for (int i = 0; i < UnsignedShort.length(); ++i) {
            if (binLength.get(i)) {
                result.set(16 + i);
                continue;
            }
            result.clear(16 + i);
        }
    }
}

