/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.AntennaChangeListener;
import com.impinj.octane.AntennaConfig;
import com.impinj.octane.AntennaConfigGroup;
import com.impinj.octane.AntennaEvent;
import com.impinj.octane.AntennaEventType;
import com.impinj.octane.AntennaHubStatus;
import com.impinj.octane.AntennaHubStatusGroup;
import com.impinj.octane.AntennaStatus;
import com.impinj.octane.AntennaStatusGroup;
import com.impinj.octane.AutoStartMode;
import com.impinj.octane.AutoStopMode;
import com.impinj.octane.BlockPermalockResult;
import com.impinj.octane.BufferOverflowEvent;
import com.impinj.octane.BufferOverflowListener;
import com.impinj.octane.BufferWarningEvent;
import com.impinj.octane.BufferWarningListener;
import com.impinj.octane.ConnectionAttemptEvent;
import com.impinj.octane.ConnectionAttemptListener;
import com.impinj.octane.ConnectionCloseEvent;
import com.impinj.octane.ConnectionCloseListener;
import com.impinj.octane.ConnectionLostListener;
import com.impinj.octane.DiagnosticReport;
import com.impinj.octane.DiagnosticsReportListener;
import com.impinj.octane.DirectionConfig;
import com.impinj.octane.DirectionFieldOfView;
import com.impinj.octane.DirectionMode;
import com.impinj.octane.DirectionReport;
import com.impinj.octane.DirectionReportListener;
import com.impinj.octane.DirectionReportType;
import com.impinj.octane.DirectionTagPopulationStatus;
import com.impinj.octane.FeatureSet;
import com.impinj.octane.FilterSettings;
import com.impinj.octane.GpiChangeListener;
import com.impinj.octane.GpiConfig;
import com.impinj.octane.GpiConfigGroup;
import com.impinj.octane.GpiEvent;
import com.impinj.octane.GpiStatus;
import com.impinj.octane.GpiStatusGroup;
import com.impinj.octane.GpoConfig;
import com.impinj.octane.GpoConfigGroup;
import com.impinj.octane.GpoMode;
import com.impinj.octane.GpsCoordinates;
import com.impinj.octane.HubFaultStatus;
import com.impinj.octane.ImpinjAuthenticateResult;
import com.impinj.octane.ImpinjTimestamp;
import com.impinj.octane.KeepaliveConfig;
import com.impinj.octane.KeepaliveEvent;
import com.impinj.octane.KeepaliveListener;
import com.impinj.octane.KeepaliveTimeoutListener;
import com.impinj.octane.KeepaliveTimer;
import com.impinj.octane.KillResultStatus;
import com.impinj.octane.LocationConfig;
import com.impinj.octane.LocationReport;
import com.impinj.octane.LocationReportListener;
import com.impinj.octane.LocationReportType;
import com.impinj.octane.LockMemoryBank;
import com.impinj.octane.LockResultStatus;
import com.impinj.octane.MarginReadResult;
import com.impinj.octane.MemoryBank;
import com.impinj.octane.OctaneSdkException;
import com.impinj.octane.PlacementConfig;
import com.impinj.octane.QtAccessRange;
import com.impinj.octane.QtDataProfile;
import com.impinj.octane.QtGetConfigResultStatus;
import com.impinj.octane.QtSetConfigResultStatus;
import com.impinj.octane.ReadResultStatus;
import com.impinj.octane.ReaderMode;
import com.impinj.octane.ReaderModel;
import com.impinj.octane.ReaderStartEvent;
import com.impinj.octane.ReaderStartListener;
import com.impinj.octane.ReaderStopEvent;
import com.impinj.octane.ReaderStopListener;
import com.impinj.octane.ReportMode;
import com.impinj.octane.RxSensitivityTableEntry;
import com.impinj.octane.SearchMode;
import com.impinj.octane.SequenceState;
import com.impinj.octane.SequenceTriggerType;
import com.impinj.octane.Settings;
import com.impinj.octane.SpatialMode;
import com.impinj.octane.Status;
import com.impinj.octane.Tag;
import com.impinj.octane.TagBlockPermalockOp;
import com.impinj.octane.TagBlockPermalockOpResult;
import com.impinj.octane.TagData;
import com.impinj.octane.TagFilter;
import com.impinj.octane.TagFilterMode;
import com.impinj.octane.TagFilterOp;
import com.impinj.octane.TagFilterStateUnawareAction;
import com.impinj.octane.TagImpinjAuthenticateOp;
import com.impinj.octane.TagImpinjAuthenticateOpResult;
import com.impinj.octane.TagKillOp;
import com.impinj.octane.TagKillOpResult;
import com.impinj.octane.TagLockOp;
import com.impinj.octane.TagLockOpResult;
import com.impinj.octane.TagLockState;
import com.impinj.octane.TagMarginReadOp;
import com.impinj.octane.TagMarginReadOpResult;
import com.impinj.octane.TagModelDetails;
import com.impinj.octane.TagOp;
import com.impinj.octane.TagOpCompleteListener;
import com.impinj.octane.TagOpReport;
import com.impinj.octane.TagOpSequence;
import com.impinj.octane.TagQtGetOp;
import com.impinj.octane.TagQtGetOpResult;
import com.impinj.octane.TagQtSetOp;
import com.impinj.octane.TagQtSetOpResult;
import com.impinj.octane.TagReadOp;
import com.impinj.octane.TagReadOpResult;
import com.impinj.octane.TagReport;
import com.impinj.octane.TagReportListener;
import com.impinj.octane.TagSelectFilter;
import com.impinj.octane.TagWriteOp;
import com.impinj.octane.TagWriteOpResult;
import com.impinj.octane.TargetTag;
import com.impinj.octane.TiltSensorValue;
import com.impinj.octane.TxPowerTableEntry;
import com.impinj.octane.WriteResultStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeoutException;
import org.apache.mina.core.RuntimeIoException;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.generated.custom.enumerations.ImpinjAdvancedGPOMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionDiagnosticReportLevel;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionFieldOfView;
import org.llrp.ltk.generated.custom.enumerations.ImpinjDirectionRFMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjFixedFrequencyMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjGPSCoordinatesMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjInventorySearchType;
import org.llrp.ltk.generated.custom.enumerations.ImpinjLinkMonitorMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjLowDutyCycleMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjOptimizedReadMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjPeakRSSIMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjQTAccessRange;
import org.llrp.ltk.generated.custom.enumerations.ImpinjQTDataProfile;
import org.llrp.ltk.generated.custom.enumerations.ImpinjQTPersistence;
import org.llrp.ltk.generated.custom.enumerations.ImpinjRFDopplerFrequencyMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjRFPhaseAngleMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjReducedPowerMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjRequestedDataType;
import org.llrp.ltk.generated.custom.enumerations.ImpinjSerializedTIDMode;
import org.llrp.ltk.generated.custom.enumerations.ImpinjTagFilterVerificationMode;
import org.llrp.ltk.generated.custom.messages.IMPINJ_ENABLE_EXTENSIONS;
import org.llrp.ltk.generated.custom.messages.IMPINJ_ENABLE_EXTENSIONS_RESPONSE;
import org.llrp.ltk.generated.custom.messages.IMPINJ_SAVE_SETTINGS;
import org.llrp.ltk.generated.custom.messages.IMPINJ_SAVE_SETTINGS_RESPONSE;
import org.llrp.ltk.generated.custom.parameters.ImpinjAccessSpecConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjAdvancedGPOConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjAuthenticate;
import org.llrp.ltk.generated.custom.parameters.ImpinjAuthenticateOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjBeaconConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjBlockPermalock;
import org.llrp.ltk.generated.custom.parameters.ImpinjBlockPermalockOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjBlockWriteWordCount;
import org.llrp.ltk.generated.custom.parameters.ImpinjC1G2DirectionConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjC1G2LocationConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjDISpec;
import org.llrp.ltk.generated.custom.parameters.ImpinjDiagnosticReport;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionReporting;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionSectors;
import org.llrp.ltk.generated.custom.parameters.ImpinjDirectionUserTagPopulationLimit;
import org.llrp.ltk.generated.custom.parameters.ImpinjDisabledAntennas;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableGPSCoordinates;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableOptimizedRead;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnablePeakRSSI;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableRFDopplerFrequency;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableRFPhaseAngle;
import org.llrp.ltk.generated.custom.parameters.ImpinjEnableSerializedTID;
import org.llrp.ltk.generated.custom.parameters.ImpinjExtendedTagInformation;
import org.llrp.ltk.generated.custom.parameters.ImpinjFixedFrequencyList;
import org.llrp.ltk.generated.custom.parameters.ImpinjGPIDebounceConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjGPSCoordinates;
import org.llrp.ltk.generated.custom.parameters.ImpinjGetQTConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjGetQTConfigOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjHubConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjInventorySearchMode;
import org.llrp.ltk.generated.custom.parameters.ImpinjLISpec;
import org.llrp.ltk.generated.custom.parameters.ImpinjLinkMonitorConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationAlgorithmControl;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjLocationReporting;
import org.llrp.ltk.generated.custom.parameters.ImpinjLowDutyCycle;
import org.llrp.ltk.generated.custom.parameters.ImpinjMarginRead;
import org.llrp.ltk.generated.custom.parameters.ImpinjMarginReadOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjOpSpecRetryCount;
import org.llrp.ltk.generated.custom.parameters.ImpinjPeakRSSI;
import org.llrp.ltk.generated.custom.parameters.ImpinjPlacementConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjPolarizationControl;
import org.llrp.ltk.generated.custom.parameters.ImpinjRFDopplerFrequency;
import org.llrp.ltk.generated.custom.parameters.ImpinjRFPhaseAngle;
import org.llrp.ltk.generated.custom.parameters.ImpinjReaderTemperature;
import org.llrp.ltk.generated.custom.parameters.ImpinjReducedPowerFrequencyList;
import org.llrp.ltk.generated.custom.parameters.ImpinjRequestedData;
import org.llrp.ltk.generated.custom.parameters.ImpinjSerializedTID;
import org.llrp.ltk.generated.custom.parameters.ImpinjSetQTConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjSetQTConfigOpSpecResult;
import org.llrp.ltk.generated.custom.parameters.ImpinjTagFilterVerificationConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjTagReportContentSelector;
import org.llrp.ltk.generated.custom.parameters.ImpinjTiltConfiguration;
import org.llrp.ltk.generated.custom.parameters.ImpinjTransmitPower;
import org.llrp.ltk.generated.custom.parameters.ImpinjTruncatedReplyConfiguration;
import org.llrp.ltk.generated.enumerations.AISpecStopTriggerType;
import org.llrp.ltk.generated.enumerations.AccessReportTriggerType;
import org.llrp.ltk.generated.enumerations.AccessSpecState;
import org.llrp.ltk.generated.enumerations.AccessSpecStopTriggerType;
import org.llrp.ltk.generated.enumerations.AirProtocols;
import org.llrp.ltk.generated.enumerations.C1G2LockDataField;
import org.llrp.ltk.generated.enumerations.C1G2LockPrivilege;
import org.llrp.ltk.generated.enumerations.C1G2StateUnawareAction;
import org.llrp.ltk.generated.enumerations.C1G2TruncateAction;
import org.llrp.ltk.generated.enumerations.GPIPortState;
import org.llrp.ltk.generated.enumerations.GetReaderCapabilitiesRequestedData;
import org.llrp.ltk.generated.enumerations.GetReaderConfigRequestedData;
import org.llrp.ltk.generated.enumerations.KeepaliveTriggerType;
import org.llrp.ltk.generated.enumerations.NotificationEventType;
import org.llrp.ltk.generated.enumerations.ROReportTriggerType;
import org.llrp.ltk.generated.enumerations.ROSpecStartTriggerType;
import org.llrp.ltk.generated.enumerations.ROSpecState;
import org.llrp.ltk.generated.enumerations.ROSpecStopTriggerType;
import org.llrp.ltk.generated.enumerations.StatusCode;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpecResult;
import org.llrp.ltk.generated.interfaces.AirProtocolEPCMemorySelector;
import org.llrp.ltk.generated.interfaces.AirProtocolInventoryCommandSettings;
import org.llrp.ltk.generated.interfaces.AirProtocolTagData;
import org.llrp.ltk.generated.interfaces.AirProtocolTagSpec;
import org.llrp.ltk.generated.interfaces.SpecParameter;
import org.llrp.ltk.generated.messages.ADD_ACCESSSPEC;
import org.llrp.ltk.generated.messages.ADD_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ADD_ROSPEC;
import org.llrp.ltk.generated.messages.ADD_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DELETE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.DELETE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.DELETE_ROSPEC;
import org.llrp.ltk.generated.messages.DISABLE_ROSPEC;
import org.llrp.ltk.generated.messages.ENABLE_ACCESSSPEC;
import org.llrp.ltk.generated.messages.ENABLE_ACCESSSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ENABLE_EVENTS_AND_REPORTS;
import org.llrp.ltk.generated.messages.ENABLE_ROSPEC;
import org.llrp.ltk.generated.messages.ENABLE_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.ERROR_MESSAGE;
import org.llrp.ltk.generated.messages.GET_ACCESSSPECS;
import org.llrp.ltk.generated.messages.GET_ACCESSSPECS_RESPONSE;
import org.llrp.ltk.generated.messages.GET_READER_CAPABILITIES;
import org.llrp.ltk.generated.messages.GET_READER_CAPABILITIES_RESPONSE;
import org.llrp.ltk.generated.messages.GET_READER_CONFIG;
import org.llrp.ltk.generated.messages.GET_READER_CONFIG_RESPONSE;
import org.llrp.ltk.generated.messages.GET_REPORT;
import org.llrp.ltk.generated.messages.GET_ROSPECS;
import org.llrp.ltk.generated.messages.GET_ROSPECS_RESPONSE;
import org.llrp.ltk.generated.messages.KEEPALIVE;
import org.llrp.ltk.generated.messages.KEEPALIVE_ACK;
import org.llrp.ltk.generated.messages.READER_EVENT_NOTIFICATION;
import org.llrp.ltk.generated.messages.RO_ACCESS_REPORT;
import org.llrp.ltk.generated.messages.SET_READER_CONFIG;
import org.llrp.ltk.generated.messages.SET_READER_CONFIG_RESPONSE;
import org.llrp.ltk.generated.messages.START_ROSPEC;
import org.llrp.ltk.generated.messages.START_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.messages.STOP_ROSPEC;
import org.llrp.ltk.generated.messages.STOP_ROSPEC_RESPONSE;
import org.llrp.ltk.generated.parameters.AISpec;
import org.llrp.ltk.generated.parameters.AISpecStopTrigger;
import org.llrp.ltk.generated.parameters.AccessCommand;
import org.llrp.ltk.generated.parameters.AccessReportSpec;
import org.llrp.ltk.generated.parameters.AccessSpec;
import org.llrp.ltk.generated.parameters.AccessSpecStopTrigger;
import org.llrp.ltk.generated.parameters.AntennaConfiguration;
import org.llrp.ltk.generated.parameters.C1G2BlockWrite;
import org.llrp.ltk.generated.parameters.C1G2BlockWriteOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2EPCMemorySelector;
import org.llrp.ltk.generated.parameters.C1G2Filter;
import org.llrp.ltk.generated.parameters.C1G2InventoryCommand;
import org.llrp.ltk.generated.parameters.C1G2Kill;
import org.llrp.ltk.generated.parameters.C1G2KillOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2Lock;
import org.llrp.ltk.generated.parameters.C1G2LockOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2LockPayload;
import org.llrp.ltk.generated.parameters.C1G2RFControl;
import org.llrp.ltk.generated.parameters.C1G2Read;
import org.llrp.ltk.generated.parameters.C1G2ReadOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2SingulationControl;
import org.llrp.ltk.generated.parameters.C1G2TagInventoryMask;
import org.llrp.ltk.generated.parameters.C1G2TagInventoryStateUnawareFilterAction;
import org.llrp.ltk.generated.parameters.C1G2TagSpec;
import org.llrp.ltk.generated.parameters.C1G2TargetTag;
import org.llrp.ltk.generated.parameters.C1G2Write;
import org.llrp.ltk.generated.parameters.C1G2WriteOpSpecResult;
import org.llrp.ltk.generated.parameters.C1G2_CRC;
import org.llrp.ltk.generated.parameters.C1G2_PC;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.EPCData;
import org.llrp.ltk.generated.parameters.EPC_96;
import org.llrp.ltk.generated.parameters.EventNotificationState;
import org.llrp.ltk.generated.parameters.EventsAndReports;
import org.llrp.ltk.generated.parameters.GPIPortCurrentState;
import org.llrp.ltk.generated.parameters.GPITriggerValue;
import org.llrp.ltk.generated.parameters.GPOWriteData;
import org.llrp.ltk.generated.parameters.GeneralDeviceCapabilities;
import org.llrp.ltk.generated.parameters.InventoryParameterSpec;
import org.llrp.ltk.generated.parameters.KeepaliveSpec;
import org.llrp.ltk.generated.parameters.LLRPStatus;
import org.llrp.ltk.generated.parameters.PeriodicTriggerValue;
import org.llrp.ltk.generated.parameters.RFReceiver;
import org.llrp.ltk.generated.parameters.RFTransmitter;
import org.llrp.ltk.generated.parameters.ROBoundarySpec;
import org.llrp.ltk.generated.parameters.ROReportSpec;
import org.llrp.ltk.generated.parameters.ROSpec;
import org.llrp.ltk.generated.parameters.ROSpecEvent;
import org.llrp.ltk.generated.parameters.ROSpecStartTrigger;
import org.llrp.ltk.generated.parameters.ROSpecStopTrigger;
import org.llrp.ltk.generated.parameters.ReaderEventNotificationSpec;
import org.llrp.ltk.generated.parameters.TagReportContentSelector;
import org.llrp.ltk.generated.parameters.TagReportData;
import org.llrp.ltk.generated.parameters.UTCTimestamp;
import org.llrp.ltk.net.LLRPConnection;
import org.llrp.ltk.net.LLRPConnectionAttemptFailedException;
import org.llrp.ltk.net.LLRPConnector;
import org.llrp.ltk.net.LLRPEndpoint;
import org.llrp.ltk.net.LLRPIoHandlerAdapter;
import org.llrp.ltk.net.LLRPIoHandlerAdapterImpl;
import org.llrp.ltk.types.Bit;
import org.llrp.ltk.types.BitArray_HEX;
import org.llrp.ltk.types.LLRPMessage;
import org.llrp.ltk.types.LLRPParameter;
import org.llrp.ltk.types.SignedInteger;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TwoBitField;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedIntegerArray;
import org.llrp.ltk.types.UnsignedLong;
import org.llrp.ltk.types.UnsignedLong_DATETIME;
import org.llrp.ltk.types.UnsignedShort;
import org.llrp.ltk.types.UnsignedShortArray;
import org.llrp.ltk.types.UnsignedShortArray_HEX;

public class ImpinjReader
implements LLRPEndpoint,
KeepaliveTimeoutListener {
    static final int RO_SPEC_ID = 14150;
    static final int RO_SPEC_INDEX = 0;
    static final int DEFAULT_TIMEOUT_MS = 5000;
    static final int DEFAULT_LLRP_PORT_UNSECURED = 5084;
    static final int DEFAULT_LLRP_PORT_ENCRYPTED = 5085;
    static final int ACCESS_PASSWORD_LENGTH_BITS = 32;
    private static final UnsignedShort UNIVERSAL_ANTENNA_ID = new UnsignedShort(0);
    private ConcurrentHashMap<Integer, TagData> outstandingAuthenticateRequests = new ConcurrentHashMap();
    MessageHandler messageHandler;
    int messageID = 0;
    LLRPConnection readerConnection;
    int messageTimeout;
    int connectTimeout;
    TagReportListener tagReportListener;
    TagOpCompleteListener tagOpCompleteListener;
    LocationReportListener locationReportListener;
    DirectionReportListener directionReportListener;
    DiagnosticsReportListener diagnosticsReportListener;
    GpiChangeListener gpiChangeListener;
    AntennaChangeListener antennaChangeListener;
    KeepaliveListener keepaliveListener;
    ConnectionLostListener connectionLostListener;
    ReaderStartListener readerStartListener;
    ReaderStopListener readerStopListener;
    BufferWarningListener bufferWarningListener;
    BufferOverflowListener bufferOverflowListener;
    ConnectionAttemptListener connectionAttemptListener;
    ConnectionCloseListener connectionCloseListener;
    KeepaliveTimer keepaliveTimer;
    String name;
    String address;
    FeatureSet readerCapabilities = new FeatureSet();

    public ImpinjReader(String address, String name, int timeoutMs) {
        this.keepaliveTimer = new KeepaliveTimer();
        this.keepaliveTimer.setKeepaliveTimeoutListener(this);
        this.messageHandler = null;
        this.address = address;
        this.name = name;
        this.messageTimeout = timeoutMs;
        this.connectTimeout = timeoutMs;
    }

    public ImpinjReader(String address, String name) {
        this(address, name, 5000);
    }

    public ImpinjReader() {
        this("", "", 5000);
    }

    @Deprecated
    public boolean readerIsXArray() {
        if (this.readerCapabilities != null) {
            return this.readerCapabilities.getModelNumber() == 2001004 || this.readerCapabilities.getModelNumber() == 2001006 || this.readerCapabilities.getModelNumber() == 2001007;
        }
        return false;
    }

    public boolean isXArray() {
        return this.readerCapabilities != null && this.readerCapabilities.getReaderModel().isXArray();
    }

    public boolean isXSpan() {
        return this.readerCapabilities != null && this.readerCapabilities.getReaderModel() == ReaderModel.XSpan;
    }

    public boolean isSpatialReader() {
        return this.readerCapabilities != null && this.readerCapabilities.getReaderModel().isSpatialReader();
    }

    public int getMessageTimeout() {
        return this.messageTimeout;
    }

    public void setMessageTimeout(int messageTimeoutMsec) {
        this.messageTimeout = messageTimeoutMsec;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeoutMsec) {
        this.connectTimeout = connectTimeoutMsec;
    }

    public TagReportListener getTagReportListener() {
        return this.tagReportListener;
    }

    public void setTagReportListener(TagReportListener tagReportListener) {
        this.tagReportListener = tagReportListener;
    }

    public void removeTagReportListener() {
        this.tagReportListener = null;
    }

    public TagOpCompleteListener getTagOpCompleteListener() {
        return this.tagOpCompleteListener;
    }

    public void setTagOpCompleteListener(TagOpCompleteListener tagOpCompleteListener) {
        this.tagOpCompleteListener = tagOpCompleteListener;
    }

    public void removeTagOpCompleteListener() {
        this.tagOpCompleteListener = null;
    }

    public LocationReportListener getLocationReportedListener() {
        return this.locationReportListener;
    }

    public void setLocationReportListener(LocationReportListener locationReportListener) {
        this.locationReportListener = locationReportListener;
    }

    public void removeLocationReportListener() {
        this.locationReportListener = null;
    }

    public void setDirectionReportListener(DirectionReportListener directionReportListener) {
        this.directionReportListener = directionReportListener;
    }

    public void removeDirectionReportListener() {
        this.directionReportListener = null;
    }

    public DiagnosticsReportListener getDiagnosticsReportedListener() {
        return this.diagnosticsReportListener;
    }

    public void setDiagnosticsReportListener(DiagnosticsReportListener diagnosticsReportListener) {
        this.diagnosticsReportListener = diagnosticsReportListener;
    }

    public void removeDiagnosticsReportListener() {
        this.diagnosticsReportListener = null;
    }

    public GpiChangeListener getGpiChangeListener() {
        return this.gpiChangeListener;
    }

    public void setGpiChangeListener(GpiChangeListener gpiChangeListener) {
        this.gpiChangeListener = gpiChangeListener;
    }

    public void removeGpiChangeListener() {
        this.gpiChangeListener = null;
    }

    public AntennaChangeListener getAntennaChangeListener() {
        return this.antennaChangeListener;
    }

    public void setAntennaChangeListener(AntennaChangeListener antennaChangeListener) {
        this.antennaChangeListener = antennaChangeListener;
    }

    public void removeAntennaChangeListener() {
        this.antennaChangeListener = null;
    }

    public KeepaliveListener getKeepaliveListener() {
        return this.keepaliveListener;
    }

    public void setKeepaliveListener(KeepaliveListener keepaliveListener) {
        this.keepaliveListener = keepaliveListener;
    }

    public ConnectionLostListener getConnectionLostListener() {
        return this.connectionLostListener;
    }

    public void setConnectionLostListener(ConnectionLostListener connectionLostListener) {
        this.connectionLostListener = connectionLostListener;
    }

    public ReaderStartListener getReaderStartListener() {
        return this.readerStartListener;
    }

    public void setReaderStartListener(ReaderStartListener readerStartListener) {
        this.readerStartListener = readerStartListener;
    }

    public ReaderStopListener getReaderStopListener() {
        return this.readerStopListener;
    }

    public void setReaderStopListener(ReaderStopListener readerStopListener) {
        this.readerStopListener = readerStopListener;
    }

    public BufferWarningListener getBufferWarningListener() {
        return this.bufferWarningListener;
    }

    public void setBufferWarningListener(BufferWarningListener bufferWarningListener) {
        this.bufferWarningListener = bufferWarningListener;
    }

    public BufferOverflowListener getBufferOverflowListener() {
        return this.bufferOverflowListener;
    }

    public void setBufferOverflowListener(BufferOverflowListener bufferOverflowListener) {
        this.bufferOverflowListener = bufferOverflowListener;
    }

    public ConnectionAttemptListener getConnectionAttemptListener() {
        return this.connectionAttemptListener;
    }

    public void setConnectionAttemptListener(ConnectionAttemptListener connectionAttemptListener) {
        this.connectionAttemptListener = connectionAttemptListener;
    }

    public ConnectionCloseListener getConnectionCloseListener() {
        return this.connectionCloseListener;
    }

    public void setConnectionCloseListener(ConnectionCloseListener connectionCloseListener) {
        this.connectionCloseListener = connectionCloseListener;
    }

    @Override
    public void onKeepaliveTimeout() {
        if (this.connectionLostListener != null) {
            this.connectionLostListener.onConnectionLost(this);
        }
    }

    void onKeepaliveMessage(KEEPALIVE msg) {
        this.keepaliveTimer.stop();
        this.keepaliveTimer.start();
        KEEPALIVE_ACK ack = new KEEPALIVE_ACK();
        ack.setMessageID(msg.getMessageID());
        this.readerConnection.send((LLRPMessage)ack);
        if (this.keepaliveListener != null) {
            this.keepaliveListener.onKeepalive(this, new KeepaliveEvent());
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String toString() {
        return this.address;
    }

    public void connect() throws OctaneSdkException {
        if (this.address == null || this.address.trim() == "") {
            throw new OctaneSdkException("The Address property must be set before calling Connect.");
        }
        this.connect(this.address, 5084);
    }

    public void connect(String address) throws OctaneSdkException {
        this.connect(address, 5084);
    }

    public void connect(String address, boolean useTLS) throws OctaneSdkException {
        int port = useTLS ? 5085 : 5084;
        this.connect(address, port, useTLS);
    }

    public void connect(String address, int port) throws OctaneSdkException {
        boolean useTLS = false;
        this.connect(address, port, false);
    }

    public void connect(String address, int port, boolean useTLS) throws OctaneSdkException {
        LLRPIoHandlerAdapterImpl llrpio = new LLRPIoHandlerAdapterImpl();
        llrpio.setKeepAliveAck(false);
        llrpio.setKeepAliveForward(true);
        if (this.readerConnection == null) {
            this.readerConnection = new LLRPConnector((LLRPEndpoint)this, address, (LLRPIoHandlerAdapter)llrpio);
        }
        llrpio.setConnection(this.readerConnection);
        ((LLRPConnector)this.readerConnection).setPort(port);
        try {
            ((LLRPConnector)this.readerConnection).connect((long)this.connectTimeout, useTLS);
        }
        catch (LLRPConnectionAttemptFailedException llrpConnectionAttemptFailedEx) {
            this.readerConnection = null;
            throw new OctaneSdkException("Error connecting to the reader (" + address + ") : " + llrpConnectionAttemptFailedEx.getMessage());
        }
        catch (RuntimeIoException runtimeIoException) {
            this.readerConnection = null;
            throw new OctaneSdkException("Error connecting to the reader (" + address + ") : " + runtimeIoException.getMessage());
        }
        this.address = address;
        this.enableImpinjExtensions();
        this.validateReader();
        this.startMessageHandler();
    }

    void startMessageHandler() {
        if (this.messageHandler == null || !this.messageHandler.isAlive()) {
            this.messageHandler = new MessageHandler(this);
            this.messageHandler.start();
        }
    }

    void validateReader() throws OctaneSdkException {
        this.readerCapabilities = this.queryFeatureSet();
        int speedwayClassicModelNumber = 1000000;
        if (this.readerCapabilities.getModelNumber() == 1000000) {
            this.disconnect();
            throw new OctaneSdkException("The Octane SDK does not support the Speedway R1000 reader.");
        }
    }

    public boolean isConnected() {
        return this.readerConnection != null;
    }

    UnsignedInteger getUniqueMessageID() {
        return new UnsignedInteger(this.messageID++);
    }

    public FeatureSet queryFeatureSet() throws OctaneSdkException {
        FeatureSet capabilities = null;
        GET_READER_CAPABILITIES_RESPONSE rsp = this.getReaderCapabilities();
        capabilities = new FeatureSet(rsp);
        return capabilities;
    }

    GET_READER_CAPABILITIES_RESPONSE getReaderCapabilities() throws OctaneSdkException {
        GET_READER_CAPABILITIES get = new GET_READER_CAPABILITIES();
        GetReaderCapabilitiesRequestedData data = new GetReaderCapabilitiesRequestedData(0);
        get.setRequestedData(data);
        get.setMessageID(this.getUniqueMessageID());
        try {
            LLRPMessage response = this.readerConnection.transact((LLRPMessage)get, (long)this.messageTimeout);
            GET_READER_CAPABILITIES_RESPONSE gresp = (GET_READER_CAPABILITIES_RESPONSE)response;
            StatusCode status = gresp.getLLRPStatus().getStatusCode();
            if (status.equals((Object)new StatusCode("M_Success"))) {
                GeneralDeviceCapabilities dev_cap = gresp.getGeneralDeviceCapabilities();
                if (dev_cap != null && !dev_cap.getDeviceManufacturerName().equals((Object)new UnsignedInteger(25882))) {
                    throw new OctaneSdkException("OctaneSdk must use Impinj model Reader, not " + dev_cap.getDeviceManufacturerName().toString());
                }
            } else {
                throw new OctaneSdkException("OctaneSdk exception. [status]=[" + status.toXMLString() + "]");
            }
            return gresp;
        }
        catch (Exception ex) {
            throw new OctaneSdkException("OctaneSdk exception: " + ex.getMessage());
        }
    }

    void enableImpinjExtensions() throws OctaneSdkException {
        try {
            IMPINJ_ENABLE_EXTENSIONS impinjEnableExtensions = new IMPINJ_ENABLE_EXTENSIONS();
            impinjEnableExtensions.setMessageID(this.getUniqueMessageID());
            LLRPMessage response = this.readerConnection.transact((LLRPMessage)impinjEnableExtensions, (long)this.messageTimeout);
            StatusCode status = ((IMPINJ_ENABLE_EXTENSIONS_RESPONSE)response).getLLRPStatus().getStatusCode();
            if (!status.equals((Object)new StatusCode("M_Success"))) {
                throw new OctaneSdkException("OctaneSdk exception: received invalid Impinj extension response from reader");
            }
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        catch (Exception ex) {
            throw new OctaneSdkException("OctaneSdk exception: " + ex.getMessage());
        }
    }

    void startRoSpec() throws OctaneSdkException {
        START_ROSPEC msg = new START_ROSPEC();
        UnsignedInteger roSpecId = new UnsignedInteger(14150);
        msg.setMessageID(this.getUniqueMessageID());
        msg.setROSpecID(roSpecId);
        ERROR_MESSAGE msgErr = null;
        LLRPMessage rsp = null;
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        String msgType = "START_ROSPEC";
        this.checkForNullReply(msgType, rsp, msgErr);
        StatusCode status = ((START_ROSPEC_RESPONSE)rsp).getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            try {
                String llrMessage = rsp.toXMLString();
                throw new OctaneSdkException("OctaneSdk exception: " + llrMessage);
            }
            catch (InvalidLLRPMessageException invalidLLRPMessageEx) {
                throw new OctaneSdkException("OctaneSdk exception: " + invalidLLRPMessageEx.getMessage());
            }
        }
    }

    void stopRoSpec() throws OctaneSdkException {
        LLRPMessage rsp;
        STOP_ROSPEC msg = new STOP_ROSPEC();
        ERROR_MESSAGE msgErr = null;
        msg.setMessageID(this.getUniqueMessageID());
        UnsignedInteger roSpecId = new UnsignedInteger(14150);
        msg.setROSpecID(roSpecId);
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        String msgType = "STOP_ROSPEC";
        this.checkForNullReply(msgType, rsp, msgErr);
        StatusCode status = ((STOP_ROSPEC_RESPONSE)rsp).getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            try {
                String llrMessage = rsp.toXMLString();
                throw new OctaneSdkException("OctaneSdk exception: " + llrMessage);
            }
            catch (InvalidLLRPMessageException invalidLLRPMessageEx) {
                throw new OctaneSdkException("OctaneSdk exception: " + invalidLLRPMessageEx.getMessage());
            }
        }
    }

    public void disconnect() {
        if (this.readerConnection != null) {
            this.keepaliveTimer.stop();
            ((LLRPConnector)this.readerConnection).disconnect();
            this.readerConnection = null;
            this.messageHandler.interrupt();
            try {
                this.messageHandler.join(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void stop() throws OctaneSdkException {
        if (this.readerConnection != null) {
            this.disableRoSpec();
        }
    }

    public void start() throws OctaneSdkException {
        if (this.readerConnection == null) {
            throw new OctaneSdkException("You must connect to the reader before starting it.");
        }
        this.enableRoSpec();
        this.startRoSpec();
    }

    public void applyDefaultSettings() throws OctaneSdkException {
        if (this.readerConnection == null) {
            String msg = "You must connect to the reader before configuring it.";
            throw new OctaneSdkException(msg);
        }
        long numberOfAntennas = this.readerCapabilities.getAntennaCount();
        int numberOfGpis = this.readerCapabilities.getGpiCount();
        int numberOfGpos = this.readerCapabilities.getGpoCount();
        String firmwareVersion = this.readerCapabilities.getFirmwareVersion();
        Settings settings = new Settings(numberOfAntennas, numberOfGpis, numberOfGpos, firmwareVersion);
        this.applySettings(settings);
    }

    public void applySettings(SET_READER_CONFIG setReaderConfigMessage, ADD_ROSPEC addROSpecMessage) throws OctaneSdkException {
        this.applySettingsWithOptionalFactoryReset(setReaderConfigMessage, addROSpecMessage, true);
    }

    public void applySettingsWithoutFactoryReset(SET_READER_CONFIG setReaderConfigMessage, ADD_ROSPEC addROSpecMessage) throws OctaneSdkException {
        this.applySettingsWithOptionalFactoryReset(setReaderConfigMessage, addROSpecMessage, false);
    }

    private void applySettingsWithOptionalFactoryReset(SET_READER_CONFIG setReaderConfigMessage, ADD_ROSPEC addROSpecMessage, boolean resetToFactorySettings) throws OctaneSdkException {
        if (this.readerConnection != null) {
            this.keepaliveTimer.stop();
            if (resetToFactorySettings) {
                this.resetToFactoryDefaults();
            }
        } else {
            String msg = "You must connect to the reader before configuring it.";
            throw new OctaneSdkException(msg);
        }
        this.outstandingAuthenticateRequests.clear();
        this.deleteRoSpecs();
        this.deleteAccessSpecs();
        this.enableImpinjExtensions();
        this.setReaderConfig(setReaderConfigMessage);
        this.addRoSpec(addROSpecMessage);
        this.enableRoSpec();
    }

    public void applySettings(Settings settings) throws OctaneSdkException {
        this.applySettings(this.buildSetReaderConfigMessage(settings), this.buildAddROSpecMessage(settings));
    }

    public void applySettingsWithoutFactoryReset(Settings settings) throws OctaneSdkException {
        this.applySettingsWithoutFactoryReset(this.buildSetReaderConfigMessage(settings), this.buildAddROSpecMessage(settings));
    }

    public void saveSettings() throws OctaneSdkException {
        try {
            IMPINJ_SAVE_SETTINGS impinjSaveSettings = new IMPINJ_SAVE_SETTINGS();
            impinjSaveSettings.setMessageID(this.getUniqueMessageID());
            impinjSaveSettings.setSaveConfiguration(new Bit(1));
            LLRPMessage response = this.readerConnection.transact((LLRPMessage)impinjSaveSettings, 10000L);
            StatusCode status = ((IMPINJ_SAVE_SETTINGS_RESPONSE)response).getLLRPStatus().getStatusCode();
            if (!status.equals((Object)new StatusCode("M_Success"))) {
                throw new OctaneSdkException("error executing save settings command");
            }
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        catch (Exception ex) {
            throw new OctaneSdkException("OctaneSdk exception: " + ex.getMessage());
        }
    }

    void resetToFactoryDefaults() throws OctaneSdkException {
        LLRPMessage rsp;
        ERROR_MESSAGE msgErr = null;
        SET_READER_CONFIG msg = new SET_READER_CONFIG();
        msg.setMessageID(this.getUniqueMessageID());
        msg.setResetToFactoryDefault(new Bit(true));
        String msgType = "Reset to factory defaults";
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        this.checkForNullReply(msgType, rsp, msgErr);
        StatusCode status = ((SET_READER_CONFIG_RESPONSE)rsp).getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            throw new OctaneSdkException(msgType + " failures");
        }
    }

    void deleteRoSpecs() throws OctaneSdkException {
        LLRPMessage rsp;
        ERROR_MESSAGE msgErr = null;
        DELETE_ROSPEC msg = new DELETE_ROSPEC();
        msg.setMessageID(this.getUniqueMessageID());
        msg.setROSpecID(new UnsignedInteger(0));
        String msgType = "DELETE_ROSPEC";
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        this.checkForNullReply(msgType, rsp, msgErr);
    }

    void deleteAccessSpecs() throws OctaneSdkException {
        LLRPMessage rsp;
        ERROR_MESSAGE msgErr = null;
        DELETE_ACCESSSPEC msg = new DELETE_ACCESSSPEC();
        msg.setMessageID(this.getUniqueMessageID());
        msg.setAccessSpecID(new UnsignedInteger(0));
        String msgType = "DELETE_ACCESSSPEC";
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        this.checkForNullReply(msgType, rsp, msgErr);
    }

    void addRoSpec(ADD_ROSPEC addRoSpec) throws OctaneSdkException {
        LLRPMessage rsp = null;
        String msgType = "ADD_ROSPEC";
        try {
            rsp = this.readerConnection.transact((LLRPMessage)addRoSpec, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        ERROR_MESSAGE msgErr = null;
        this.checkForNullReply(msgType, rsp, msgErr);
        StatusCode status = ((ADD_ROSPEC_RESPONSE)rsp).getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            try {
                String llrMessage = rsp.toXMLString();
                throw new OctaneSdkException("OctaneSdk exception: " + llrMessage);
            }
            catch (InvalidLLRPMessageException invalidLLRPMessageEx) {
                throw new OctaneSdkException("OctaneSdk exception: " + invalidLLRPMessageEx.getMessage());
            }
        }
    }

    void addRoSpec(Settings config) throws OctaneSdkException {
        this.addRoSpec(this.buildAddROSpecMessage(config));
    }

    public ADD_ROSPEC buildAddROSpecMessage(Settings config) throws OctaneSdkException {
        ROSpecStartTriggerType roSpecStartTriggerType;
        ADD_ROSPEC addRoSpec = new ADD_ROSPEC();
        ROSpec roSpec = new ROSpec();
        int index = 0;
        this.outstandingAuthenticateRequests.clear();
        ROSpecState currentState = new ROSpecState();
        currentState.set(0);
        roSpec.setCurrentState(currentState);
        roSpec.setPriority(new UnsignedByte(0));
        UnsignedInteger roSpecId = new UnsignedInteger(14150);
        roSpec.setROSpecID(roSpecId);
        addRoSpec.setMessageID(this.getUniqueMessageID());
        ROBoundarySpec roBoundarySpec = new ROBoundarySpec();
        ROSpecStartTrigger roSpecStartTrigger = new ROSpecStartTrigger();
        if (config.getAutoStart().getMode() == AutoStartMode.GpiTrigger) {
            GPITriggerValue gpiStartTrigger = new GPITriggerValue();
            gpiStartTrigger.setGPIPortNum(new UnsignedShort(config.getAutoStart().getGpiPortNumber()));
            gpiStartTrigger.setGPIEvent(new Bit(config.getAutoStart().getGpiLevel()));
            gpiStartTrigger.setTimeout(new UnsignedInteger(0));
            roSpecStartTrigger.setGPITriggerValue(gpiStartTrigger);
            roSpecStartTrigger.setROSpecStartTriggerType(new ROSpecStartTriggerType(3));
        } else if (config.getAutoStart().getMode() == AutoStartMode.Periodic) {
            PeriodicTriggerValue periodicTrigger = new PeriodicTriggerValue();
            periodicTrigger.setOffset(new UnsignedInteger(config.getAutoStart().getFirstDelayInMs()));
            periodicTrigger.setPeriod(new UnsignedInteger(config.getAutoStart().getPeriodInMs()));
            if (config.getAutoStart().getUtcTimestamp() != 0L) {
                UTCTimestamp utcTimestamp = new UTCTimestamp();
                utcTimestamp.setMicroseconds(new UnsignedLong_DATETIME(config.getAutoStart().getUtcTimestamp()));
                periodicTrigger.setUTCTimestamp(utcTimestamp);
            }
            roSpecStartTrigger.setPeriodicTriggerValue(periodicTrigger);
            roSpecStartTrigger.setROSpecStartTriggerType(new ROSpecStartTriggerType(2));
        } else if (config.getAutoStart().getMode() == AutoStartMode.Immediate) {
            roSpecStartTriggerType = new ROSpecStartTriggerType(1);
            roSpecStartTrigger.setROSpecStartTriggerType(roSpecStartTriggerType);
        } else {
            roSpecStartTriggerType = new ROSpecStartTriggerType(0);
            roSpecStartTrigger.setROSpecStartTriggerType(roSpecStartTriggerType);
        }
        ROSpecStopTrigger roSpecStopTrigger = new ROSpecStopTrigger();
        if (config.getAutoStop().getMode() == AutoStopMode.Duration) {
            roSpecStopTrigger.setDurationTriggerValue(new UnsignedInteger(config.getAutoStop().getDurationInMs()));
            roSpecStopTrigger.setROSpecStopTriggerType(new ROSpecStopTriggerType(1));
        } else if (config.getAutoStop().getMode() == AutoStopMode.GpiTrigger) {
            GPITriggerValue gpiStopTrigger = new GPITriggerValue();
            gpiStopTrigger.setGPIPortNum(new UnsignedShort(config.getAutoStop().getGpiPortNumber()));
            gpiStopTrigger.setGPIEvent(new Bit(config.getAutoStop().getGpiLevel()));
            gpiStopTrigger.setTimeout(new UnsignedInteger(config.getAutoStop().getTimeout()));
            roSpecStopTrigger.setGPITriggerValue(gpiStopTrigger);
            roSpecStopTrigger.setDurationTriggerValue(new UnsignedInteger(0));
            roSpecStopTrigger.setROSpecStopTriggerType(new ROSpecStopTriggerType(2));
        } else {
            ROSpecStopTriggerType roSpecStopTriggerType = new ROSpecStopTriggerType(0);
            roSpecStopTrigger.setROSpecStopTriggerType(roSpecStopTriggerType);
            roSpecStopTrigger.setDurationTriggerValue(new UnsignedInteger(0));
        }
        roSpec.addToSpecParameterList(this.getSpecParameter(config));
        ROReportSpec roReportSpec = new ROReportSpec();
        if (config.getReport().getMode() == ReportMode.Individual) {
            roReportSpec.setROReportTrigger(new ROReportTriggerType(2));
            roReportSpec.setN(new UnsignedShort(1));
        } else if (config.getReport().getMode() == ReportMode.BatchAfterStop) {
            roReportSpec.setROReportTrigger(new ROReportTriggerType(2));
            roReportSpec.setN(new UnsignedShort(0));
        } else if (config.getReport().getMode() == ReportMode.WaitForQuery) {
            roReportSpec.setROReportTrigger(new ROReportTriggerType(0));
            roReportSpec.setN(new UnsignedShort(0));
        }
        TagReportContentSelector tagReportContentSelector = new TagReportContentSelector();
        tagReportContentSelector.setEnableAccessSpecID(new Bit(true));
        tagReportContentSelector.setEnableAntennaID(new Bit(config.getReport().getIncludeAntennaPortNumber()));
        tagReportContentSelector.setEnableChannelIndex(new Bit(config.getReport().getIncludeChannel()));
        tagReportContentSelector.setEnableFirstSeenTimestamp(new Bit(config.getReport().getIncludeFirstSeenTime()));
        if (config.getReport().getIncludeCrc().booleanValue() || config.getReport().getIncludePcBits().booleanValue()) {
            C1G2EPCMemorySelector memSel = new C1G2EPCMemorySelector();
            memSel.setEnableCRC(new Bit(config.getReport().getIncludeCrc()));
            memSel.setEnablePCBits(new Bit(config.getReport().getIncludePcBits()));
            tagReportContentSelector.addToAirProtocolEPCMemorySelectorList((AirProtocolEPCMemorySelector)memSel);
        }
        tagReportContentSelector.setEnableInventoryParameterSpecID(new Bit(false));
        tagReportContentSelector.setEnableLastSeenTimestamp(new Bit(config.getReport().getIncludeLastSeenTime()));
        tagReportContentSelector.setEnablePeakRSSI(new Bit(false));
        tagReportContentSelector.setEnableROSpecID(new Bit(false));
        tagReportContentSelector.setEnableSpecIndex(new Bit(false));
        tagReportContentSelector.setEnableTagSeenCount(new Bit(config.getReport().getIncludeSeenCount()));
        roReportSpec.setTagReportContentSelector(tagReportContentSelector);
        ImpinjTagReportContentSelector contentSelector = new ImpinjTagReportContentSelector();
        if (config.getReport().getIncludeFastId().booleanValue()) {
            ImpinjEnableSerializedTID impinjEnableSerializedTID = new ImpinjEnableSerializedTID();
            impinjEnableSerializedTID.setSerializedTIDMode(new ImpinjSerializedTIDMode(1));
            contentSelector.setImpinjEnableSerializedTID(impinjEnableSerializedTID);
        }
        if (config.getReport().getIncludeDopplerFrequency().booleanValue()) {
            ImpinjEnableRFDopplerFrequency impinjEnableRFDopplerFrequency = new ImpinjEnableRFDopplerFrequency();
            impinjEnableRFDopplerFrequency.setRFDopplerFrequencyMode(new ImpinjRFDopplerFrequencyMode(1));
            contentSelector.setImpinjEnableRFDopplerFrequency(impinjEnableRFDopplerFrequency);
        }
        if (config.getReport().getIncludePhaseAngle().booleanValue()) {
            ImpinjEnableRFPhaseAngle impinjEnableRFPhaseAngle = new ImpinjEnableRFPhaseAngle();
            impinjEnableRFPhaseAngle.setRFPhaseAngleMode(new ImpinjRFPhaseAngleMode(1));
            contentSelector.setImpinjEnableRFPhaseAngle(impinjEnableRFPhaseAngle);
        }
        if (config.getReport().getIncludePeakRssi().booleanValue()) {
            ImpinjEnablePeakRSSI impinjEnablePeakRSSI = new ImpinjEnablePeakRSSI();
            impinjEnablePeakRSSI.setPeakRSSIMode(new ImpinjPeakRSSIMode(1));
            contentSelector.setImpinjEnablePeakRSSI(impinjEnablePeakRSSI);
        }
        if (config.getReport().getOptimizedReadOps() != null) {
            if (config.getReport().getOptimizedReadOps().size() > 2) {
                throw new OctaneSdkException("A maximum of two optimized read operations may be specified.");
            }
            if (config.getReport().getOptimizedReadOps().size() > 0) {
                ArrayList<TagReadOp> ops = config.getReport().getOptimizedReadOps();
                C1G2Read[] c1g2Ops = new C1G2Read[ops.size()];
                ImpinjEnableOptimizedRead impinjEnableOptimizedRead = new ImpinjEnableOptimizedRead();
                impinjEnableOptimizedRead.setOptimizedReadMode(new ImpinjOptimizedReadMode(1));
                index = 0;
                for (TagReadOp op : ops) {
                    c1g2Ops[index] = new C1G2Read();
                    c1g2Ops[index].setAccessPassword(new UnsignedInteger(op.getAccessPassword().toDoubleWord()));
                    c1g2Ops[index].setMB(this.twoBitFieldFromInt(op.getMemoryBank().getValue()));
                    c1g2Ops[index].setOpSpecID(new UnsignedShort((int)op.Id));
                    c1g2Ops[index].setWordPointer(new UnsignedShort((int)op.getWordPointer()));
                    c1g2Ops[index].setWordCount(new UnsignedShort((int)op.getWordCount()));
                    impinjEnableOptimizedRead.addToC1G2ReadList(c1g2Ops[index]);
                    index = (short)(index + 1);
                }
                contentSelector.setImpinjEnableOptimizedRead(impinjEnableOptimizedRead);
            }
        }
        if (config.getReport().getIncludeGpsCoordinates().booleanValue()) {
            ImpinjEnableGPSCoordinates impinjEnableGPSCoordinates = new ImpinjEnableGPSCoordinates();
            impinjEnableGPSCoordinates.setGPSCoordinatesMode(new ImpinjGPSCoordinatesMode(1));
            contentSelector.setImpinjEnableGPSCoordinates(impinjEnableGPSCoordinates);
        }
        if (contentSelector.getImpinjEnableGPSCoordinates() != null || contentSelector.getImpinjEnableOptimizedRead() != null || contentSelector.getImpinjEnablePeakRSSI() != null || contentSelector.getImpinjEnableRFDopplerFrequency() != null || contentSelector.getImpinjEnableRFPhaseAngle() != null || contentSelector.getImpinjEnableSerializedTID() != null) {
            roReportSpec.addToCustomList((Custom)contentSelector);
        }
        roBoundarySpec.setROSpecStartTrigger(roSpecStartTrigger);
        roBoundarySpec.setROSpecStopTrigger(roSpecStopTrigger);
        roSpec.setROBoundarySpec(roBoundarySpec);
        roSpec.setROReportSpec(roReportSpec);
        addRoSpec.setROSpec(roSpec);
        return addRoSpec;
    }

    SpecParameter getSpecParameter(Settings config) throws OctaneSdkException {
        Object outputSpec = null;
        outputSpec = this.isSpatialReader() ? this.getSpatialSpecParameter(config) : this.getAiSpec(config);
        return outputSpec;
    }

    SpecParameter getSpatialSpecParameter(Settings config) throws OctaneSdkException {
        ImpinjLISpec outputSpec = null;
        switch (config.getSpatialConfig().getMode()) {
            case Location: {
                outputSpec = this.getLISpec(config);
                break;
            }
            case Direction: {
                outputSpec = this.getDISpec(config);
                break;
            }
            default: {
                outputSpec = this.getAiSpec(config);
            }
        }
        return outputSpec;
    }

    void enableRoSpec() throws OctaneSdkException {
        ENABLE_ROSPEC msg = new ENABLE_ROSPEC();
        msg.setROSpecID(new UnsignedInteger(14150));
        msg.setMessageID(this.getUniqueMessageID());
        ERROR_MESSAGE msgErr = null;
        String msgType = "ENABLE_ROSPEC";
        LLRPMessage rsp = null;
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        this.checkForNullReply(msgType, rsp, msgErr);
        StatusCode status = ((ENABLE_ROSPEC_RESPONSE)rsp).getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            try {
                String llrMessage = rsp.toXMLString();
                throw new OctaneSdkException("OctaneSdk exception: " + llrMessage);
            }
            catch (InvalidLLRPMessageException invalidLLRPMessageEx) {
                throw new OctaneSdkException("OctaneSdk exception: " + invalidLLRPMessageEx.getMessage());
            }
        }
    }

    void disableRoSpec() throws OctaneSdkException {
        DISABLE_ROSPEC msg = new DISABLE_ROSPEC();
        ERROR_MESSAGE msgErr = null;
        msg.setROSpecID(new UnsignedInteger(14150));
        msg.setMessageID(this.getUniqueMessageID());
        String msgType = "DISABLE_ROSPEC";
        LLRPMessage rsp = null;
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        this.checkForNullReply(msgType, rsp, msgErr);
    }

    void checkForNullReply(String msgType, LLRPMessage rsp, ERROR_MESSAGE msgErr) throws OctaneSdkException {
        if (rsp == null) {
            if (msgErr == null) {
                this.throwTimeoutException(msgType);
            } else {
                this.throwParsingException(msgType, msgErr);
            }
        }
    }

    void checkLlrpReply(LLRPStatus status, ERROR_MESSAGE msgErr, String messageType) throws OctaneSdkException {
        if (status.getStatusCode().intValue() == 0) {
            return;
        }
        String msg = "Error while sending message " + messageType;
        msg = msg + " : " + status.getStatusCode();
        msg = msg + " : " + status.getErrorDescription().toString();
        throw new OctaneSdkException(msg);
    }

    void throwTimeoutException(String msgType) throws OctaneSdkException {
        String msg = "A timeout occurred while sending the message : " + msgType;
        throw new OctaneSdkException(msg);
    }

    void throwParsingException(String msgType, ERROR_MESSAGE msgErr) throws OctaneSdkException {
        String msg = "A error occurred while parsing the message reply : " + msgType;
        msg = msg + " : " + msgErr.getLLRPStatus().getStatusCode();
        msg = msg + " : " + msgErr.getLLRPStatus().getErrorDescription().toString();
        throw new OctaneSdkException(msg);
    }

    Settings parseRoSpecAndConfig(ROSpec rospec, GET_READER_CONFIG_RESPONSE config) throws OctaneSdkException {
        int i;
        Settings s = new Settings();
        s.getAutoStart().setMode(AutoStartMode.valueOf(rospec.getROBoundarySpec().getROSpecStartTrigger().getROSpecStartTriggerType().intValue()));
        if (s.getAutoStart().getMode() == AutoStartMode.GpiTrigger) {
            s.getAutoStart().setGpiPortNumber(rospec.getROBoundarySpec().getROSpecStartTrigger().getGPITriggerValue().getGPIPortNum().intValue());
            s.getAutoStart().setGpiLevel(rospec.getROBoundarySpec().getROSpecStartTrigger().getGPITriggerValue().getGPIEvent().toBoolean());
        } else if (s.getAutoStart().getMode() == AutoStartMode.Periodic) {
            s.getAutoStart().setFirstDelayInMs(rospec.getROBoundarySpec().getROSpecStartTrigger().getPeriodicTriggerValue().getOffset().intValue());
            s.getAutoStart().setPeriodInMs(rospec.getROBoundarySpec().getROSpecStartTrigger().getPeriodicTriggerValue().getPeriod().intValue());
            s.getAutoStart().setUtcTimestamp(rospec.getROBoundarySpec().getROSpecStartTrigger().getPeriodicTriggerValue().getUTCTimestamp().getMicroseconds().toLong());
        }
        s.getAutoStop().setMode(AutoStopMode.valueOf(rospec.getROBoundarySpec().getROSpecStopTrigger().getROSpecStopTriggerType().intValue()));
        if (s.getAutoStop().getMode() == AutoStopMode.Duration) {
            s.getAutoStop().setDurationInMs(rospec.getROBoundarySpec().getROSpecStopTrigger().getDurationTriggerValue().intValue());
        } else if (s.getAutoStop().getMode() == AutoStopMode.GpiTrigger) {
            s.getAutoStop().setGpiPortNumber(rospec.getROBoundarySpec().getROSpecStopTrigger().getGPITriggerValue().getGPIPortNum().intValue());
            s.getAutoStop().setGpiLevel(rospec.getROBoundarySpec().getROSpecStopTrigger().getGPITriggerValue().getGPIEvent().toBoolean());
            s.getAutoStop().setTimeout(rospec.getROBoundarySpec().getROSpecStopTrigger().getGPITriggerValue().getTimeout().intValue());
        }
        SpecParameter specialParameter = (SpecParameter)rospec.getSpecParameterList().get(0);
        if (specialParameter instanceof AISpec) {
            s.getSpatialConfig().setMode(SpatialMode.Inventory);
            AISpec aispec = (AISpec)specialParameter;
            s.setAntennas(new AntennaConfigGroup());
            short[] sArray = aispec.getAntennaIDs().toShortArray();
            int n = sArray.length;
            for (int j = 0; j < n; ++j) {
                Short antennaID = sArray[j];
                s.getAntennas().getAntennaConfigs().add(new AntennaConfig(antennaID));
            }
            C1G2InventoryCommand c1g2Inv = (C1G2InventoryCommand)((AntennaConfiguration)((InventoryParameterSpec)aispec.getInventoryParameterSpecList().get(0)).getAntennaConfigurationList().get(0)).getAirProtocolInventoryCommandSettingsList().get(0);
            s.loadFilterData(c1g2Inv.getC1G2FilterList());
            int modeIndex = c1g2Inv.getC1G2RFControl().getModeIndex().intValue();
            if (ReaderMode.contains(modeIndex).booleanValue()) {
                s.setReaderMode(ReaderMode.valueOf(modeIndex));
            }
            s.setRfMode(modeIndex);
            s.setTagPopulationEstimate(c1g2Inv.getC1G2SingulationControl().getTagPopulation().intValue());
            s.setSession(c1g2Inv.getC1G2SingulationControl().getSession().intValue());
            for (Custom custom : c1g2Inv.getCustomList()) {
                if (custom instanceof ImpinjLowDutyCycle) {
                    ImpinjLowDutyCycle ldc = (ImpinjLowDutyCycle)custom;
                    s.getLowDutyCycle().setIsEnabled(true);
                    s.getLowDutyCycle().setEmptyFieldTimeoutInMs(ldc.getEmptyFieldTimeout().intValue());
                    s.getLowDutyCycle().setEmptyFieldTimeoutInMs(ldc.getEmptyFieldTimeout().intValue());
                    continue;
                }
                if (custom instanceof ImpinjInventorySearchMode) {
                    ImpinjInventorySearchMode ism = (ImpinjInventorySearchMode)custom;
                    s.setSearchMode(SearchMode.valueOf(ism.getInventorySearchMode().intValue()));
                    continue;
                }
                if (custom instanceof ImpinjTruncatedReplyConfiguration) {
                    ImpinjTruncatedReplyConfiguration trc = (ImpinjTruncatedReplyConfiguration)custom;
                    s.getTruncatedReply().setIsEnabled(true);
                    s.getTruncatedReply().setTagMask(trc.getTagMask().toString());
                    s.getTruncatedReply().setBitPointer((short)trc.getPointer().intValue());
                    s.getTruncatedReply().setEpcLengthInWords((byte)trc.getEPCLength().intValue());
                    s.getTruncatedReply().setGen2v2TagsOnly(trc.getGen2v2TagsOnly().toBoolean());
                    continue;
                }
                if (!(custom instanceof ImpinjTagFilterVerificationConfiguration)) continue;
                ImpinjTagFilterVerificationConfiguration tfvc = (ImpinjTagFilterVerificationConfiguration)custom;
                if (tfvc.getTagFilterVerificationMode().intValue() == 1) {
                    s.getFilters().setTagFilterVerificationMode(true);
                    continue;
                }
                s.getFilters().setTagFilterVerificationMode(false);
            }
            s.getAntennas().disableAll();
            List l = ((InventoryParameterSpec)aispec.getInventoryParameterSpecList().get(0)).getAntennaConfigurationList();
            AntennaConfiguration[] antConfigs = l.toArray(new AntennaConfiguration[l.size()]);
            l.toArray(antConfigs);
            for (i = 0; i < antConfigs.length; ++i) {
                AntennaConfig ac = s.getAntennas().getAntenna(antConfigs[i].getAntennaID().toShort());
                ac.setEnabled(true);
                int receiveSensitivityIndex = antConfigs[i].getRFReceiver().getReceiverSensitivity().intValue();
                boolean maxReceiveSensitivityIndex = true;
                boolean isMaxRxSensitivity = receiveSensitivityIndex == 1;
                ac.setIsMaxRxSensitivity(isMaxRxSensitivity);
                double receiveSensitivityDbm = this.readerCapabilities.getRxSensitivities().get((int)(receiveSensitivityIndex - 1)).Dbm;
                ac.setRxSensitivityinDbm(receiveSensitivityDbm);
                int transmitPowerIndex = antConfigs[i].getRFTransmitter().getTransmitPower().intValue();
                int maxTxPowerIndex = this.readerCapabilities.getTxPowers().size() - 1;
                boolean isMaxPower = transmitPowerIndex == maxTxPowerIndex;
                ac.setIsMaxTxPower(isMaxPower);
                double transmitPowerDbm = this.readerCapabilities.getTxPowers().get((int)(transmitPowerIndex - 1)).Dbm;
                ac.setTxPowerinDbm(transmitPowerDbm);
            }
        } else if (specialParameter instanceof ImpinjLISpec) {
            ImpinjLISpec lispec = (ImpinjLISpec)specialParameter;
            this.parseLISpec(s, lispec);
        } else if (specialParameter instanceof ImpinjDISpec) {
            ImpinjDISpec dispec = (ImpinjDISpec)specialParameter;
            this.parseDISpec(s, dispec);
        }
        ROReportSpec reportSpec = rospec.getROReportSpec();
        if (reportSpec.getN().intValue() == 1 && reportSpec.getROReportTrigger().intValue() == 2) {
            s.getReport().setMode(ReportMode.Individual);
        } else if (reportSpec.getN().intValue() == 0 && reportSpec.getROReportTrigger().intValue() == 2) {
            s.getReport().setMode(ReportMode.BatchAfterStop);
        } else if (reportSpec.getROReportTrigger().intValue() == 0) {
            s.getReport().setMode(ReportMode.WaitForQuery);
        }
        s.getReport().setIncludeAntennaPortNumber(reportSpec.getTagReportContentSelector().getEnableAntennaID().toBoolean());
        s.getReport().setIncludeChannel(reportSpec.getTagReportContentSelector().getEnableChannelIndex().toBoolean());
        s.getReport().setIncludeFirstSeenTime(reportSpec.getTagReportContentSelector().getEnableFirstSeenTimestamp().toBoolean());
        s.getReport().setIncludeLastSeenTime(reportSpec.getTagReportContentSelector().getEnableLastSeenTimestamp().toBoolean());
        s.getReport().setIncludeSeenCount(reportSpec.getTagReportContentSelector().getEnableTagSeenCount().toBoolean());
        if (reportSpec.getTagReportContentSelector().getAirProtocolEPCMemorySelectorList().size() > 0) {
            C1G2EPCMemorySelector mem = (C1G2EPCMemorySelector)reportSpec.getTagReportContentSelector().getAirProtocolEPCMemorySelectorList().get(0);
            s.getReport().setIncludeCrc(mem.getEnableCRC().toBoolean());
            s.getReport().setIncludePcBits(mem.getEnablePCBits().toBoolean());
        }
        if (reportSpec.getCustomList().size() > 0) {
            ImpinjTagReportContentSelector imp = (ImpinjTagReportContentSelector)reportSpec.getCustomList().get(0);
            if (imp.getImpinjEnableSerializedTID() != null && imp.getImpinjEnableSerializedTID().getSerializedTIDMode().intValue() == 1) {
                s.getReport().setIncludeFastId(true);
            } else {
                s.getReport().setIncludeFastId(false);
            }
            if (imp.getImpinjEnableRFDopplerFrequency() != null && imp.getImpinjEnableRFDopplerFrequency().getRFDopplerFrequencyMode().intValue() == 1) {
                s.getReport().setIncludeDopplerFrequency(true);
            } else {
                s.getReport().setIncludeDopplerFrequency(false);
            }
            if (imp.getImpinjEnableRFPhaseAngle() != null && imp.getImpinjEnableRFPhaseAngle().getRFPhaseAngleMode().intValue() == 1) {
                s.getReport().setIncludePhaseAngle(true);
            } else {
                s.getReport().setIncludePhaseAngle(false);
            }
            if (imp.getImpinjEnablePeakRSSI() != null && imp.getImpinjEnablePeakRSSI().getPeakRSSIMode().intValue() == 1) {
                s.getReport().setIncludePeakRssi(true);
            } else {
                s.getReport().setIncludePeakRssi(true);
            }
            if (imp.getImpinjEnableGPSCoordinates() != null && imp.getImpinjEnableGPSCoordinates().getGPSCoordinatesMode().intValue() == 1) {
                s.getReport().setIncludeGpsCoordinates(true);
            } else {
                s.getReport().setIncludeGpsCoordinates(false);
            }
            if (imp.getImpinjEnableOptimizedRead() != null && imp.getImpinjEnableOptimizedRead().getOptimizedReadMode().intValue() == 1) {
                s.getReport().getOptimizedReadOps().clear();
                for (i = 0; i < imp.getImpinjEnableOptimizedRead().getC1G2ReadList().size(); ++i) {
                    TagReadOp op = new TagReadOp();
                    op.setAccessPassword(TagData.fromDoubleWord(((C1G2Read)imp.getImpinjEnableOptimizedRead().getC1G2ReadList().get(i)).getAccessPassword().intValue()));
                    op.Id = ((C1G2Read)imp.getImpinjEnableOptimizedRead().getC1G2ReadList().get(i)).getOpSpecID().toShort();
                    op.setMemoryBank(MemoryBank.valueOf(((C1G2Read)imp.getImpinjEnableOptimizedRead().getC1G2ReadList().get(i)).getMB().intValue()));
                    op.setWordCount(((C1G2Read)imp.getImpinjEnableOptimizedRead().getC1G2ReadList().get(i)).getWordCount().toShort());
                    op.setWordPointer(((C1G2Read)imp.getImpinjEnableOptimizedRead().getC1G2ReadList().get(i)).getWordPointer().toShort());
                    s.getReport().getOptimizedReadOps().add(op);
                }
            }
        }
        if (config != null) {
            KeepaliveSpec keepaliveSpec;
            Bit holdReportsOnDisconnectFlag;
            EventsAndReports eventsAndReports = config.getEventsAndReports();
            Bit bit = holdReportsOnDisconnectFlag = eventsAndReports == null ? null : eventsAndReports.getHoldEventsAndReportsUponReconnect();
            if (holdReportsOnDisconnectFlag != null) {
                s.setHoldReportsOnDisconnect(holdReportsOnDisconnectFlag.toBoolean());
            }
            if ((keepaliveSpec = config.getKeepaliveSpec()) != null) {
                Object keepaliveConfig;
                KeepaliveTriggerType keepaliveTriggerType = keepaliveSpec.getKeepaliveTriggerType();
                if (keepaliveTriggerType != null) {
                    s.getKeepalives().setEnabled(keepaliveTriggerType.intValue() == 1);
                }
                if ((keepaliveConfig = s.getKeepalives()) != null) {
                    ((KeepaliveConfig)keepaliveConfig).setPeriodInMs(keepaliveSpec.getPeriodicTriggerValue().intValue());
                }
            }
            if (config.getGPIPortCurrentStateList() != null) {
                int numGPIOPorts = config.getGPIPortCurrentStateList().size();
                s.setGpis(new GpiConfigGroup(numGPIOPorts));
                s.setGpos(new GpoConfigGroup(numGPIOPorts));
                for (GPIPortCurrentState GPIPortState : config.getGPIPortCurrentStateList()) {
                    short GPIPortNumber = GPIPortState.getGPIPortNum().toShort();
                    boolean isEnabled = GPIPortState.getConfig().toBoolean();
                    s.getGpis().get(GPIPortNumber - 1).setPortNumber(GPIPortNumber);
                    s.getGpis().get(GPIPortNumber - 1).setIsEnabled(isEnabled);
                }
            }
            for (Custom custom : config.getCustomList()) {
                if (custom instanceof ImpinjAdvancedGPOConfiguration) {
                    ImpinjAdvancedGPOConfiguration gpoConfig = (ImpinjAdvancedGPOConfiguration)custom;
                    short GPOPortNumber = gpoConfig.getGPOPortNum().toShort();
                    GpoMode mode = GpoMode.valueOf(gpoConfig.getGPOMode().intValue());
                    long GPOPulseDurationMSec = gpoConfig.getGPOPulseDurationMSec().toLong();
                    s.getGpos().get(GPOPortNumber - 1).setPortNumber(GPOPortNumber);
                    s.getGpos().get(GPOPortNumber - 1).setMode(mode);
                    s.getGpos().get(GPOPortNumber - 1).setGpoPulseDurationMsec(GPOPulseDurationMSec);
                    continue;
                }
                if (custom instanceof ImpinjGPIDebounceConfiguration) {
                    ImpinjGPIDebounceConfiguration dbConfig = (ImpinjGPIDebounceConfiguration)custom;
                    s.getGpis().getGpi(dbConfig.getGPIPortNum().toShort()).setDebounceInMs(dbConfig.getGPIDebounceTimerMSec().toLong());
                    continue;
                }
                if (custom instanceof ImpinjLinkMonitorConfiguration) {
                    ImpinjLinkMonitorConfiguration linkConfig = (ImpinjLinkMonitorConfiguration)custom;
                    if (linkConfig.getLinkMonitorMode().intValue() == 1) {
                        s.getKeepalives().setEnableLinkMonitorMode(true);
                    } else {
                        s.getKeepalives().setEnableLinkMonitorMode(false);
                    }
                    s.getKeepalives().setLinkDownThreshold(linkConfig.getLinkDownThreshold().intValue());
                    continue;
                }
                if (custom instanceof ImpinjPlacementConfiguration) {
                    ImpinjPlacementConfiguration ltkPlacementConfig = (ImpinjPlacementConfiguration)custom;
                    PlacementConfig placement = s.getSpatialConfig().getPlacement();
                    placement.setHeightCm(ltkPlacementConfig.getHeightCm().toShort());
                    placement.setFacilityXLocationCm(ltkPlacementConfig.getFacilityXLocationCm().toInteger());
                    placement.setFacilityYLocationCm(ltkPlacementConfig.getFacilityYLocationCm().toInteger());
                    placement.setOrientationDegrees(ltkPlacementConfig.getOrientationDegrees().toShort());
                    continue;
                }
                if (custom instanceof ImpinjLocationReporting) {
                    ImpinjLocationReporting locReporting = (ImpinjLocationReporting)custom;
                    LocationConfig location = s.getSpatialConfig().getLocation();
                    location.setUpdateReportEnabled(locReporting.getEnableUpdateReport().toBoolean());
                    location.setEntryReportEnabled(locReporting.getEnableEntryReport().toBoolean());
                    location.setExitReportEnabled(locReporting.getEnableExitReport().toBoolean());
                    location.setDiagnosticReportEnabled(locReporting.getEnableDiagnosticReport().toBoolean());
                    continue;
                }
                if (!(custom instanceof ImpinjDirectionReporting)) continue;
                ImpinjDirectionReporting dirReporting = (ImpinjDirectionReporting)custom;
                DirectionConfig direction = s.getSpatialConfig().getDirection();
                direction.setUpdateReportEnabled(dirReporting.getEnableUpdateReport().toBoolean());
                direction.setEntryReportEnabled(dirReporting.getEnableEntryReport().toBoolean());
                direction.setExitReportEnabled(dirReporting.getEnableExitReport().toBoolean());
                direction.setDiagnosticReportEnabled(dirReporting.getEnableDiagnosticReport().toBoolean());
            }
        }
        return s;
    }

    private void parseLISpec(Settings settings, ImpinjLISpec lispec) throws OctaneSdkException {
        settings.getSpatialConfig().setMode(SpatialMode.Location);
        LocationConfig locationConfig = settings.getSpatialConfig().getLocation();
        ImpinjDisabledAntennas impinjDisabledAntennas = lispec.getImpinjLocationConfig().getImpinjDisabledAntennas();
        if (impinjDisabledAntennas != null) {
            short[] disabledAntennaArray = impinjDisabledAntennas.getAntennaIDs().toShortArray();
            locationConfig.setDisabledAntennaList(disabledAntennaArray);
        }
        if (lispec.getImpinjLocationConfig() != null) {
            locationConfig.setComputeWindowSeconds(lispec.getImpinjLocationConfig().getComputeWindowSeconds().toShort());
            locationConfig.setTagAgeIntervalSeconds(lispec.getImpinjLocationConfig().getTagAgeIntervalSeconds().toShort());
            locationConfig.setUpdateIntervalSeconds(lispec.getImpinjLocationConfig().getUpdateIntervalSeconds().toShort());
            locationConfig.getLocationAlgorithmControlList().clear();
            ImpinjLocationAlgorithmControl ilac = lispec.getImpinjLocationConfig().getImpinjLocationAlgorithmControl();
            if (ilac != null) {
                UnsignedIntegerArray controlArray = ilac.getControlData();
                for (int x = 0; x < controlArray.size(); ++x) {
                    locationConfig.getLocationAlgorithmControlList().add(controlArray.get(x).intValue());
                }
            }
        }
        if (lispec.getImpinjC1G2LocationConfig() != null) {
            int modeIndex = lispec.getImpinjC1G2LocationConfig().getModeIndex().intValue();
            if (ReaderMode.contains(modeIndex).booleanValue()) {
                settings.setReaderMode(ReaderMode.valueOf(modeIndex));
            }
            settings.setRfMode(modeIndex);
            settings.setSession(lispec.getImpinjC1G2LocationConfig().getSession().intValue());
            settings.loadFilterData(lispec.getImpinjC1G2LocationConfig().getC1G2FilterList());
            if (lispec.getImpinjC1G2LocationConfig().getImpinjTransmitPower() != null) {
                int maxTxPowerIndex;
                int transmitPowerIndex = lispec.getImpinjC1G2LocationConfig().getImpinjTransmitPower().getTransmitPower().toInteger();
                boolean isMaxPower = transmitPowerIndex == (maxTxPowerIndex = this.readerCapabilities.getTxPowers().size() - 1);
                locationConfig.setIsMaxTxPower(isMaxPower);
                double transmitPowerDbm = this.readerCapabilities.getTxPowers().get((int)(transmitPowerIndex - 1)).Dbm;
                locationConfig.setTxPowerinDbm(transmitPowerDbm);
            }
        }
    }

    private void parseDISpec(Settings settings, ImpinjDISpec dispec) throws OctaneSdkException {
        settings.getSpatialConfig().setMode(SpatialMode.Direction);
        DirectionConfig directionConfig = settings.getSpatialConfig().getDirection();
        if (dispec.getImpinjDirectionConfig() != null) {
            ImpinjDirectionFieldOfView fov = dispec.getImpinjDirectionConfig().getFieldOfView();
            switch (fov.intValue()) {
                case 0: {
                    directionConfig.setFieldOfView(DirectionFieldOfView.READER_SELECTED);
                    break;
                }
                case 2: {
                    directionConfig.setFieldOfView(DirectionFieldOfView.NARROW);
                    break;
                }
                case 1: {
                    directionConfig.setFieldOfView(DirectionFieldOfView.WIDE);
                    break;
                }
                default: {
                    directionConfig.setFieldOfView(DirectionConfig.DEFAULT_FIELD_OF_VIEW);
                }
            }
            directionConfig.setUserTagPopulationLimit(dispec.getImpinjDirectionConfig().getImpinjDirectionUserTagPopulationLimit().getUserTagPopulationLimit().toShort());
            directionConfig.setTagAgeIntervalSeconds(dispec.getImpinjDirectionConfig().getTagAgeIntervalSeconds().toShort());
            directionConfig.setUpdateIntervalSeconds(dispec.getImpinjDirectionConfig().getUpdateIntervalSeconds().toShort());
        }
        directionConfig.removeAllSectors();
        if (dispec.getImpinjDirectionSectors() != null) {
            UnsignedShortArray sectorIDs = dispec.getImpinjDirectionSectors().getEnabledSectorIDs();
            for (int x = 0; x < sectorIDs.size(); ++x) {
                directionConfig.enableSector(sectorIDs.get(x).toShort());
            }
        }
        if (dispec.getImpinjC1G2DirectionConfig() != null) {
            settings.loadFilterData(dispec.getImpinjC1G2DirectionConfig().getC1G2FilterList());
            ImpinjDirectionRFMode mode = dispec.getImpinjC1G2DirectionConfig().getRFMode();
            switch (mode.intValue()) {
                case 1: {
                    directionConfig.setMode(DirectionMode.HighPerformance);
                    break;
                }
                case 0: {
                    directionConfig.setMode(DirectionMode.HighSensitivity);
                    break;
                }
            }
            if (dispec.getImpinjC1G2DirectionConfig().getImpinjTransmitPower() != null) {
                int maxTxPowerIndex;
                int transmitPowerIndex = dispec.getImpinjC1G2DirectionConfig().getImpinjTransmitPower().getTransmitPower().toInteger();
                boolean isMaxPower = transmitPowerIndex == (maxTxPowerIndex = this.readerCapabilities.getTxPowers().size() - 1);
                directionConfig.setIsMaxTxPower(isMaxPower);
                double transmitPowerDbm = this.readerCapabilities.getTxPowers().get((int)(transmitPowerIndex - 1)).Dbm;
                directionConfig.setTxPowerinDbm(transmitPowerDbm);
            }
        }
    }

    public Settings queryDefaultSettings() {
        Settings config = new Settings(this.readerCapabilities.getAntennaCount(), this.readerCapabilities.getGpiCount(), this.readerCapabilities.getGpoCount(), this.readerCapabilities.getFirmwareVersion());
        return config;
    }

    GET_READER_CONFIG_RESPONSE getReaderConfig() throws OctaneSdkException {
        return this.getReaderConfig(new GetReaderConfigRequestedData(0), new ImpinjRequestedDataType(2000));
    }

    void setReaderConfig(SET_READER_CONFIG msg) throws OctaneSdkException {
        LLRPMessage rsp = null;
        String msgType = "SET_READER_CONFIG";
        try {
            rsp = this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        ERROR_MESSAGE msgErr = null;
        this.checkForNullReply(msgType, rsp, msgErr);
        StatusCode status = ((SET_READER_CONFIG_RESPONSE)rsp).getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            throw new OctaneSdkException("SET_READER_CONFIG failures");
        }
    }

    void setReaderConfig(Settings config) throws OctaneSdkException {
        this.setReaderConfig(this.buildSetReaderConfigMessage(config));
    }

    public SET_READER_CONFIG buildSetReaderConfigMessage(Settings config) throws OctaneSdkException {
        SET_READER_CONFIG msg = new SET_READER_CONFIG();
        msg.setMessageID(this.getUniqueMessageID());
        msg.setResetToFactoryDefault(new Bit(false));
        ROReportSpec roReportSpec = new ROReportSpec();
        TagReportContentSelector tagReportContentSelector = new TagReportContentSelector();
        tagReportContentSelector.setEnableAccessSpecID(new Bit(true));
        tagReportContentSelector.setEnableAntennaID(new Bit(false));
        tagReportContentSelector.setEnableChannelIndex(new Bit(false));
        tagReportContentSelector.setEnableFirstSeenTimestamp(new Bit(false));
        tagReportContentSelector.setEnableInventoryParameterSpecID(new Bit(false));
        tagReportContentSelector.setEnableLastSeenTimestamp(new Bit(false));
        tagReportContentSelector.setEnablePeakRSSI(new Bit(false));
        tagReportContentSelector.setEnableROSpecID(new Bit(false));
        tagReportContentSelector.setEnableSpecIndex(new Bit(false));
        tagReportContentSelector.setEnableTagSeenCount(new Bit(false));
        roReportSpec.setTagReportContentSelector(tagReportContentSelector);
        roReportSpec.setROReportTrigger(new ROReportTriggerType(2));
        roReportSpec.setN(new UnsignedShort(1));
        this.setReaderConfigAntennaConfiguration(msg, config);
        msg.setROReportSpec(roReportSpec);
        if (config.getKeepalives().getEnabled().booleanValue()) {
            KeepaliveSpec kaSpec = new KeepaliveSpec();
            kaSpec.setKeepaliveTriggerType(new KeepaliveTriggerType(1));
            kaSpec.setPeriodicTriggerValue(new UnsignedInteger(config.getKeepalives().getPeriodInMs()));
            msg.setKeepaliveSpec(kaSpec);
            this.keepaliveTimer.setInterval((long)((double)config.getKeepalives().getPeriodInMs() * 1.5));
            this.keepaliveTimer.start();
            if (config.getKeepalives().getEnableLinkMonitorMode().booleanValue()) {
                ImpinjLinkMonitorConfiguration linkMonitor = new ImpinjLinkMonitorConfiguration();
                linkMonitor.setLinkMonitorMode(new ImpinjLinkMonitorMode(1));
                linkMonitor.setLinkDownThreshold(new UnsignedShort(config.getKeepalives().getLinkDownThreshold()));
                msg.addToCustomList((Custom)linkMonitor);
            }
        } else {
            this.keepaliveTimer.stop();
        }
        msg.setGPIPortCurrentStateList(new ArrayList());
        ReaderEventNotificationSpec readerEventNotificationSpec = new ReaderEventNotificationSpec();
        EventNotificationState e1 = new EventNotificationState();
        e1.setEventType(new NotificationEventType(1));
        e1.setNotificationState(new Bit(true));
        readerEventNotificationSpec.addToEventNotificationStateList(e1);
        EventNotificationState e2 = new EventNotificationState();
        e2.setEventType(new NotificationEventType(8));
        e2.setNotificationState(new Bit(true));
        readerEventNotificationSpec.addToEventNotificationStateList(e2);
        EventNotificationState e3 = new EventNotificationState();
        e3.setEventType(new NotificationEventType(3));
        e3.setNotificationState(new Bit(true));
        readerEventNotificationSpec.addToEventNotificationStateList(e3);
        EventNotificationState e4 = new EventNotificationState();
        e4.setEventType(new NotificationEventType(2));
        e4.setNotificationState(new Bit(true));
        readerEventNotificationSpec.addToEventNotificationStateList(e4);
        EventNotificationState e5 = new EventNotificationState();
        e5.setEventType(new NotificationEventType(4));
        e5.setNotificationState(new Bit(true));
        readerEventNotificationSpec.addToEventNotificationStateList(e5);
        msg.setReaderEventNotificationSpec(readerEventNotificationSpec);
        for (Object gpo : config.getGpos()) {
            ImpinjAdvancedGPOConfiguration advancedGpo = new ImpinjAdvancedGPOConfiguration();
            advancedGpo.setGPOPortNum(new UnsignedShort(((GpoConfig)gpo).getPortNumber()));
            advancedGpo.setGPOMode(new ImpinjAdvancedGPOMode(((GpoConfig)gpo).getMode().getValue()));
            advancedGpo.setGPOPulseDurationMSec(new UnsignedInteger(((GpoConfig)gpo).getGpoPulseDurationMsec()));
            if (advancedGpo.getGPOMode().intValue() == 0) continue;
            msg.addToCustomList((Custom)advancedGpo);
        }
        int index = 0;
        for (GpiConfig gpi : config.getGpis()) {
            GPIPortCurrentState gpiPortCurrentStateParam = new GPIPortCurrentState();
            gpiPortCurrentStateParam.setGPIPortNum(new UnsignedShort(gpi.getPortNumber()));
            if (gpi.getIsEnabled().booleanValue()) {
                gpiPortCurrentStateParam.setConfig(new Bit(true));
                gpiPortCurrentStateParam.setState(new GPIPortState(0));
                if (gpi.getDebounceInMs() >= 0L) {
                    ImpinjGPIDebounceConfiguration debounce = new ImpinjGPIDebounceConfiguration();
                    debounce.setGPIDebounceTimerMSec(new UnsignedInteger(gpi.getDebounceInMs()));
                    debounce.setGPIPortNum(new UnsignedShort(index + 1));
                    msg.addToCustomList((Custom)debounce);
                }
            } else {
                gpiPortCurrentStateParam.setConfig(new Bit(false));
                GPIPortState portStateForDisabledGPI = new GPIPortState();
                portStateForDisabledGPI.set(2);
                gpiPortCurrentStateParam.setState(portStateForDisabledGPI);
            }
            msg.addToGPIPortCurrentStateList(gpiPortCurrentStateParam);
            ++index;
        }
        EventsAndReports eventsAndReports = new EventsAndReports();
        if (config.getHoldReportsOnDisconnect().booleanValue()) {
            eventsAndReports.setHoldEventsAndReportsUponReconnect(new Bit(true));
        } else {
            eventsAndReports.setHoldEventsAndReportsUponReconnect(new Bit(false));
        }
        msg.setEventsAndReports(eventsAndReports);
        if (this.isSpatialReader()) {
            ImpinjPlacementConfiguration placement = new ImpinjPlacementConfiguration();
            placement.setFacilityXLocationCm(new SignedInteger(config.getSpatialConfig().getPlacement().getFacilityXLocationCm()));
            placement.setFacilityYLocationCm(new SignedInteger(config.getSpatialConfig().getPlacement().getFacilityYLocationCm()));
            placement.setOrientationDegrees(new SignedShort((int)config.getSpatialConfig().getPlacement().getOrientationDegrees()));
            placement.setHeightCm(new UnsignedShort((int)config.getSpatialConfig().getPlacement().getHeightCm()));
            msg.addToCustomList((Custom)placement);
            if (config.getSpatialConfig().getMode() == SpatialMode.Location) {
                ImpinjLocationReporting locReport = new ImpinjLocationReporting();
                locReport.setEnableEntryReport(new Bit(config.getSpatialConfig().getLocation().isEntryReportEnabled()));
                locReport.setEnableExitReport(new Bit(config.getSpatialConfig().getLocation().isExitReportEnabled()));
                locReport.setEnableUpdateReport(new Bit(config.getSpatialConfig().getLocation().isUpdateReportEnabled()));
                locReport.setEnableDiagnosticReport(new Bit(config.getSpatialConfig().getLocation().isDiagnosticReportEnabled()));
                msg.addToCustomList((Custom)locReport);
            } else if (config.getSpatialConfig().getMode() == SpatialMode.Direction) {
                ImpinjDirectionReporting directionReport = new ImpinjDirectionReporting();
                directionReport.setEnableEntryReport(new Bit(config.getSpatialConfig().getDirection().isEntryReportEnabled()));
                directionReport.setEnableExitReport(new Bit(config.getSpatialConfig().getDirection().isExitReportEnabled()));
                directionReport.setEnableUpdateReport(new Bit(config.getSpatialConfig().getDirection().isUpdateReportEnabled()));
                directionReport.setEnableDiagnosticReport(new Bit(config.getSpatialConfig().getDirection().isDiagnosticReportEnabled()));
                directionReport.setDiagnosticReportLevel(new ImpinjDirectionDiagnosticReportLevel(0));
                msg.addToCustomList((Custom)directionReport);
            }
        }
        return msg;
    }

    private void setReaderConfigAntennaConfiguration(SET_READER_CONFIG readerConfig, Settings settings) throws OctaneSdkException {
        ImpinjFixedFrequencyList fixedFreqencyList = this.getFixedFrequencyList(settings);
        if (fixedFreqencyList.getChannelList().size() > 0) {
            C1G2InventoryCommand c1G2InventoryCommand = new C1G2InventoryCommand();
            c1G2InventoryCommand.getCustomList().add(fixedFreqencyList);
            c1G2InventoryCommand.setTagInventoryStateAware(new Bit(false));
            AntennaConfiguration antConfig = new AntennaConfiguration();
            antConfig.setAntennaID(UNIVERSAL_ANTENNA_ID);
            antConfig.getAirProtocolInventoryCommandSettingsList().add(c1G2InventoryCommand);
            ArrayList<AntennaConfiguration> antennaConfigList = new ArrayList<AntennaConfiguration>();
            antennaConfigList.add(antConfig);
            readerConfig.setAntennaConfigurationList(antennaConfigList);
        }
        if (this.isXArray()) {
            ImpinjPolarizationControl polarizationControl = new ImpinjPolarizationControl();
            polarizationControl.setPolarizationControlEnabled(new Bit(settings.getAntennas().getPolarizationEnabled()));
            readerConfig.addToCustomList((Custom)polarizationControl);
        }
    }

    GET_READER_CONFIG_RESPONSE getReaderConfig(GetReaderConfigRequestedData requestedData, ImpinjRequestedDataType impinjRequestedData) throws OctaneSdkException {
        GET_READER_CONFIG msg = new GET_READER_CONFIG();
        msg.setMessageID(this.getUniqueMessageID());
        ERROR_MESSAGE msgErr = null;
        GET_READER_CONFIG_RESPONSE rsp = null;
        msg.setRequestedData(requestedData);
        msg.setAntennaID(new UnsignedShort(0));
        msg.setGPIPortNum(new UnsignedShort(0));
        msg.setGPOPortNum(new UnsignedShort(0));
        String msgType = "GET_READER_CONFIG";
        ImpinjRequestedData ird = new ImpinjRequestedData();
        ird.setRequestedData(impinjRequestedData);
        msg.addToCustomList((Custom)ird);
        try {
            rsp = (GET_READER_CONFIG_RESPONSE)this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        this.checkLlrpReply(rsp.getLLRPStatus(), msgErr, msgType);
        return rsp;
    }

    public Settings querySettings() throws OctaneSdkException {
        List roSpecList = this.getRoSpecs().getROSpecList();
        GET_READER_CONFIG_RESPONSE config = this.getReaderConfig();
        this.validateReaderSettings(roSpecList, config);
        return this.parseRoSpecAndConfig((ROSpec)roSpecList.get(0), config);
    }

    void validateReaderSettings(List<ROSpec> roSpecList, GET_READER_CONFIG_RESPONSE config) throws OctaneSdkException {
        if (roSpecList.isEmpty() || roSpecList.get(0) == null || config == null) {
            throw new OctaneSdkException("The reader has not been configured.");
        }
        if (roSpecList.get(0).getROSpecID().toInteger() != 14150) {
            throw new OctaneSdkException("The reader configuration is invalid.");
        }
    }

    public void setGpo(int port, boolean portState) throws OctaneSdkException {
        SET_READER_CONFIG_RESPONSE rsp;
        SET_READER_CONFIG src = new SET_READER_CONFIG();
        ERROR_MESSAGE msgErr = null;
        src.setMessageID(this.getUniqueMessageID());
        String msgType = "SET_READER_CONFIG";
        Bit set = new Bit(portState);
        GPOWriteData gp = new GPOWriteData();
        gp.setGPOData(set);
        gp.setGPOPortNumber(new UnsignedShort(port));
        ArrayList<GPOWriteData> gpolist = new ArrayList<GPOWriteData>();
        gpolist.add(gp);
        src.setResetToFactoryDefault(new Bit(0));
        src.setGPOWriteDataList(gpolist);
        try {
            rsp = (SET_READER_CONFIG_RESPONSE)this.readerConnection.transact((LLRPMessage)src, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        StatusCode status = rsp.getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            throw new OctaneSdkException(msgType + " failures");
        }
    }

    public Status queryStatus() throws OctaneSdkException {
        ROSpec rospec;
        ImpinjReaderTemperature t;
        Status s = new Status();
        GET_READER_CONFIG_RESPONSE config = this.getReaderConfig();
        AntennaStatusGroup asg = new AntennaStatusGroup();
        for (Object ap : config.getAntennaPropertiesList()) {
            AntennaStatus as = new AntennaStatus();
            as.setConnected(ap.getAntennaConnected().toBoolean());
            as.setPortNumber(ap.getAntennaID().toShort());
            asg.Add(as);
        }
        s.setAntennaStatusGroup(asg);
        if (config.getGPIPortCurrentStateList() != null) {
            Iterator gsg = new GpiStatusGroup();
            for (GPIPortCurrentState gpst : config.getGPIPortCurrentStateList()) {
                GpiStatus g = new GpiStatus();
                g.setPortNumber(gpst.getGPIPortNum().toShort());
                if (gpst.getState().toInteger() == 1) {
                    g.setState(true);
                } else {
                    g.setState(false);
                }
                ((GpiStatusGroup)((Object)gsg)).add(g);
            }
            s.setGpiStatusGroup((GpiStatusGroup)((Object)gsg));
        }
        s.setIsConnected(this.isConnected());
        for (Object c : config.getCustomList()) {
            if (!(c instanceof ImpinjReaderTemperature)) continue;
            t = (ImpinjReaderTemperature)c;
            s.setTemperatureCelsius(t.getTemperature().toShort());
        }
        for (Object c : config.getCustomList()) {
            if (!(c instanceof ImpinjTiltConfiguration)) continue;
            t = (ImpinjTiltConfiguration)c;
            TiltSensorValue tv = new TiltSensorValue();
            tv.setxAxis(t.getXAxis().toInteger());
            tv.setyAxis(t.getYAxis().toInteger());
            s.setTiltSensorValue(tv);
        }
        AntennaHubStatusGroup ahsg = new AntennaHubStatusGroup();
        for (Custom c : config.getCustomList()) {
            if (!(c instanceof ImpinjHubConfiguration)) continue;
            ImpinjHubConfiguration t2 = (ImpinjHubConfiguration)c;
            AntennaHubStatus ahs = new AntennaHubStatus();
            ahs.setHubId(t2.getHubID().toShort());
            ahs.setFault(HubFaultStatus.valueOf(t2.getFault().toInteger()));
            ahsg.add(ahs);
        }
        s.setAntennaHubStatusGroup(ahsg);
        s.setIsSingulating(false);
        List rospecs = this.getRoSpecs().getROSpecList();
        if (rospecs.size() > 0 && (rospec = (ROSpec)rospecs.get(0)).getCurrentState().equals((Object)new ROSpecState(2))) {
            s.setIsSingulating(true);
        }
        return s;
    }

    void setCustomConfig(Custom c, String msgType) throws OctaneSdkException {
        SET_READER_CONFIG_RESPONSE rsp;
        SET_READER_CONFIG src = new SET_READER_CONFIG();
        ERROR_MESSAGE msgErr = null;
        src.setMessageID(this.getUniqueMessageID());
        src.addToCustomList(c);
        src.setResetToFactoryDefault(new Bit(0));
        try {
            rsp = (SET_READER_CONFIG_RESPONSE)this.readerConnection.transact((LLRPMessage)src, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        StatusCode status = rsp.getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            throw new OctaneSdkException(msgType + " failures");
        }
    }

    public void turnBeaconOn(long durationMsec) throws OctaneSdkException {
        ImpinjBeaconConfiguration ib = new ImpinjBeaconConfiguration();
        ib.setBeaconDurationSeconds(new UnsignedLong(Long.valueOf(durationMsec)));
        ib.setBeaconState(new Bit(true));
        this.setCustomConfig((Custom)ib, "Turn Beacon On");
    }

    public void turnBeaconOff() throws OctaneSdkException {
        ImpinjBeaconConfiguration ib = new ImpinjBeaconConfiguration();
        ib.setBeaconDurationSeconds(new UnsignedLong(Long.valueOf(0L)));
        ib.setBeaconState(new Bit(false));
        this.setCustomConfig((Custom)ib, "Turn Beacon Off");
    }

    C1G2Filter[] getC1G2Filters(FilterSettings filterSettings) throws OctaneSdkException {
        C1G2Filter[] filters = null;
        if (filterSettings.getMode() == TagFilterMode.UseTagSelectFilters) {
            List<TagSelectFilter> tagSelectFilterList = filterSettings.getTagSelectFilterList();
            int maxNumSelectFiltersPerQuery = this.readerCapabilities.getMaxNumSelectFiltersPerQuery();
            int tagSelectFilterListSize = tagSelectFilterList.size();
            if (tagSelectFilterListSize > maxNumSelectFiltersPerQuery) {
                throw new OctaneSdkException("Error parsing tag select filter list. " + String.format("The tag select filter list has %d filters, ", tagSelectFilterListSize) + String.format("which is more than the maximum supported by the reader which is %d", maxNumSelectFiltersPerQuery));
            }
            filters = new C1G2Filter[tagSelectFilterListSize];
            for (int i = 0; i < tagSelectFilterList.size(); ++i) {
                TagSelectFilter tagSelectFilter = tagSelectFilterList.get(i);
                filters[i] = new C1G2Filter();
                filters[i].setT(new C1G2TruncateAction(1));
                C1G2TagInventoryMask c1g2TagInventoryMaskFilter = new C1G2TagInventoryMask();
                c1g2TagInventoryMaskFilter.setMB(this.twoBitFieldFromInt(tagSelectFilter.getMemoryBank().getValue()));
                UnsignedShort bitPointerFilter = new UnsignedShort(tagSelectFilter.getBitPointer());
                c1g2TagInventoryMaskFilter.setPointer(bitPointerFilter);
                c1g2TagInventoryMaskFilter.setTagMask(new BitArray_HEX(tagSelectFilter.getTagMask()));
                filters[i].setC1G2TagInventoryMask(c1g2TagInventoryMaskFilter);
                if (tagSelectFilter.getBitCount() > 0L) {
                    filters[i].getC1G2TagInventoryMask().setTagMask(this.truncateTagMask(filters[i].getC1G2TagInventoryMask().getTagMask(), (int)tagSelectFilter.getBitCount()));
                }
                TagFilterStateUnawareAction matchingAction = tagSelectFilter.getMatchingAction();
                TagFilterStateUnawareAction nonMatchingAction = tagSelectFilter.getNonMatchingAction();
                C1G2TagInventoryStateUnawareFilterAction c1g2TagInventoryStateUnawareFilterAction = new C1G2TagInventoryStateUnawareFilterAction();
                C1G2StateUnawareAction c1g2StateUnawareAction = new C1G2StateUnawareAction();
                c1g2StateUnawareAction.set(TagFilterStateUnawareAction.convertToC1G2StateUnawareAction(tagSelectFilter.getMatchingAction(), tagSelectFilter.getNonMatchingAction()));
                c1g2TagInventoryStateUnawareFilterAction.setAction(c1g2StateUnawareAction);
                filters[i].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterAction);
            }
        } else if (filterSettings.getMode() == TagFilterMode.Filter1AndFilter2 || filterSettings.getMode() == TagFilterMode.Filter1OrFilter2) {
            C1G2StateUnawareAction c1g2tateUnawareAction;
            filters = new C1G2Filter[]{new C1G2Filter(), new C1G2Filter()};
            C1G2TagInventoryMask c1g2TagInventoryMaskFilter1 = new C1G2TagInventoryMask();
            c1g2TagInventoryMaskFilter1.setMB(this.twoBitFieldFromInt(filterSettings.getTagFilter1().getMemoryBank().getValue()));
            UnsignedShort bitPointerFilter1 = new UnsignedShort(filterSettings.getTagFilter1().getBitPointer());
            c1g2TagInventoryMaskFilter1.setPointer(bitPointerFilter1);
            c1g2TagInventoryMaskFilter1.setTagMask(new BitArray_HEX(filterSettings.getTagFilter1().getTagMask()));
            filters[0].setT(new C1G2TruncateAction(1));
            filters[0].setC1G2TagInventoryMask(c1g2TagInventoryMaskFilter1);
            C1G2TagInventoryMask c1g2TagInventoryMaskFilter2 = new C1G2TagInventoryMask();
            c1g2TagInventoryMaskFilter2.setMB(this.twoBitFieldFromInt(filterSettings.getTagFilter2().getMemoryBank().getValue()));
            UnsignedShort bitPointerFilter2 = new UnsignedShort(filterSettings.getTagFilter2().getBitPointer());
            c1g2TagInventoryMaskFilter2.setPointer(bitPointerFilter2);
            c1g2TagInventoryMaskFilter2.setTagMask(new BitArray_HEX(filterSettings.getTagFilter2().getTagMask()));
            filters[1].setT(new C1G2TruncateAction(1));
            filters[1].setC1G2TagInventoryMask(c1g2TagInventoryMaskFilter2);
            if (filterSettings.getTagFilter1().getBitCount() > 0L) {
                filters[0].getC1G2TagInventoryMask().setTagMask(this.truncateTagMask(filters[0].getC1G2TagInventoryMask().getTagMask(), (int)filterSettings.getTagFilter1().getBitCount()));
            }
            if (filterSettings.getTagFilter2().getBitCount() > 0L) {
                filters[1].getC1G2TagInventoryMask().setTagMask(this.truncateTagMask(filters[1].getC1G2TagInventoryMask().getTagMask(), (int)filterSettings.getTagFilter2().getBitCount()));
            }
            C1G2TagInventoryStateUnawareFilterAction c1g2TagInventoryStateUnawareFilterAction = new C1G2TagInventoryStateUnawareFilterAction();
            if (filterSettings.getTagFilter1().getFilterOp() == TagFilterOp.Match) {
                c1g2tateUnawareAction = new C1G2StateUnawareAction();
                c1g2tateUnawareAction.set(0);
                c1g2TagInventoryStateUnawareFilterAction.setAction(c1g2tateUnawareAction);
                filters[0].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterAction);
            } else {
                c1g2tateUnawareAction = new C1G2StateUnawareAction();
                c1g2tateUnawareAction.set(4);
                c1g2TagInventoryStateUnawareFilterAction.setAction(c1g2tateUnawareAction);
                filters[0].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterAction);
            }
            C1G2TagInventoryStateUnawareFilterAction c1g2TagInventoryStateUnawareFilterActionFilter2 = new C1G2TagInventoryStateUnawareFilterAction();
            if (filterSettings.getMode() == TagFilterMode.Filter1AndFilter2) {
                if (filterSettings.getTagFilter2().getFilterOp() == TagFilterOp.Match) {
                    C1G2StateUnawareAction c1g2tateUnawareAction2 = new C1G2StateUnawareAction();
                    c1g2tateUnawareAction2.set(2);
                    c1g2TagInventoryStateUnawareFilterActionFilter2.setAction(c1g2tateUnawareAction2);
                    filters[1].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterActionFilter2);
                } else {
                    C1G2StateUnawareAction c1g2tateUnawareAction3 = new C1G2StateUnawareAction();
                    c1g2tateUnawareAction3.set(3);
                    c1g2TagInventoryStateUnawareFilterActionFilter2.setAction(c1g2tateUnawareAction3);
                    filters[1].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterActionFilter2);
                }
            } else if (filterSettings.getMode() == TagFilterMode.Filter1OrFilter2) {
                if (filterSettings.getTagFilter2().getFilterOp() == TagFilterOp.Match) {
                    C1G2StateUnawareAction c1g2tateUnawareAction4 = new C1G2StateUnawareAction();
                    c1g2tateUnawareAction4.set(1);
                    c1g2TagInventoryStateUnawareFilterActionFilter2.setAction(c1g2tateUnawareAction4);
                    filters[1].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterActionFilter2);
                } else {
                    C1G2StateUnawareAction c1g2tateUnawareAction5 = new C1G2StateUnawareAction();
                    c1g2tateUnawareAction5.set(2);
                    c1g2TagInventoryStateUnawareFilterActionFilter2.setAction(c1g2tateUnawareAction5);
                    filters[1].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterActionFilter2);
                }
            }
        } else if (filterSettings.getMode() != TagFilterMode.None) {
            filters = new C1G2Filter[]{new C1G2Filter()};
            C1G2TagInventoryMask c1g2TagInventoryMask = new C1G2TagInventoryMask();
            C1G2TagInventoryStateUnawareFilterAction c1g2TagInventoryStateUnawareFilterAction = new C1G2TagInventoryStateUnawareFilterAction();
            filters[0].setC1G2TagInventoryMask(c1g2TagInventoryMask);
            filters[0].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterAction);
            TagFilter enabledFilter = filterSettings.getMode() == TagFilterMode.OnlyFilter1 ? filterSettings.getTagFilter1() : filterSettings.getTagFilter2();
            c1g2TagInventoryMask.setMB(this.twoBitFieldFromInt(enabledFilter.getMemoryBank().getValue()));
            UnsignedShort bitPointerFilter = new UnsignedShort(enabledFilter.getBitPointer());
            c1g2TagInventoryMask.setPointer(bitPointerFilter);
            BitArray_HEX b = new BitArray_HEX(enabledFilter.getTagMask());
            c1g2TagInventoryMask.setTagMask(b);
            filters[0].setC1G2TagInventoryMask(c1g2TagInventoryMask);
            filters[0].setT(new C1G2TruncateAction(1));
            if (enabledFilter.getBitCount() > 0L) {
                filters[0].getC1G2TagInventoryMask().setTagMask(this.truncateTagMask(filters[0].getC1G2TagInventoryMask().getTagMask(), (int)enabledFilter.getBitCount()));
            }
            if (enabledFilter.getFilterOp() == TagFilterOp.Match) {
                C1G2StateUnawareAction c1g2tateUnawareAction = new C1G2StateUnawareAction();
                c1g2tateUnawareAction.set(0);
                c1g2TagInventoryStateUnawareFilterAction.setAction(c1g2tateUnawareAction);
                filters[0].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterAction);
            } else {
                C1G2StateUnawareAction c1g2tateUnawareAction = new C1G2StateUnawareAction();
                c1g2tateUnawareAction.set(4);
                c1g2TagInventoryStateUnawareFilterAction.setAction(c1g2tateUnawareAction);
                filters[0].setC1G2TagInventoryStateUnawareFilterAction(c1g2TagInventoryStateUnawareFilterAction);
            }
        }
        return filters;
    }

    BitArray_HEX truncateTagMask(BitArray_HEX mask, int len) throws OctaneSdkException {
        BitArray_HEX newMask = mask;
        if (len > mask.size()) {
            throw new OctaneSdkException("Error setting the tag mask. The value specified for BitCount is greater than the data provided.");
        }
        if (mask.size() % 8 != 0) {
            throw new OctaneSdkException("Error setting the tag mask. The tag mask bit length must be divisible by 8. From the LLRP Spec: Integer numbers SHALL be encoded in network byte order with the most significant byte of the integer being sent first (big-Endian). Bit arrays are aligned to the most significant bit. Bit arrays are padded to an octet boundary. Pad bits SHALL be ignored by the Reader and Client.");
        }
        if (len < mask.size()) {
            newMask = new BitArray_HEX(len);
            for (int i = 0; i < len; ++i) {
                if (!mask.get(i).toBoolean()) continue;
                newMask.set(i);
            }
        }
        return newMask;
    }

    AISpec getAiSpec(Settings config) throws OctaneSdkException {
        ImpinjReducedPowerFrequencyList reducedFreq;
        C1G2Filter[] c1g2Filters;
        int numEnabledAntennas = 0;
        int index = 0;
        AISpec aiSpec = new AISpec();
        UnsignedShortArray antennaIDs = new UnsignedShortArray();
        for (AntennaConfig antenna : config.getAntennas()) {
            if (!antenna.isEnabled()) continue;
            antennaIDs.add(new UnsignedShort((int)antenna.getPortNumber()));
            numEnabledAntennas = (short)(numEnabledAntennas + 1);
        }
        aiSpec.setAntennaIDs(antennaIDs);
        AISpecStopTrigger aiSpecStopTrigger = new AISpecStopTrigger();
        AISpecStopTriggerType aiSpecStopTriggerType = new AISpecStopTriggerType();
        aiSpecStopTriggerType.set(0);
        aiSpecStopTrigger.setAISpecStopTriggerType(aiSpecStopTriggerType);
        aiSpecStopTrigger.setDurationTrigger(new UnsignedInteger(0));
        aiSpec.setAISpecStopTrigger(aiSpecStopTrigger);
        C1G2InventoryCommand c1g2Inv = new C1G2InventoryCommand();
        c1g2Inv.setTagInventoryStateAware(new Bit(false));
        C1G2RFControl c1g2RF = new C1G2RFControl();
        if (config.getFilters().getTagFilterVerificationMode() != null) {
            ImpinjTagFilterVerificationConfiguration tfvc = new ImpinjTagFilterVerificationConfiguration();
            if (config.getFilters().getTagFilterVerificationMode().booleanValue()) {
                tfvc.setTagFilterVerificationMode(new ImpinjTagFilterVerificationMode(1));
            } else {
                tfvc.setTagFilterVerificationMode(new ImpinjTagFilterVerificationMode(0));
            }
            c1g2Inv.addToCustomList((Custom)tfvc);
        }
        if ((c1g2Filters = this.getC1G2Filters(config.getFilters())) != null) {
            c1g2Inv.setC1G2FilterList(Arrays.asList(c1g2Filters));
        }
        if (config.getRfMode() == null) {
            c1g2RF.setModeIndex(new UnsignedShort(config.getReaderMode().getValue()));
        } else {
            c1g2RF.setModeIndex(new UnsignedShort(config.getRfMode()));
        }
        c1g2RF.setTari(new UnsignedShort(0));
        c1g2Inv.setC1G2RFControl(c1g2RF);
        C1G2SingulationControl c1g2Sing = new C1G2SingulationControl();
        c1g2Sing.setSession(this.twoBitFieldSessionFromInt(config.getSession()));
        c1g2Sing.setTagPopulation(new UnsignedShort(config.getTagPopulationEstimate()));
        c1g2Sing.setTagTransitTime(new UnsignedInteger(0));
        c1g2Inv.setC1G2SingulationControl(c1g2Sing);
        if (config.getLowDutyCycle().getIsEnabled().booleanValue()) {
            ImpinjLowDutyCycle lowDutyCycle = new ImpinjLowDutyCycle();
            ImpinjLowDutyCycleMode impinjLowDutyCycleMode = new ImpinjLowDutyCycleMode(1);
            lowDutyCycle.setLowDutyCycleMode(impinjLowDutyCycleMode);
            lowDutyCycle.setEmptyFieldTimeout(new UnsignedShort(config.getLowDutyCycle().getEmptyFieldTimeoutInMs()));
            lowDutyCycle.setFieldPingInterval(new UnsignedShort(config.getLowDutyCycle().getFieldPingIntervalInMs()));
            c1g2Inv.addToCustomList((Custom)lowDutyCycle);
        }
        if (config.getTruncatedReply().getIsEnabled()) {
            ImpinjTruncatedReplyConfiguration truncatedReplyConfig = new ImpinjTruncatedReplyConfiguration();
            truncatedReplyConfig.setGen2v2TagsOnly(new Bit(config.getTruncatedReply().getGen2v2TagsOnly()));
            truncatedReplyConfig.setEPCLength(new UnsignedByte(config.getTruncatedReply().getEpcLengthInWords()));
            truncatedReplyConfig.setPointer(new UnsignedShort((int)config.getTruncatedReply().getBitPointer()));
            truncatedReplyConfig.setTagMask(new BitArray_HEX(config.getTruncatedReply().getTagMask()));
            c1g2Inv.addToCustomList((Custom)truncatedReplyConfig);
        }
        ImpinjInventorySearchMode impISM = new ImpinjInventorySearchMode();
        ImpinjInventorySearchType impinjInventorySearchType = new ImpinjInventorySearchType(config.getSearchMode().getValue());
        impISM.setInventorySearchMode(impinjInventorySearchType);
        c1g2Inv.addToCustomList((Custom)impISM);
        if (config.getSearchMode() == SearchMode.TagFocus && config.getSession() != 1) {
            throw new OctaneSdkException("SearchMode.TagFocus can only be used when Session = 1");
        }
        ImpinjFixedFrequencyList fixedFreq = this.getFixedFrequencyList(config);
        if (fixedFreq.getChannelList().size() > 0) {
            c1g2Inv.addToCustomList((Custom)fixedFreq);
        }
        if ((reducedFreq = this.getReducedPowerFrequencyList(config)).getChannelList().size() > 0) {
            c1g2Inv.addToCustomList((Custom)reducedFreq);
        }
        if (numEnabledAntennas > 0) {
            index = 0;
            InventoryParameterSpec[] inventoryParameterSpec = new InventoryParameterSpec[]{new InventoryParameterSpec()};
            inventoryParameterSpec[0].setInventoryParameterSpecID(new UnsignedShort(123));
            inventoryParameterSpec[0].setProtocolID(new AirProtocols(1));
            inventoryParameterSpec[0].setAntennaConfigurationList(new ArrayList(numEnabledAntennas));
            for (AntennaConfig antenna : config.getAntennas()) {
                short txIndex;
                short rxIndex;
                if (!antenna.isEnabled()) continue;
                if (antenna.getIsMaxRxSensitivity().booleanValue()) {
                    rxIndex = 1;
                } else {
                    rxIndex = this.getRxSensitivityIndex(antenna.getRxSensitivityinDbm());
                    if (rxIndex == 0) {
                        throw new OctaneSdkException("Invalid Rx Sensitivity setting for antenna port " + antenna.getPortNumber());
                    }
                }
                if (antenna.getIsMaxTxPower().booleanValue()) {
                    txIndex = (short)this.readerCapabilities.getTxPowers().size();
                } else {
                    txIndex = this.getTxPowerIndex(antenna.getTxPowerinDbm());
                    if (txIndex == 0) {
                        throw new OctaneSdkException("Invalid Tx Power setting for antenna port" + antenna.getPortNumber());
                    }
                }
                AntennaConfiguration antennaConfiguration = new AntennaConfiguration();
                antennaConfiguration.setAntennaID(new UnsignedShort((int)antenna.getPortNumber()));
                antennaConfiguration.addToAirProtocolInventoryCommandSettingsList((AirProtocolInventoryCommandSettings)c1g2Inv);
                RFTransmitter rfTransmitter = new RFTransmitter();
                rfTransmitter.setTransmitPower(new UnsignedShort((int)txIndex));
                rfTransmitter.setHopTableID(new UnsignedShort(1));
                rfTransmitter.setChannelIndex(new UnsignedShort(1));
                antennaConfiguration.setRFTransmitter(rfTransmitter);
                RFReceiver rfReceiver = new RFReceiver();
                rfReceiver.setReceiverSensitivity(new UnsignedShort((int)rxIndex));
                antennaConfiguration.setRFReceiver(rfReceiver);
                inventoryParameterSpec[0].addToAntennaConfigurationList(antennaConfiguration);
                index = (short)(index + 1);
            }
            aiSpec.addToInventoryParameterSpecList(inventoryParameterSpec[0]);
        }
        return aiSpec;
    }

    private ImpinjFixedFrequencyList getFixedFrequencyList(Settings settings) throws OctaneSdkException {
        ImpinjFixedFrequencyList fixedFreq = new ImpinjFixedFrequencyList();
        fixedFreq.setFixedFrequencyMode(new ImpinjFixedFrequencyMode(2));
        UnsignedShortArray channelList = new UnsignedShortArray();
        for (double freq : settings.getTxFrequenciesInMhz()) {
            short index = this.getTxFreqIndex(freq);
            if (index != 0) {
                channelList.add(new UnsignedShort((int)index));
                continue;
            }
            throw new OctaneSdkException("The specified transmit frequency is invalid : " + freq);
        }
        fixedFreq.setChannelList(channelList);
        return fixedFreq;
    }

    private ImpinjReducedPowerFrequencyList getReducedPowerFrequencyList(Settings settings) throws OctaneSdkException {
        ImpinjReducedPowerFrequencyList reducedFreq = new ImpinjReducedPowerFrequencyList();
        reducedFreq.setReducedPowerMode(new ImpinjReducedPowerMode(1));
        UnsignedShortArray channelList = new UnsignedShortArray();
        for (double freq : settings.getReducedPowerFrequenciesInMhz()) {
            short index = this.getTxFreqIndex(freq);
            if (index != 0) {
                channelList.add(new UnsignedShort((int)index));
                continue;
            }
            throw new OctaneSdkException("The specified transmit frequency is invalid : " + freq);
        }
        reducedFreq.setChannelList(channelList);
        return reducedFreq;
    }

    TwoBitField twoBitFieldFromInt(int value) {
        TwoBitField tb = new TwoBitField();
        if ((value & 1) > 0) {
            tb.set(Integer.valueOf(1));
        } else {
            tb.clear(Integer.valueOf(1));
        }
        if ((value & 2) > 0) {
            tb.set(Integer.valueOf(0));
        } else {
            tb.clear(Integer.valueOf(0));
        }
        return tb;
    }

    TwoBitField twoBitFieldSessionFromInt(int session) {
        TwoBitField tb = new TwoBitField();
        Bit[] sessionBits = new Bit[2];
        switch (session) {
            case 1: {
                sessionBits[0] = new Bit(0);
                sessionBits[1] = new Bit(1);
                tb = new TwoBitField(sessionBits);
                break;
            }
            case 2: {
                sessionBits[0] = new Bit(1);
                sessionBits[1] = new Bit(0);
                tb = new TwoBitField(sessionBits);
                break;
            }
            case 3: {
                sessionBits[0] = new Bit(1);
                sessionBits[1] = new Bit(1);
                tb = new TwoBitField(sessionBits);
                break;
            }
            default: {
                sessionBits[0] = new Bit(0);
                sessionBits[1] = new Bit(0);
                tb = new TwoBitField(sessionBits);
            }
        }
        return tb;
    }

    ImpinjLISpec getLISpec(Settings config) throws OctaneSdkException {
        ImpinjLocationConfig locConfig = new ImpinjLocationConfig();
        ImpinjC1G2LocationConfig c1g2Config = new ImpinjC1G2LocationConfig();
        if (config != null) {
            C1G2Filter[] c1g2Filters;
            LocationConfig locationConfig = config.getSpatialConfig().getLocation();
            if (locationConfig != null) {
                locConfig.setComputeWindowSeconds(new UnsignedShort((int)locationConfig.getComputeWindowSeconds()));
                locConfig.setTagAgeIntervalSeconds(new UnsignedShort((int)locationConfig.getTagAgeIntervalSeconds()));
                locConfig.setUpdateIntervalSeconds(new UnsignedShort((int)locationConfig.getUpdateIntervalSeconds()));
                if (!locationConfig.getDisabledAntennaList().isEmpty()) {
                    ImpinjDisabledAntennas impinjDisabledAntennas = new ImpinjDisabledAntennas();
                    UnsignedShortArray disabledAntennaArray = new UnsignedShortArray();
                    for (Short antenna : locationConfig.getDisabledAntennaList()) {
                        disabledAntennaArray.add(new UnsignedShort(antenna));
                    }
                    impinjDisabledAntennas.setAntennaIDs(disabledAntennaArray);
                    locConfig.setImpinjDisabledAntennas(impinjDisabledAntennas);
                }
                if (!locationConfig.getLocationAlgorithmControlList().isEmpty()) {
                    ImpinjLocationAlgorithmControl impinjLocationAlgorithmControl = new ImpinjLocationAlgorithmControl();
                    UnsignedIntegerArray locationAlgorithmControlArray = new UnsignedIntegerArray();
                    for (Integer num : locationConfig.getLocationAlgorithmControlList()) {
                        locationAlgorithmControlArray.add(new UnsignedInteger(num));
                    }
                    impinjLocationAlgorithmControl.setControlData(locationAlgorithmControlArray);
                    locConfig.setImpinjLocationAlgorithmControl(impinjLocationAlgorithmControl);
                }
                ImpinjTransmitPower impinjTransmitPower = this.getTransmitPowerFromDbm(locationConfig.getTxPowerinDbm());
                if (!locationConfig.getIsMaxTxPower().booleanValue()) {
                    if (impinjTransmitPower.getTransmitPower().toShort() == 0) {
                        throw new OctaneSdkException("Invalid Tx Power setting");
                    }
                    c1g2Config.setImpinjTransmitPower(impinjTransmitPower);
                }
            }
            if ((c1g2Filters = this.getC1G2Filters(config.getFilters())) != null) {
                c1g2Config.setC1G2FilterList(Arrays.asList(c1g2Filters));
            }
            if (config.getRfMode() == null) {
                c1g2Config.setModeIndex(new UnsignedShort(config.getReaderMode().getValue()));
            } else {
                c1g2Config.setModeIndex(new UnsignedShort(config.getRfMode()));
            }
            c1g2Config.setSession(this.twoBitFieldSessionFromInt(config.getSession()));
        }
        ImpinjLISpec liSpec = new ImpinjLISpec();
        liSpec.setImpinjLocationConfig(locConfig);
        liSpec.setImpinjC1G2LocationConfig(c1g2Config);
        return liSpec;
    }

    ImpinjDISpec getDISpec(Settings config) throws OctaneSdkException {
        ImpinjDISpec diSpec = new ImpinjDISpec();
        diSpec.setImpinjDirectionConfig(this.getImpinjDirectionConfig(config));
        diSpec.setImpinjC1G2DirectionConfig(this.getImpinjC1G2DirectionConfig(config));
        diSpec.setImpinjDirectionSectors(this.getImpinjDirectionSectors(config));
        return diSpec;
    }

    private ImpinjDirectionConfig getImpinjDirectionConfig(Settings config) {
        ImpinjDirectionConfig impinjDirectionConfig = new ImpinjDirectionConfig();
        if (config != null && config.getSpatialConfig() != null && config.getSpatialConfig().getDirection() != null) {
            DirectionConfig directionConfig = config.getSpatialConfig().getDirection();
            impinjDirectionConfig.setFieldOfView(directionConfig.getFieldOfView().toImpinjDirectionFieldOfView());
            impinjDirectionConfig.setTagAgeIntervalSeconds(new UnsignedShort((int)directionConfig.getTagAgeIntervalSeconds()));
            impinjDirectionConfig.setUpdateIntervalSeconds(new UnsignedShort((int)directionConfig.getUpdateIntervalSeconds()));
            ImpinjDirectionUserTagPopulationLimit tagPopulationLimit = new ImpinjDirectionUserTagPopulationLimit();
            tagPopulationLimit.setUserTagPopulationLimit(new UnsignedShort((int)directionConfig.getUserTagPopulationLimit()));
            impinjDirectionConfig.setImpinjDirectionUserTagPopulationLimit(tagPopulationLimit);
        }
        return impinjDirectionConfig;
    }

    private ImpinjC1G2DirectionConfig getImpinjC1G2DirectionConfig(Settings config) throws OctaneSdkException {
        ImpinjC1G2DirectionConfig c1g2Config = new ImpinjC1G2DirectionConfig();
        if (config != null && config.getSpatialConfig() != null && config.getSpatialConfig().getDirection() != null) {
            DirectionConfig directionConfig = config.getSpatialConfig().getDirection();
            C1G2Filter[] c1g2Filters = this.getC1G2Filters(config.getFilters());
            if (c1g2Filters != null) {
                c1g2Config.setC1G2FilterList(Arrays.asList(c1g2Filters));
            }
            c1g2Config.setRFMode(directionConfig.getMode().toImpinjDirectionRFMode());
            ImpinjTransmitPower impinjTransmitPower = this.getTransmitPowerFromDbm(directionConfig.getTxPowerinDbm());
            if (!directionConfig.getIsMaxTxPower()) {
                if (impinjTransmitPower.getTransmitPower().toShort() == 0) {
                    throw new OctaneSdkException("Invalid Tx Power setting");
                }
                c1g2Config.setImpinjTransmitPower(impinjTransmitPower);
            }
        }
        return c1g2Config;
    }

    private ImpinjDirectionSectors getImpinjDirectionSectors(Settings config) {
        ImpinjDirectionSectors sectorConfig = new ImpinjDirectionSectors();
        if (config != null && config.getSpatialConfig() != null && config.getSpatialConfig().getDirection() != null) {
            DirectionConfig directionConfig = config.getSpatialConfig().getDirection();
            UnsignedShortArray enabledSectors = new UnsignedShortArray();
            for (Short sector : directionConfig.getEnabledSectors()) {
                enabledSectors.add(new UnsignedShort(sector));
            }
            sectorConfig.setEnabledSectorIDs(enabledSectors);
        }
        return sectorConfig;
    }

    private ImpinjTransmitPower getTransmitPowerFromDbm(double dbm) {
        short powerIndex = this.getTxPowerIndex(dbm);
        ImpinjTransmitPower transmitPower = new ImpinjTransmitPower();
        transmitPower.setTransmitPower(new UnsignedShort((int)powerIndex));
        return transmitPower;
    }

    GET_ROSPECS_RESPONSE getRoSpecs() throws OctaneSdkException {
        GET_ROSPECS_RESPONSE rsp;
        GET_ROSPECS msg = new GET_ROSPECS();
        ERROR_MESSAGE msgErr = null;
        msg.setMessageID(this.getUniqueMessageID());
        String msgType = "GET_ROSPECS";
        try {
            rsp = (GET_ROSPECS_RESPONSE)this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException timeoutEx) {
            throw new OctaneSdkException("OctaneSdk timeout exception: " + timeoutEx.getMessage());
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        this.checkLlrpReply(rsp.getLLRPStatus(), msgErr, msgType);
        return rsp;
    }

    short getRxSensitivityIndex(double dBm) {
        for (RxSensitivityTableEntry entry : this.readerCapabilities.getRxSensitivities()) {
            if (dBm != entry.Dbm) continue;
            return entry.Index.toShort();
        }
        return 0;
    }

    short getTxPowerIndex(double dBm) {
        for (TxPowerTableEntry entry : this.readerCapabilities.getTxPowers()) {
            if (dBm != entry.Dbm) continue;
            return entry.Index.toShort();
        }
        return 0;
    }

    short getTxFreqIndex(double freq) {
        short index = 0;
        ArrayList<Double> sortedTxFrequencies = new ArrayList<Double>(this.readerCapabilities.txFrequencies);
        Collections.sort(sortedTxFrequencies);
        for (int i = 0; i < sortedTxFrequencies.size(); ++i) {
            if ((Double)sortedTxFrequencies.get(i) != freq) continue;
            index = (short)(i + 1);
            break;
        }
        return index;
    }

    public void errorOccured(String arg0) {
    }

    void doMessageReceived(LLRPMessage message) {
        if (message.getTypeNum() == RO_ACCESS_REPORT.TYPENUM) {
            RO_ACCESS_REPORT report = (RO_ACCESS_REPORT)message;
            try {
                this.onTagReportAvailableInternal(report);
            }
            catch (OctaneSdkException e) {
                e.printStackTrace();
            }
        } else if (message.getTypeNum() == READER_EVENT_NOTIFICATION.TYPENUM) {
            READER_EVENT_NOTIFICATION readerEventNotification = (READER_EVENT_NOTIFICATION)message;
            try {
                this.onReaderEventInternal(readerEventNotification);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (message.getTypeNum() == KEEPALIVE.TYPENUM) {
            KEEPALIVE keepalive = (KEEPALIVE)message;
            this.onKeepaliveMessage(keepalive);
        }
    }

    public void messageReceived(LLRPMessage message) {
        this.messageHandler.add(message);
    }

    void processCustomReports(RO_ACCESS_REPORT msg) throws OctaneSdkException {
        if (msg.getCustomList() != null && msg.getCustomList().size() > 0) {
            for (Custom custom : msg.getCustomList()) {
                Object report;
                if (custom instanceof ImpinjExtendedTagInformation) {
                    ImpinjExtendedTagInformation tagInfo = (ImpinjExtendedTagInformation)custom;
                    if (tagInfo.getImpinjLocationReportData() != null) {
                        report = new LocationReport();
                        ((LocationReport)report).setEpc(TagData.fromHexString(((EPCData)tagInfo.getEPCDataList().get(0)).getEPC().toString()));
                        ((LocationReport)report).getConfidenceFactors().setReadCount(tagInfo.getImpinjLocationReportData().getImpinjLocationConfidence().getReadCount().toShort());
                        for (int dataIndex = 0; dataIndex < tagInfo.getImpinjLocationReportData().getImpinjLocationConfidence().getConfidenceData().size(); ++dataIndex) {
                            ((LocationReport)report).getConfidenceFactors().getData().add(tagInfo.getImpinjLocationReportData().getImpinjLocationConfidence().getConfidenceData().get(dataIndex).toInteger());
                        }
                        ((LocationReport)report).setLocationXCm(tagInfo.getImpinjLocationReportData().getLocXCentimeters().intValue());
                        ((LocationReport)report).setLocationYCm(tagInfo.getImpinjLocationReportData().getLocYCentimeters().intValue());
                        ((LocationReport)report).setReportType(LocationReportType.valueOf(tagInfo.getImpinjLocationReportData().getType().intValue()));
                        ((LocationReport)report).setTimestamp(new ImpinjTimestamp(tagInfo.getImpinjLocationReportData().getLastSeenTimestampUTC().toLong()));
                        if (this.locationReportListener == null) continue;
                        this.locationReportListener.onLocationReported(this, (LocationReport)report);
                        continue;
                    }
                    if (tagInfo.getImpinjDirectionReportData() == null) continue;
                    report = new DirectionReport();
                    ((DirectionReport)report).setEpc(TagData.fromHexString(((EPCData)tagInfo.getEPCDataList().get(0)).getEPC().toString()));
                    ((DirectionReport)report).setFirstSeenSector(tagInfo.getImpinjDirectionReportData().getFirstSeenSectorID().toInteger().shortValue());
                    ((DirectionReport)report).setLastReadSector(tagInfo.getImpinjDirectionReportData().getLastSeenSectorID().toInteger().shortValue());
                    ((DirectionReport)report).setFirstSeenTime(new ImpinjTimestamp(tagInfo.getImpinjDirectionReportData().getFirstSeenTimestampUTC().toLong()));
                    ((DirectionReport)report).setLastReadTime(new ImpinjTimestamp(tagInfo.getImpinjDirectionReportData().getLastSeenTimestampUTC().toLong()));
                    ((DirectionReport)report).setTagPopulationStatus(DirectionTagPopulationStatus.valueOf(tagInfo.getImpinjDirectionReportData().getTagPopulationStatus().intValue()));
                    ((DirectionReport)report).setReportType(DirectionReportType.valueOf(tagInfo.getImpinjDirectionReportData().getType().intValue()));
                    if (this.directionReportListener == null) continue;
                    this.directionReportListener.onDirectionReported(this, (DirectionReport)report);
                    continue;
                }
                if (!(custom instanceof ImpinjDiagnosticReport)) continue;
                ImpinjDiagnosticReport diagReport = (ImpinjDiagnosticReport)custom;
                report = new DiagnosticReport();
                for (int metricIndex = 0; metricIndex < diagReport.getMetric().size(); ++metricIndex) {
                    ((DiagnosticReport)report).addMetric(diagReport.getMetric().get(metricIndex).toInteger());
                }
                if (this.diagnosticsReportListener == null) continue;
                this.diagnosticsReportListener.onDiagnosticsReported(this, (DiagnosticReport)report);
            }
        }
    }

    void processOpSpecResults(TagOpReport opReport, TagReportData tr, Tag tag) throws OctaneSdkException {
        if (tr.getAccessCommandOpSpecResultList() != null) {
            for (AccessCommandOpSpecResult accessCommandOpSpecResult : tr.getAccessCommandOpSpecResultList()) {
                TagWriteOpResult writeResult;
                C1G2WriteOpSpecResult c1g2WriteResult;
                int accessSpecId = tr.getAccessSpecID().getAccessSpecID().intValue();
                if (accessCommandOpSpecResult instanceof C1G2ReadOpSpecResult) {
                    C1G2ReadOpSpecResult c1g2ReadResult = (C1G2ReadOpSpecResult)accessCommandOpSpecResult;
                    TagReadOpResult readResult = new TagReadOpResult();
                    readResult.setResult(ReadResultStatus.valueOf(c1g2ReadResult.getResult().intValue()));
                    readResult.setOpId(c1g2ReadResult.getOpSpecID().toShort());
                    readResult.setSequenceId(accessSpecId);
                    if (c1g2ReadResult.getResult().intValue() == 0) {
                        readResult.setData(TagData.fromHexString(c1g2ReadResult.getReadData().toString()));
                    }
                    readResult.setTag(tag);
                    opReport.addResult(readResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof C1G2WriteOpSpecResult) {
                    c1g2WriteResult = (C1G2WriteOpSpecResult)accessCommandOpSpecResult;
                    writeResult = new TagWriteOpResult();
                    writeResult.setResult(WriteResultStatus.valueOf(c1g2WriteResult.getResult().intValue()));
                    writeResult.setOpId(c1g2WriteResult.getOpSpecID().toShort());
                    writeResult.setSequenceId(accessSpecId);
                    writeResult.setNumWordsWritten(c1g2WriteResult.getNumWordsWritten().toShort());
                    writeResult.setTag(tag);
                    writeResult.setBlockWrite(false);
                    opReport.addResult(writeResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof C1G2BlockWriteOpSpecResult) {
                    c1g2WriteResult = (C1G2BlockWriteOpSpecResult)accessCommandOpSpecResult;
                    writeResult = new TagWriteOpResult();
                    writeResult.setResult(WriteResultStatus.valueOf(c1g2WriteResult.getResult().intValue()));
                    writeResult.setOpId(c1g2WriteResult.getOpSpecID().toShort());
                    writeResult.setSequenceId(accessSpecId);
                    writeResult.setNumWordsWritten(c1g2WriteResult.getNumWordsWritten().toShort());
                    writeResult.setTag(tag);
                    writeResult.setBlockWrite(true);
                    opReport.addResult(writeResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof C1G2LockOpSpecResult) {
                    C1G2LockOpSpecResult c1g2LockResult = (C1G2LockOpSpecResult)accessCommandOpSpecResult;
                    TagLockOpResult lockResult = new TagLockOpResult();
                    lockResult.setOpId(c1g2LockResult.getOpSpecID().toShort());
                    lockResult.setSequenceId(accessSpecId);
                    lockResult.setTag(tag);
                    lockResult.setResult(LockResultStatus.valueOf(c1g2LockResult.getResult().intValue()));
                    opReport.addResult(lockResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof ImpinjSetQTConfigOpSpecResult) {
                    ImpinjSetQTConfigOpSpecResult c1g2SetQtResults = (ImpinjSetQTConfigOpSpecResult)accessCommandOpSpecResult;
                    TagQtSetOpResult setQtResult = new TagQtSetOpResult();
                    setQtResult.setOpId(c1g2SetQtResults.getOpSpecID().toShort());
                    setQtResult.setSequenceId(accessSpecId);
                    setQtResult.setTag(tag);
                    setQtResult.setResult(QtSetConfigResultStatus.valueOf(c1g2SetQtResults.getResult().intValue()));
                    opReport.addResult(setQtResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof ImpinjGetQTConfigOpSpecResult) {
                    ImpinjGetQTConfigOpSpecResult c1g2GetQtResults = (ImpinjGetQTConfigOpSpecResult)accessCommandOpSpecResult;
                    TagQtGetOpResult getQtResult = new TagQtGetOpResult();
                    getQtResult.setOpId(c1g2GetQtResults.getOpSpecID().toShort());
                    getQtResult.setSequenceId(accessSpecId);
                    getQtResult.setTag(tag);
                    getQtResult.setResult(QtGetConfigResultStatus.valueOf(c1g2GetQtResults.getResult().intValue()));
                    getQtResult.setAccessRange(QtAccessRange.valueOf(c1g2GetQtResults.getAccessRange().intValue()));
                    getQtResult.setDataProfile(QtDataProfile.valueOf(c1g2GetQtResults.getDataProfile().intValue()));
                    opReport.addResult(getQtResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof C1G2KillOpSpecResult) {
                    C1G2KillOpSpecResult c1g2KillResult = (C1G2KillOpSpecResult)accessCommandOpSpecResult;
                    TagKillOpResult killResult = new TagKillOpResult();
                    killResult.setOpId(c1g2KillResult.getOpSpecID().toShort());
                    killResult.setSequenceId(accessSpecId);
                    killResult.setTag(tag);
                    killResult.setResult(KillResultStatus.valueOf(c1g2KillResult.getResult().intValue()));
                    opReport.addResult(killResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof ImpinjBlockPermalockOpSpecResult) {
                    ImpinjBlockPermalockOpSpecResult c1g2BplResult = (ImpinjBlockPermalockOpSpecResult)accessCommandOpSpecResult;
                    TagBlockPermalockOpResult bplResult = new TagBlockPermalockOpResult();
                    bplResult.setOpId(c1g2BplResult.getOpSpecID().toShort());
                    bplResult.setSequenceId(accessSpecId);
                    bplResult.setResult(BlockPermalockResult.valueOf(c1g2BplResult.getResult().intValue()));
                    bplResult.setTag(tag);
                    opReport.addResult(bplResult);
                    continue;
                }
                if (accessCommandOpSpecResult instanceof ImpinjMarginReadOpSpecResult) {
                    ImpinjMarginReadOpSpecResult c1g2MrResult = (ImpinjMarginReadOpSpecResult)accessCommandOpSpecResult;
                    TagMarginReadOpResult mrResult = new TagMarginReadOpResult();
                    mrResult.setOpId(c1g2MrResult.getOpSpecID().toShort());
                    mrResult.setSequenceId(accessSpecId);
                    mrResult.setResult(MarginReadResult.valueOf(c1g2MrResult.getResult().intValue()));
                    mrResult.setTag(tag);
                    opReport.addResult(mrResult);
                    continue;
                }
                if (!(accessCommandOpSpecResult instanceof ImpinjAuthenticateOpSpecResult)) continue;
                ImpinjAuthenticateOpSpecResult c1g2AuthResult = (ImpinjAuthenticateOpSpecResult)accessCommandOpSpecResult;
                TagImpinjAuthenticateOpResult authResult = new TagImpinjAuthenticateOpResult();
                authResult.setTag(tag);
                authResult.setOpId(c1g2AuthResult.getOpSpecID().toShort());
                authResult.setResult(ImpinjAuthenticateResult.valueOf(c1g2AuthResult.getResult().intValue()));
                TagData originalChallengeMessage = this.outstandingAuthenticateRequests.remove(authResult.getOpId());
                if (originalChallengeMessage != null) {
                    authResult.setChallengeMessage(originalChallengeMessage);
                    if (authResult.getResult() == ImpinjAuthenticateResult.Success) {
                        BitArray_HEX rspBitArray = c1g2AuthResult.getResponse();
                        List<Integer> rspShortsList = this.bitArrayToList(rspBitArray);
                        switch (rspShortsList.size()) {
                            case 8: {
                                authResult.setResponseTid(TagData.fromWordList(rspShortsList.subList(0, 4)));
                                authResult.setResponseCypherMessage(TagData.fromWordList(rspShortsList.subList(4, 8)));
                                break;
                            }
                            case 4: {
                                authResult.setResponseCypherMessage(TagData.fromWordList(rspShortsList.subList(0, 4)));
                                break;
                            }
                            default: {
                                throw new OctaneSdkException(String.format("Invalid word count in reply: %d. Expected count 4 or 8.", rspShortsList.size()));
                            }
                        }
                    }
                } else {
                    authResult.setErrorMessage(String.format("Original message not found for OpSpecId: %d", authResult.getOpId()));
                }
                opReport.addResult(authResult);
            }
        }
    }

    Tag buildTag(TagReportData tr) throws OctaneSdkException {
        Tag tag = new Tag();
        if (tr.getEPCParameter() != null) {
            ImpinjTimestamp impinjTimestamp;
            LLRPParameter epcParameter = (LLRPParameter)tr.getEPCParameter();
            if (epcParameter.getName().equals("EPC_96")) {
                EPC_96 epc96 = (EPC_96)epcParameter;
                tag.setEpc(TagData.fromHexString(epc96.getEPC().toString()));
            } else if (epcParameter.getName().equals("EPCData")) {
                EPCData epcData = (EPCData)epcParameter;
                tag.setEpc(TagData.fromHexString(epcData.getEPC().toString()));
            }
            if (tr.getAntennaID() != null) {
                tag.setAntennaPortNumber(tr.getAntennaID().getAntennaID().toShort());
                tag.setAntennaPortNumberPresent(true);
            }
            if (tr.getChannelIndex() != null) {
                tag.setChannelInMhz(this.readerCapabilities.getTxFrequencies().get(tr.getChannelIndex().getChannelIndex().intValue() - 1));
                tag.setChannelInMhzPresent(true);
            }
            if (tr.getFirstSeenTimestampUTC() != null) {
                impinjTimestamp = new ImpinjTimestamp(tr.getFirstSeenTimestampUTC().getMicroseconds().toLong());
                tag.setFirstSeenTime(impinjTimestamp);
                tag.setFirstSeenTimePresent(true);
            }
            if (tr.getLastSeenTimestampUTC() != null) {
                impinjTimestamp = new ImpinjTimestamp(tr.getLastSeenTimestampUTC().getMicroseconds().toLong());
                tag.setLastSeenTime(impinjTimestamp);
                tag.setLastSeenTimePresent(true);
            }
            if (tr.getTagSeenCount() != null) {
                tag.setTagSeenCount(tr.getTagSeenCount().getTagCount().toShort());
                tag.setSeenCountPresent(true);
            }
            for (AirProtocolTagData airProtocolTagData : tr.getAirProtocolTagDataList()) {
                if (airProtocolTagData instanceof C1G2_CRC) {
                    C1G2_CRC crc = (C1G2_CRC)airProtocolTagData;
                    tag.setCrc(crc.getCRC().toShort());
                    tag.setCrcPresent(true);
                    continue;
                }
                if (!(airProtocolTagData instanceof C1G2_PC)) continue;
                C1G2_PC pc = (C1G2_PC)airProtocolTagData;
                tag.setPcBits(pc.getPC_Bits().toShort());
                tag.setPcBitsPresent(true);
            }
            for (Custom custom : tr.getCustomList()) {
                if (custom instanceof ImpinjSerializedTID) {
                    ImpinjSerializedTID tid = (ImpinjSerializedTID)custom;
                    tag.setTid(TagData.fromHexString(tid.getTID().toString()));
                    tag.setFastIdPresent(true);
                    TagModelDetails details = new TagModelDetails(tag.getTid().toHexString());
                    tag.setModelDetails(details);
                    continue;
                }
                if (custom instanceof ImpinjRFDopplerFrequency) {
                    ImpinjRFDopplerFrequency doppler = (ImpinjRFDopplerFrequency)custom;
                    tag.setRfDopplerFrequency((double)doppler.getDopplerFrequency().toShort() / 16.0);
                    tag.setRfDopplerFrequencyPresent(true);
                    continue;
                }
                if (custom instanceof ImpinjRFPhaseAngle) {
                    ImpinjRFPhaseAngle phase = (ImpinjRFPhaseAngle)custom;
                    tag.setPhaseAngleInRadians((double)phase.getPhaseAngle().toShort() * 0.0015339807878856412);
                    tag.setRfPhaseAnglePresent(true);
                    continue;
                }
                if (custom instanceof ImpinjPeakRSSI) {
                    ImpinjPeakRSSI rssi = (ImpinjPeakRSSI)custom;
                    tag.setPeakRssiInDbm((double)rssi.getRSSI().toShort() / 100.0);
                    tag.setPeakRssiInDbmPresent(true);
                    continue;
                }
                if (!(custom instanceof ImpinjGPSCoordinates)) continue;
                ImpinjGPSCoordinates gps = (ImpinjGPSCoordinates)custom;
                GpsCoordinates gpsCoodinates = new GpsCoordinates();
                gpsCoodinates.setLatitude((double)gps.getLatitude().toInteger().intValue() / 1000000.0);
                gpsCoodinates.setLongitude((double)gps.getLongitude().toInteger().intValue() / 1000000.0);
                tag.setGpsCoodinates(gpsCoodinates);
                tag.setGpsCoordinatesPresent(true);
            }
            return tag;
        }
        return null;
    }

    void onTagReportAvailableInternal(RO_ACCESS_REPORT msg) throws OctaneSdkException {
        if (msg.getTagReportDataList() != null && msg.getTagReportDataList().size() > 0) {
            TagReport invReport = new TagReport();
            TagOpReport opReport = new TagOpReport();
            List tdlist = msg.getTagReportDataList();
            for (TagReportData tr : tdlist) {
                Tag tag = this.buildTag(tr);
                if (tag == null) continue;
                invReport.addTag(tag);
                this.processOpSpecResults(opReport, tr, tag);
            }
            if (invReport.getTags().size() > 0 && this.tagReportListener != null) {
                this.tagReportListener.onTagReported(this, invReport);
            }
            if (opReport.getResults().size() > 0 && this.tagOpCompleteListener != null) {
                this.tagOpCompleteListener.onTagOpComplete(this, opReport);
            }
        }
        this.processCustomReports(msg);
    }

    void onReaderEventInternal(READER_EVENT_NOTIFICATION readerEvent) {
        org.llrp.ltk.generated.parameters.ConnectionAttemptEvent re;
        Object e;
        if (readerEvent.getReaderEventNotificationData().getGPIEvent() != null) {
            e = new GpiEvent();
            ((GpiEvent)e).setPortNumber(readerEvent.getReaderEventNotificationData().getGPIEvent().getGPIPortNumber().toShort());
            ((GpiEvent)e).setState(readerEvent.getReaderEventNotificationData().getGPIEvent().getGPIEvent().toBoolean());
            if (this.gpiChangeListener != null) {
                this.gpiChangeListener.onGpiChanged(this, (GpiEvent)e);
            }
        }
        if (readerEvent.getReaderEventNotificationData().getAntennaEvent() != null) {
            e = new AntennaEvent();
            ((AntennaEvent)e).setPortNumber(readerEvent.getReaderEventNotificationData().getAntennaEvent().getAntennaID().toShort());
            org.llrp.ltk.generated.enumerations.AntennaEventType aet = readerEvent.getReaderEventNotificationData().getAntennaEvent().getEventType();
            ((AntennaEvent)e).setState(AntennaEventType.valueOf(aet.intValue()));
            if (this.antennaChangeListener != null) {
                this.antennaChangeListener.onAntennaChanged(this, (AntennaEvent)e);
            }
        }
        if (readerEvent.getReaderEventNotificationData().getReportBufferLevelWarningEvent() != null) {
            e = new BufferWarningEvent();
            ((BufferWarningEvent)e).setPercentFull(readerEvent.getReaderEventNotificationData().getReportBufferLevelWarningEvent().getReportBufferPercentageFull().toByte());
            if (this.bufferWarningListener != null) {
                this.bufferWarningListener.onBufferWarning(this, (BufferWarningEvent)e);
            }
        }
        if (readerEvent.getReaderEventNotificationData().getReportBufferOverflowErrorEvent() != null) {
            e = new BufferOverflowEvent();
            if (this.bufferOverflowListener != null) {
                this.bufferOverflowListener.onBufferOverflow(this, (BufferOverflowEvent)e);
            }
        }
        if (readerEvent.getReaderEventNotificationData().getROSpecEvent() != null) {
            ROSpecEvent r = readerEvent.getReaderEventNotificationData().getROSpecEvent();
            if (r.getEventType().intValue() == 0 && this.readerStartListener != null) {
                this.readerStartListener.onReaderStart(this, new ReaderStartEvent());
            }
            if (r.getEventType().intValue() == 1 && this.readerStopListener != null) {
                this.readerStopListener.onReaderStop(this, new ReaderStopEvent());
            }
        }
        if (readerEvent.getReaderEventNotificationData().getConnectionAttemptEvent() != null && (re = readerEvent.getReaderEventNotificationData().getConnectionAttemptEvent()).getStatus().intValue() == 4 && this.connectionAttemptListener != null) {
            this.connectionAttemptListener.onConnectionAttempt(this, new ConnectionAttemptEvent());
        }
        if (readerEvent.getReaderEventNotificationData().getConnectionCloseEvent() != null && this.connectionCloseListener != null) {
            this.connectionCloseListener.onConnectionClose(this, new ConnectionCloseEvent());
        }
    }

    List<Integer> bitArrayToList(BitArray_HEX bits) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        int wordCount = bits.size() / 16;
        for (int wordPtr = 0; wordPtr < wordCount; ++wordPtr) {
            int wordEnd = wordPtr * 16 + 16;
            int word = 0;
            for (int bitPtr = wordPtr * 16; bitPtr < wordEnd; ++bitPtr) {
                Bit currentBit = bits.get(bitPtr);
                if (currentBit != null) {
                    int bitMask = 1 & currentBit.intValue();
                    word |= bitMask;
                }
                if (bitPtr >= wordEnd - 1) continue;
                word <<= 1;
            }
            result.add(word);
        }
        return result;
    }

    public void queryTags() throws OctaneSdkException {
        if (this.readerConnection == null) {
            throw new OctaneSdkException("You must connect to the reader before querying tags.");
        }
        this.getTagReports();
    }

    void getTagReports() throws OctaneSdkException {
        GET_REPORT msg = new GET_REPORT();
        msg.setMessageID(this.getUniqueMessageID());
        this.readerConnection.send((LLRPMessage)msg);
    }

    public void addOpSequence(TagOpSequence sequence) throws OctaneSdkException {
        if (null == sequence || sequence.getOps() == null || sequence.getOps().isEmpty()) {
            throw new OctaneSdkException("Cannot add empty operation sequence");
        }
        this.addAccessSpec(sequence);
        if (sequence.getState() == SequenceState.Active) {
            this.enableAccessSpec(sequence.getId());
        }
    }

    public GET_ACCESSSPECS_RESPONSE getAccessSpec() throws OctaneSdkException {
        GET_ACCESSSPECS msg = new GET_ACCESSSPECS();
        msg.setMessageID(this.getUniqueMessageID());
        GET_ACCESSSPECS_RESPONSE rsp = null;
        String msgType = "GET_ACCESSSPEC";
        ERROR_MESSAGE msgErr = null;
        try {
            rsp = (GET_ACCESSSPECS_RESPONSE)this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        this.checkLlrpReply(rsp.getLLRPStatus(), msgErr, msgType);
        return rsp;
    }

    void addAccessSpec(TagOpSequence sequence) throws OctaneSdkException {
        ADD_ACCESSSPEC msg = new ADD_ACCESSSPEC();
        msg.setMessageID(this.getUniqueMessageID());
        ERROR_MESSAGE msgErr = null;
        msg.setAccessSpec(new AccessSpec());
        msg.getAccessSpec().setAntennaID(new UnsignedShort((int)sequence.getAntennaId()));
        msg.getAccessSpec().setROSpecID(new UnsignedInteger(0));
        msg.getAccessSpec().setProtocolID(new AirProtocols(1));
        msg.getAccessSpec().setCurrentState(new AccessSpecState(0));
        msg.getAccessSpec().setAccessSpecStopTrigger(new AccessSpecStopTrigger());
        if (sequence.getSequenceStopTrigger() == SequenceTriggerType.ExecutionCount) {
            msg.getAccessSpec().getAccessSpecStopTrigger().setAccessSpecStopTrigger(new AccessSpecStopTriggerType(1));
            msg.getAccessSpec().getAccessSpecStopTrigger().setOperationCountValue(new UnsignedShort((int)sequence.getExecutionCount()));
        } else {
            msg.getAccessSpec().getAccessSpecStopTrigger().setAccessSpecStopTrigger(new AccessSpecStopTriggerType(0));
            msg.getAccessSpec().getAccessSpecStopTrigger().setOperationCountValue(new UnsignedShort(0));
        }
        msg.getAccessSpec().setAccessSpecID(new UnsignedInteger(sequence.getId()));
        msg.getAccessSpec().setAccessCommand(new AccessCommand());
        C1G2TagSpec tagspec = new C1G2TagSpec();
        ArrayList tlist = new ArrayList();
        tagspec.setC1G2TargetTagList(tlist);
        C1G2TargetTag tag = new C1G2TargetTag();
        if (sequence.getTargetTag() == null) {
            sequence.setTargetTag(new TargetTag());
            sequence.getTargetTag().setBitPointer((short)0);
            sequence.getTargetTag().setData("");
            sequence.getTargetTag().setMemoryBank(MemoryBank.Epc);
        }
        if (sequence.getTargetTag().getMask() == null) {
            String mask = "";
            for (int i = 0; i < sequence.getTargetTag().getData().length(); ++i) {
                mask = mask + "F";
            }
            sequence.getTargetTag().setMask(mask);
        }
        tag.setMatch(new Bit(true));
        tag.setMB(this.twoBitFieldFromInt(sequence.getTargetTag().getMemoryBank().getValue()));
        tag.setPointer(new UnsignedShort((int)sequence.getTargetTag().getBitPointer()));
        tag.setTagData(new BitArray_HEX(sequence.getTargetTag().getData()));
        tag.setTagMask(new BitArray_HEX(sequence.getTargetTag().getMask()));
        tagspec.getC1G2TargetTagList().add(tag);
        msg.getAccessSpec().getAccessCommand().setAirProtocolTagSpec((AirProtocolTagSpec)tagspec);
        ArrayList olist = new ArrayList();
        msg.getAccessSpec().getAccessCommand().setAccessCommandOpSpecList(olist);
        for (TagOp t : sequence.getOps()) {
            ImpinjSetQTConfig iqt;
            TagOp tqt;
            if (t instanceof TagReadOp) {
                TagReadOp tr = (TagReadOp)t;
                C1G2Read c1g2read = new C1G2Read();
                if (tr.getAccessPassword() != null) {
                    c1g2read.setAccessPassword(new UnsignedInteger(tr.getAccessPassword().toDoubleWord()));
                } else {
                    c1g2read.setAccessPassword(new UnsignedInteger(0));
                }
                c1g2read.setMB(this.twoBitFieldFromInt(tr.getMemoryBank().getValue()));
                c1g2read.setOpSpecID(new UnsignedShort((int)tr.Id));
                c1g2read.setWordCount(new UnsignedShort((int)tr.getWordCount()));
                c1g2read.setWordPointer(new UnsignedShort((int)tr.getWordPointer()));
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)c1g2read);
                continue;
            }
            if (t instanceof TagWriteOp) {
                TagWriteOp tw = (TagWriteOp)t;
                if (sequence.isBlockWriteEnabled()) {
                    C1G2BlockWrite c1g2bwrite = new C1G2BlockWrite();
                    if (tw.getAccessPassword() != null) {
                        c1g2bwrite.setAccessPassword(new UnsignedInteger(tw.getAccessPassword().toDoubleWord()));
                    } else {
                        c1g2bwrite.setAccessPassword(new UnsignedInteger(0));
                    }
                    c1g2bwrite.setMB(this.twoBitFieldFromInt(tw.getMemoryBank().getValue()));
                    c1g2bwrite.setOpSpecID(new UnsignedShort((int)tw.Id));
                    c1g2bwrite.setWordPointer(new UnsignedShort((int)tw.getWordPointer()));
                    c1g2bwrite.setWriteData(new UnsignedShortArray_HEX(tw.getData().toHexWordString()));
                    msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)c1g2bwrite);
                    continue;
                }
                C1G2Write c1g2write = new C1G2Write();
                if (tw.getAccessPassword() != null) {
                    c1g2write.setAccessPassword(new UnsignedInteger(tw.getAccessPassword().toDoubleWord()));
                } else {
                    c1g2write.setAccessPassword(new UnsignedInteger(0));
                }
                c1g2write.setMB(this.twoBitFieldFromInt(tw.getMemoryBank().getValue()));
                c1g2write.setOpSpecID(new UnsignedShort((int)tw.Id));
                c1g2write.setWordPointer(new UnsignedShort((int)tw.getWordPointer()));
                c1g2write.setWriteData(new UnsignedShortArray_HEX(tw.getData().toHexWordString()));
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)c1g2write);
                continue;
            }
            if (t instanceof TagLockOp) {
                C1G2LockPayload lp;
                TagLockOp tl = (TagLockOp)t;
                if (tl.getLockCount() == 0) {
                    throw new OctaneSdkException("The TagLogckOp does not specify any lock operations");
                }
                C1G2Lock c1g2l = new C1G2Lock();
                if (tl.getAccessPassword() != null) {
                    c1g2l.setAccessPassword(new UnsignedInteger(tl.getAccessPassword().toDoubleWord()));
                } else {
                    c1g2l.setAccessPassword(new UnsignedInteger(0));
                }
                c1g2l.setOpSpecID(new UnsignedShort((int)tl.Id));
                c1g2l.setC1G2LockPayloadList(new ArrayList());
                if (tl.getKillPasswordLockType() != TagLockState.None) {
                    lp = new C1G2LockPayload();
                    lp.setPrivilege(new C1G2LockPrivilege(tl.getKillPasswordLockType().getValue()));
                    lp.setDataField(new C1G2LockDataField(LockMemoryBank.KillPassword.getValue()));
                    c1g2l.addToC1G2LockPayloadList(lp);
                }
                if (tl.getAccessPasswordLockType() != TagLockState.None) {
                    lp = new C1G2LockPayload();
                    lp.setPrivilege(new C1G2LockPrivilege(tl.getAccessPasswordLockType().getValue()));
                    lp.setDataField(new C1G2LockDataField(LockMemoryBank.AccessPassword.getValue()));
                    c1g2l.addToC1G2LockPayloadList(lp);
                }
                if (tl.getEpcLockType() != TagLockState.None) {
                    lp = new C1G2LockPayload();
                    lp.setPrivilege(new C1G2LockPrivilege(tl.getEpcLockType().getValue()));
                    lp.setDataField(new C1G2LockDataField(LockMemoryBank.Epc.getValue()));
                    c1g2l.addToC1G2LockPayloadList(lp);
                }
                if (tl.getTidLockType() != TagLockState.None) {
                    lp = new C1G2LockPayload();
                    lp.setPrivilege(new C1G2LockPrivilege(tl.getTidLockType().getValue()));
                    lp.setDataField(new C1G2LockDataField(LockMemoryBank.Tid.getValue()));
                    c1g2l.addToC1G2LockPayloadList(lp);
                }
                if (tl.getUserLockType() != TagLockState.None) {
                    lp = new C1G2LockPayload();
                    lp.setPrivilege(new C1G2LockPrivilege(tl.getUserLockType().getValue()));
                    lp.setDataField(new C1G2LockDataField(LockMemoryBank.User.getValue()));
                    c1g2l.addToC1G2LockPayloadList(lp);
                }
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)c1g2l);
                continue;
            }
            if (t instanceof TagKillOp) {
                TagKillOp tk = (TagKillOp)t;
                C1G2Kill c1g2k = new C1G2Kill();
                c1g2k.setOpSpecID(new UnsignedShort((int)tk.Id));
                c1g2k.setKillPassword(new UnsignedInteger(tk.getKillPassword().toDoubleWord()));
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)c1g2k);
                continue;
            }
            if (t instanceof TagBlockPermalockOp) {
                TagBlockPermalockOp tb = (TagBlockPermalockOp)t;
                ImpinjBlockPermalock ibp = new ImpinjBlockPermalock();
                if (tb.getAccessPassword() != null) {
                    ibp.setAccessPassword(new UnsignedInteger(tb.getAccessPassword().toDoubleWord()));
                } else {
                    ibp.setAccessPassword(new UnsignedInteger(0));
                }
                ibp.setMB(this.twoBitFieldFromInt(MemoryBank.User.getValue()));
                ibp.setOpSpecID(new UnsignedShort((int)tb.Id));
                ibp.setBlockPointer(new UnsignedShort(0));
                ibp.setBlockMask(new UnsignedShortArray_HEX(tb.getBlockMask().toHexWordString()));
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)ibp);
                continue;
            }
            if (t instanceof TagMarginReadOp) {
                TagMarginReadOp mrOp = (TagMarginReadOp)t;
                ImpinjMarginRead c1g2MR = new ImpinjMarginRead();
                if (mrOp.getAccessPassword() != null) {
                    c1g2MR.setAccessPassword(new UnsignedInteger(mrOp.getAccessPassword().toDoubleWord()));
                } else {
                    c1g2MR.setAccessPassword(new UnsignedInteger(0));
                }
                c1g2MR.setMB(this.twoBitFieldFromInt(mrOp.getMemoryBank().getValue()));
                c1g2MR.setOpSpecID(new UnsignedShort((int)mrOp.Id));
                c1g2MR.setBitPointer(new UnsignedShort(mrOp.getBitPointer()));
                c1g2MR.setBitLength(new UnsignedByte(mrOp.getMarginMask().getBitLength()));
                c1g2MR.setMask(new UnsignedShortArray_HEX(mrOp.getMarginMask().toHexWordString()));
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)c1g2MR);
                continue;
            }
            if (t instanceof TagQtSetOp) {
                tqt = (TagQtSetOp)t;
                iqt = new ImpinjSetQTConfig();
                if (((TagQtSetOp)tqt).getAccessPassword() != null) {
                    iqt.setAccessPassword(new UnsignedInteger(((TagQtSetOp)tqt).getAccessPassword().toDoubleWord()));
                } else {
                    iqt.setAccessPassword(new UnsignedInteger(0));
                }
                iqt.setAccessRange(new ImpinjQTAccessRange(((TagQtSetOp)tqt).getAccessRange().getValue()));
                iqt.setDataProfile(new ImpinjQTDataProfile(((TagQtSetOp)tqt).getDataProfile().getValue()));
                iqt.setPersistence(new ImpinjQTPersistence(((TagQtSetOp)tqt).getPersistence().getValue()));
                iqt.setOpSpecID(new UnsignedShort((int)((TagQtSetOp)tqt).Id));
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)iqt);
                continue;
            }
            if (t instanceof TagQtGetOp) {
                tqt = (TagQtGetOp)t;
                iqt = new ImpinjGetQTConfig();
                if (((TagQtGetOp)tqt).getAccessPassword() != null) {
                    iqt.setAccessPassword(new UnsignedInteger(((TagQtGetOp)tqt).getAccessPassword().toDoubleWord()));
                } else {
                    iqt.setAccessPassword(new UnsignedInteger(0));
                }
                iqt.setOpSpecID(new UnsignedShort((int)((TagQtGetOp)tqt).Id));
                msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)iqt);
                continue;
            }
            if (!(t instanceof TagImpinjAuthenticateOp)) continue;
            TagImpinjAuthenticateOp authOp = (TagImpinjAuthenticateOp)t;
            ImpinjAuthenticate pAuth = new ImpinjAuthenticate();
            BitArray_HEX fullMsgAsBitArray = authOp.getMessageIncludingHeader();
            String fullMsgAsHexString = fullMsgAsBitArray.toString();
            TagData fullMsgAsTagData = TagData.fromHexString(fullMsgAsHexString);
            TagData accessPwd = authOp.getAccessPassword();
            if (accessPwd != null) {
                pAuth.setAccessPassword(new UnsignedInteger(accessPwd.toDoubleWord()));
            } else {
                pAuth.setAccessPassword(new UnsignedInteger(0));
            }
            pAuth.setOpSpecID(new UnsignedShort((int)authOp.Id));
            pAuth.setCSI(new UnsignedByte(authOp.getCsi()));
            pAuth.setIncRepLen(new Bit(authOp.getIncludeReplyLen()));
            pAuth.setSendRep(new Bit(authOp.getSendReply()));
            pAuth.setMessage(fullMsgAsBitArray);
            this.outstandingAuthenticateRequests.putIfAbsent(pAuth.getOpSpecID().intValue(), fullMsgAsTagData);
            msg.getAccessSpec().getAccessCommand().addToAccessCommandOpSpecList((AccessCommandOpSpec)pAuth);
        }
        msg.getAccessSpec().setAccessReportSpec(new AccessReportSpec());
        msg.getAccessSpec().getAccessReportSpec().setAccessReportTrigger(new AccessReportTriggerType(0));
        if (sequence.isBlockWriteEnabled()) {
            ImpinjAccessSpecConfiguration iaspec = new ImpinjAccessSpecConfiguration();
            iaspec.setImpinjBlockWriteWordCount(new ImpinjBlockWriteWordCount());
            iaspec.getImpinjBlockWriteWordCount().setWordCount(new UnsignedShort((int)sequence.getBlockWriteWordCount()));
            iaspec.setImpinjOpSpecRetryCount(new ImpinjOpSpecRetryCount());
            iaspec.getImpinjOpSpecRetryCount().setRetryCount(new UnsignedShort((int)sequence.getBlockWriteRetryCount()));
            msg.getAccessSpec().addToCustomList((Custom)iaspec);
        }
        ADD_ACCESSSPEC_RESPONSE rsp = null;
        String msgType = "ADD_ACCESSSPEC";
        try {
            rsp = (ADD_ACCESSSPEC_RESPONSE)this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        StatusCode status = rsp.getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            String err = "failure";
            try {
                err = rsp.toXMLString();
            }
            catch (InvalidLLRPMessageException invalidLLRPMessageException) {
                // empty catch block
            }
            throw new OctaneSdkException("Error adding access specs: " + err);
        }
    }

    public void enableOpSequence(int sequenceId) throws OctaneSdkException {
        this.enableAccessSpec(sequenceId);
    }

    public void deleteOpSequence(int sequenceId) throws OctaneSdkException {
        this.deleteAccessSpec(sequenceId);
    }

    public void deleteAllOpSequences() throws OctaneSdkException {
        this.deleteAccessSpec(0);
    }

    void deleteAccessSpec(int id) throws OctaneSdkException {
        DELETE_ACCESSSPEC msg = new DELETE_ACCESSSPEC();
        msg.setMessageID(this.getUniqueMessageID());
        ERROR_MESSAGE msgErr = null;
        DELETE_ACCESSSPEC_RESPONSE rsp = null;
        String msgType = "DELETE_ACCESSSPEC";
        msg.setAccessSpecID(new UnsignedInteger(id));
        try {
            rsp = (DELETE_ACCESSSPEC_RESPONSE)this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        StatusCode status = rsp.getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            throw new OctaneSdkException("Error deleting access specs");
        }
    }

    void enableAccessSpec(int id) throws OctaneSdkException {
        ENABLE_ACCESSSPEC msg = new ENABLE_ACCESSSPEC();
        msg.setMessageID(this.getUniqueMessageID());
        ERROR_MESSAGE msgErr = null;
        ENABLE_ACCESSSPEC_RESPONSE rsp = null;
        String msgType = "ENABLE_ACCESSSPEC";
        msg.setAccessSpecID(new UnsignedInteger(id));
        try {
            rsp = (ENABLE_ACCESSSPEC_RESPONSE)this.readerConnection.transact((LLRPMessage)msg, (long)this.messageTimeout);
        }
        catch (TimeoutException e) {
            this.throwTimeoutException(msgType);
        }
        this.checkForNullReply(msgType, (LLRPMessage)rsp, msgErr);
        StatusCode status = rsp.getLLRPStatus().getStatusCode();
        if (!status.equals((Object)new StatusCode("M_Success"))) {
            throw new OctaneSdkException("Error enable access specs");
        }
    }

    public void resumeEventsAndReports() throws OctaneSdkException {
        ENABLE_EVENTS_AND_REPORTS msg = new ENABLE_EVENTS_AND_REPORTS();
        msg.setMessageID(this.getUniqueMessageID());
        this.readerConnection.send((LLRPMessage)msg);
    }

    protected class MessageHandler
    extends Thread {
        final BlockingQueue<LLRPMessage> messages = new LinkedBlockingQueue<LLRPMessage>();
        ImpinjReader reader;

        MessageHandler(ImpinjReader reader) {
            this.setName("AsyncMessageHandler");
            this.setDaemon(true);
            this.reader = reader;
        }

        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    LLRPMessage m = this.messages.take();
                    this.reader.doMessageReceived(m);
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                }
                catch (Exception ex) {
                    Thread.UncaughtExceptionHandler h = Thread.getDefaultUncaughtExceptionHandler();
                    if (h == null) continue;
                    h.uncaughtException(this, ex);
                }
            }
        }

        public void add(LLRPMessage l) {
            this.messages.add(l);
        }
    }
}

