/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.AbstractTagAuthenticateOp;
import com.impinj.octane.OctaneSdkException;
import com.impinj.octane.TagData;
import java.util.List;
import org.llrp.ltk.types.BitArray_HEX;

public class TagImpinjAuthenticateOp
extends AbstractTagAuthenticateOp {
    private boolean includeTid = true;
    static final int roMsgLengthWords = 3;
    static final int roMsgLengthBytes = 6;
    static final int accessPwByteSize = 4;

    @Override
    public void setAccessPassword(TagData accessPassword) throws OctaneSdkException {
        int pwSz = accessPassword.getCountBytes();
        if (pwSz != 4) {
            throw new OctaneSdkException(String.format("Access Password is %d bytes. Expecting %d.", pwSz, 4));
        }
        this.accessPassword = accessPassword;
    }

    @Override
    public boolean getSendReply() {
        return true;
    }

    @Override
    protected void setSendReply(boolean sendReply) throws OctaneSdkException {
        throw new OctaneSdkException("TagImpinjAuthenticateOp will always send reply and cannot be changed.");
    }

    @Override
    public boolean getIncludeReplyLen() {
        return false;
    }

    @Override
    protected void setIncludeReplyLen(boolean includeReplyLen) throws OctaneSdkException {
        throw new OctaneSdkException("TagImpinjAuthenticateOp will never include reply length and cannot be changed.");
    }

    @Override
    public byte getCsi() {
        return 1;
    }

    @Override
    protected void setCsi(byte csi) throws OctaneSdkException {
        throw new OctaneSdkException("TagImpinjAuthenticateOp uses cryptographic suite index number 1 and cannot be changed.");
    }

    public boolean getIncludeTidInReply() {
        return this.includeTid;
    }

    public void setIncludeTidInReply(boolean includeTid) {
        this.includeTid = includeTid;
    }

    @Override
    public void setChallengeMessage(TagData challengeMessage) throws OctaneSdkException {
        if (challengeMessage.getCountBytes() != 6) {
            throw new OctaneSdkException(String.format("Received: %d bits. Expected: 48 bits.", challengeMessage.getCountBytes() * 8));
        }
        this.challengeMessage = challengeMessage;
    }

    public BitArray_HEX getMessageIncludingHeader() throws OctaneSdkException {
        if (this.challengeMessage == null) {
            throw new OctaneSdkException("The Challenge Message is null. Expected: a TagData of 3 words.");
        }
        List<Integer> msgAsShorts = this.challengeMessage.toWordList();
        msgAsShorts.set(0, msgAsShorts.get(0) & 0x3FF);
        if (this.includeTid) {
            msgAsShorts.set(0, msgAsShorts.get(0) | 0x400);
        }
        return new BitArray_HEX(TagData.fromWordList(msgAsShorts).toHexString());
    }
}

