/*
 * Decompiled with CFR 0.152.
 */
package com.impinj.octane;

import com.impinj.octane.OctaneSdkException;
import com.impinj.octane.RShellSocket;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

public class SshRShellSocket
implements RShellSocket {
    private static final int SSH_PORT_NUMBER = 22;
    private JSch _jsch = new JSch();
    private Session _session;
    private String _address;
    private String _username;
    private String _password;
    private int _receiveTimeout;

    public SshRShellSocket(String address, String username, String password, int timeoutMs) throws OctaneSdkException {
        this._address = address;
        this._username = username;
        this._password = password;
        this._receiveTimeout = timeoutMs;
    }

    @Override
    public boolean isConnected() {
        return this._session != null && this._session.isConnected();
    }

    @Override
    public void Connect() throws OctaneSdkException {
        try {
            this._session = this._jsch.getSession(this._username, this._address, 22);
            this._session.setPassword(this._password);
            Properties config = new Properties();
            config.put("StrictHostKeyChecking", "no");
            this._session.setConfig(config);
            this._session.connect();
        }
        catch (JSchException e) {
            throw new OctaneSdkException("Cannot open RShell because the socket connection failed.");
        }
    }

    @Override
    public String Send(String cmd) throws OctaneSdkException {
        String reply = "";
        if (this._session != null) {
            try {
                String line;
                ChannelExec channelExec = (ChannelExec)this._session.openChannel("exec");
                InputStream in = channelExec.getInputStream();
                channelExec.setCommand(cmd);
                channelExec.connect(this._receiveTimeout);
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                StringBuilder sb = new StringBuilder();
                while ((line = reader.readLine()) != null) {
                    sb.append(line + '\r' + '\n');
                }
                channelExec.disconnect();
                reply = sb.toString();
            }
            catch (Exception e) {
                throw new OctaneSdkException("There was an error sending the RShell command");
            }
        }
        return reply;
    }

    @Override
    public void Close() throws OctaneSdkException {
        if (this._session != null) {
            this._session.disconnect();
        }
    }
}

