/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.custom.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class ImpinjDirectionUserTagPopulationLimit
extends Custom {
    public static final UnsignedInteger PARAMETER_SUBTYPE = new UnsignedInteger(1570);
    public static final UnsignedInteger VENDOR_ID = new UnsignedInteger(25882);
    private static final Logger LOGGER = Logger.getLogger(ImpinjDirectionUserTagPopulationLimit.class);
    protected UnsignedShort userTagPopulationLimit;

    public ImpinjDirectionUserTagPopulationLimit() {
        this.vendorIdentifier = VENDOR_ID;
        this.parameterSubtype = PARAMETER_SUBTYPE;
    }

    public ImpinjDirectionUserTagPopulationLimit(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public ImpinjDirectionUserTagPopulationLimit(Element element) throws InvalidLLRPMessageException {
        this.vendorIdentifier = new UnsignedInteger(25882);
        this.parameterSubtype = new UnsignedInteger(1570);
        this.decodeXML(element);
    }

    public ImpinjDirectionUserTagPopulationLimit(Custom custom) {
        this.decodeBinary(custom.encodeBinary());
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.vendorIdentifier == null) {
            LOGGER.warn(" vendorIdentifier not set");
        }
        resultBits.append(this.vendorIdentifier.encodeBinary());
        if (this.parameterSubtype == null) {
            LOGGER.warn(" parameterSubtype not set");
        }
        resultBits.append(this.parameterSubtype.encodeBinary());
        if (this.userTagPopulationLimit == null) {
            LOGGER.warn(" userTagPopulationLimit not set");
        }
        resultBits.append(this.userTagPopulationLimit.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("Impinj", "http://developer.impinj.com/ltk/schema/encoding/xml/1.46");
        Element element = new Element(name, ns);
        if (this.userTagPopulationLimit == null) {
            LOGGER.warn(" userTagPopulationLimit not set");
            throw new MissingParameterException(" userTagPopulationLimit not set");
        }
        element.addContent(this.userTagPopulationLimit.encodeXML("UserTagPopulationLimit", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.vendorIdentifier = new UnsignedInteger(binary.subList(position, UnsignedInteger.length()));
        this.parameterSubtype = new UnsignedInteger(binary.subList(position += UnsignedInteger.length(), UnsignedInteger.length()));
        position += UnsignedInteger.length();
        if (!this.vendorIdentifier.equals(VENDOR_ID)) {
            LOGGER.error("custom vendor identifier -" + this.vendorIdentifier + "- does not match -" + VENDOR_ID + "-.");
        }
        if (!this.parameterSubtype.equals(PARAMETER_SUBTYPE)) {
            LOGGER.error("custom subtype " + this.parameterSubtype + " identifier does not match " + PARAMETER_SUBTYPE + ".");
        }
        this.userTagPopulationLimit = new UnsignedShort(binary.subList(position, UnsignedShort.length()));
        position += UnsignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Element temp = null;
        Object tempList = null;
        boolean atLeastOnce = false;
        temp = element.getChild("UserTagPopulationLimit", element.getNamespace());
        if (temp != null) {
            this.userTagPopulationLimit = new UnsignedShort(temp);
        }
    }

    public void setUserTagPopulationLimit(UnsignedShort userTagPopulationLimit) {
        this.userTagPopulationLimit = userTagPopulationLimit;
    }

    public UnsignedShort getUserTagPopulationLimit() {
        return this.userTagPopulationLimit;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public String getName() {
        return "$parameter.Name";
    }
}

