/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.custom.LLRPKnownCustom;
import org.llrp.ltk.generated.custom.parameters.ImpinjAuthenticate;
import org.llrp.ltk.generated.custom.parameters.ImpinjBlockPermalock;
import org.llrp.ltk.generated.custom.parameters.ImpinjGetBlockPermalockStatus;
import org.llrp.ltk.generated.custom.parameters.ImpinjGetQTConfig;
import org.llrp.ltk.generated.custom.parameters.ImpinjMarginRead;
import org.llrp.ltk.generated.custom.parameters.ImpinjSetQTConfig;
import org.llrp.ltk.generated.interfaces.AccessCommandOpSpec;
import org.llrp.ltk.generated.interfaces.AirProtocolTagSpec;
import org.llrp.ltk.generated.parameters.C1G2BlockErase;
import org.llrp.ltk.generated.parameters.C1G2BlockWrite;
import org.llrp.ltk.generated.parameters.C1G2Kill;
import org.llrp.ltk.generated.parameters.C1G2Lock;
import org.llrp.ltk.generated.parameters.C1G2Read;
import org.llrp.ltk.generated.parameters.C1G2TagSpec;
import org.llrp.ltk.generated.parameters.C1G2Write;
import org.llrp.ltk.generated.parameters.ClientRequestOpSpec;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class AccessCommand
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(209);
    private static final Logger LOGGER = Logger.getLogger(AccessCommand.class);
    protected AirProtocolTagSpec airProtocolTagSpec;
    protected List<AccessCommandOpSpec> accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
    protected List<Custom> customList = new LinkedList<Custom>();

    public AccessCommand() {
    }

    public AccessCommand(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public AccessCommand(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public AccessCommand(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.airProtocolTagSpec == null) {
            LOGGER.warn(" airProtocolTagSpec not set");
            throw new MissingParameterException(" airProtocolTagSpec not set");
        }
        resultBits.append(this.airProtocolTagSpec.encodeBinary());
        if (this.accessCommandOpSpecList == null) {
            LOGGER.warn(" accessCommandOpSpecList not set");
            throw new MissingParameterException(" accessCommandOpSpecList not set");
        }
        for (AccessCommandOpSpec accessCommandOpSpec : this.accessCommandOpSpecList) {
            resultBits.append(accessCommandOpSpec.encodeBinary());
        }
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom custom : this.customList) {
                resultBits.append(custom.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.airProtocolTagSpec == null) {
            LOGGER.info("airProtocolTagSpec not set");
            throw new MissingParameterException("airProtocolTagSpec not set");
        }
        element.addContent(this.airProtocolTagSpec.encodeXML(this.airProtocolTagSpec.getClass().getSimpleName(), ns));
        if (this.accessCommandOpSpecList == null) {
            LOGGER.warn(" accessCommandOpSpecList not set");
            throw new MissingParameterException("  accessCommandOpSpecList not set");
        }
        for (AccessCommandOpSpec accessCommandOpSpec : this.accessCommandOpSpecList) {
            element.addContent(accessCommandOpSpec.encodeXML(accessCommandOpSpec.getClass().getName().replaceAll(accessCommandOpSpec.getClass().getPackage().getName() + ".", ""), ns));
        }
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom custom : this.customList) {
                element.addContent(custom.encodeXML(custom.getClass().getName().replaceAll(custom.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        Custom cus;
        boolean foundOne;
        int position = 0;
        int tempLength = 0;
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("AccessCommand misses non optional parameter of type AirProtocolTagSpec");
            throw new MissingParameterException("AccessCommand misses non optional parameter of type AirProtocolTagSpec");
        }
        boolean found = false;
        LOGGER.trace("decoding choice type AirProtocolTagSpec ");
        if (binary.get(position)) {
            tempLength = C1G2TagSpec.length();
        }
        if (type != null && type.equals(C1G2TagSpec.TYPENUM)) {
            this.airProtocolTagSpec = new C1G2TagSpec(binary, position, tempLength);
            LOGGER.trace(" airProtocolTagSpec instatiated to C1G2TagSpec with length " + tempLength);
            position += tempLength;
            found = true;
        }
        if (!found) {
            LOGGER.warn("encoded message misses non optional parameter airProtocolTagSpec");
            throw new MissingParameterException("AccessCommand misses non optional parameter of type AirProtocolTagSpec");
        }
        this.accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
        LOGGER.trace("decoding parameter accessCommandOpSpecList ");
        while (position < binary.length()) {
            foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(C1G2Read.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Read.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Read(binary, position, tempLength));
                LOGGER.trace("adding C1G2Read to accessCommandOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2Write.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Write.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Write(binary, position, tempLength));
                LOGGER.trace("adding C1G2Write to accessCommandOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2Kill.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Kill.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Kill(binary, position, tempLength));
                LOGGER.trace("adding C1G2Kill to accessCommandOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2Lock.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2Lock.length();
                }
                this.accessCommandOpSpecList.add(new C1G2Lock(binary, position, tempLength));
                LOGGER.trace("adding C1G2Lock to accessCommandOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2BlockErase.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockErase.length();
                }
                this.accessCommandOpSpecList.add(new C1G2BlockErase(binary, position, tempLength));
                LOGGER.trace("adding C1G2BlockErase to accessCommandOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(C1G2BlockWrite.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = C1G2BlockWrite.length();
                }
                this.accessCommandOpSpecList.add(new C1G2BlockWrite(binary, position, tempLength));
                LOGGER.trace("adding C1G2BlockWrite to accessCommandOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(ClientRequestOpSpec.TYPENUM)) {
                if (binary.get(position)) {
                    tempLength = ClientRequestOpSpec.length();
                }
                this.accessCommandOpSpecList.add(new ClientRequestOpSpec(binary, position, tempLength));
                LOGGER.trace("adding ClientRequestOpSpec to accessCommandOpSpecList ");
                position += tempLength;
                foundOne = true;
                continue;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                cus = new Custom(binary, position, tempLength);
                if (cus.getParameterSubtype().equals(ImpinjBlockPermalock.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecList.add(new ImpinjBlockPermalock(cus));
                    LOGGER.trace("adding ImpinjBlockPermalock to accessCommandOpSpecList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjGetBlockPermalockStatus.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecList.add(new ImpinjGetBlockPermalockStatus(cus));
                    LOGGER.trace("adding ImpinjGetBlockPermalockStatus to accessCommandOpSpecList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjSetQTConfig.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecList.add(new ImpinjSetQTConfig(cus));
                    LOGGER.trace("adding ImpinjSetQTConfig to accessCommandOpSpecList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjGetQTConfig.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecList.add(new ImpinjGetQTConfig(cus));
                    LOGGER.trace("adding ImpinjGetQTConfig to accessCommandOpSpecList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjMarginRead.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecList.add(new ImpinjMarginRead(cus));
                    LOGGER.trace("adding ImpinjMarginRead to accessCommandOpSpecList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (cus.getParameterSubtype().equals(ImpinjAuthenticate.PARAMETER_SUBTYPE)) {
                    this.accessCommandOpSpecList.add(new ImpinjAuthenticate(cus));
                    LOGGER.trace("adding ImpinjAuthenticate to accessCommandOpSpecList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
                if (!LLRPKnownCustom.isKnown(cus.getVendorIdentifier(), cus.getParameterSubtype())) {
                    this.accessCommandOpSpecList.add(cus);
                    LOGGER.trace("adding Custom to specParameterList ");
                    position += tempLength;
                    foundOne = true;
                    continue;
                }
            }
            if (foundOne) continue;
            break;
        }
        if (this.accessCommandOpSpecList.isEmpty()) {
            LOGGER.warn("encoded message does not contain parameter for non optional accessCommandOpSpecList");
            throw new MissingParameterException("AccessCommand misses non optional parameter of type AccessCommandOpSpec");
        }
        this.customList = new LinkedList<Custom>();
        LOGGER.trace("decoding parameter customList ");
        while (position < binary.length()) {
            foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                cus = new Custom(binary, position, tempLength);
                this.customList.add(cus);
                position += tempLength;
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace("AccessCommand misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        boolean found = false;
        LOGGER.trace("decoding choice type AirProtocolTagSpec ");
        temp = element.getChild("C1G2TagSpec", ns);
        if (temp != null) {
            this.airProtocolTagSpec = new C1G2TagSpec(temp);
            LOGGER.trace(" airProtocolTagSpec instatiated to C1G2TagSpec with");
            found = true;
        }
        element.removeChild("C1G2TagSpec", ns);
        if (!found) {
            LOGGER.trace("AccessCommand misses optional parameter of type airProtocolTagSpecList");
        }
        this.accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
        tempList = element.getChildren();
        Iterator i = tempList.iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String name = e.getName();
            if (name.equals("C1G2Read")) {
                this.accessCommandOpSpecList.add(new C1G2Read(e));
                LOGGER.trace("adding C1G2Read to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2Write")) {
                this.accessCommandOpSpecList.add(new C1G2Write(e));
                LOGGER.trace("adding C1G2Write to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2Kill")) {
                this.accessCommandOpSpecList.add(new C1G2Kill(e));
                LOGGER.trace("adding C1G2Kill to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2Lock")) {
                this.accessCommandOpSpecList.add(new C1G2Lock(e));
                LOGGER.trace("adding C1G2Lock to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2BlockErase")) {
                this.accessCommandOpSpecList.add(new C1G2BlockErase(e));
                LOGGER.trace("adding C1G2BlockErase to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("C1G2BlockWrite")) {
                this.accessCommandOpSpecList.add(new C1G2BlockWrite(e));
                LOGGER.trace("adding C1G2BlockWrite to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ClientRequestOpSpec")) {
                this.accessCommandOpSpecList.add(new ClientRequestOpSpec(e));
                LOGGER.trace("adding ClientRequestOpSpec to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjBlockPermalock")) {
                this.accessCommandOpSpecList.add(new ImpinjBlockPermalock(e));
                LOGGER.trace("adding ImpinjBlockPermalock to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjGetBlockPermalockStatus")) {
                this.accessCommandOpSpecList.add(new ImpinjGetBlockPermalockStatus(e));
                LOGGER.trace("adding ImpinjGetBlockPermalockStatus to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjSetQTConfig")) {
                this.accessCommandOpSpecList.add(new ImpinjSetQTConfig(e));
                LOGGER.trace("adding ImpinjSetQTConfig to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjGetQTConfig")) {
                this.accessCommandOpSpecList.add(new ImpinjGetQTConfig(e));
                LOGGER.trace("adding ImpinjGetQTConfig to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjMarginRead")) {
                this.accessCommandOpSpecList.add(new ImpinjMarginRead(e));
                LOGGER.trace("adding ImpinjMarginRead to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (name.equals("ImpinjAuthenticate")) {
                this.accessCommandOpSpecList.add(new ImpinjAuthenticate(e));
                LOGGER.trace("adding ImpinjAuthenticate to accessCommandOpSpecList ");
                atLeastOnce = true;
                i.remove();
                continue;
            }
            if (!name.equals("Custom")) continue;
            this.accessCommandOpSpecList.add(new Custom(e));
            LOGGER.trace("adding Custom to accessCommandOpSpecList ");
            atLeastOnce = true;
            i.remove();
        }
        if (this.accessCommandOpSpecList.isEmpty()) {
            LOGGER.warn("Choice AccessCommandOpSpec must contain at least one element");
            throw new MissingParameterException("Choice AccessCommandOpSpec must contain at least one element");
        }
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace("AccessCommand misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.trace("adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        tempList = element.getChildren("Custom", ns);
        for (Element e : tempList) {
            this.customList.add(new Custom(e));
            atLeastOnce = true;
            LOGGER.trace("adding custom parameter");
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "AccessCommand has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAirProtocolTagSpec(AirProtocolTagSpec airProtocolTagSpec) {
        this.airProtocolTagSpec = airProtocolTagSpec;
    }

    public void setAccessCommandOpSpecList(List<AccessCommandOpSpec> accessCommandOpSpecList) {
        this.accessCommandOpSpecList = accessCommandOpSpecList;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public AirProtocolTagSpec getAirProtocolTagSpec() {
        return this.airProtocolTagSpec;
    }

    public List<AccessCommandOpSpec> getAccessCommandOpSpecList() {
        return this.accessCommandOpSpecList;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToAccessCommandOpSpecList(AccessCommandOpSpec accessCommandOpSpec) {
        if (this.accessCommandOpSpecList == null) {
            this.accessCommandOpSpecList = new LinkedList<AccessCommandOpSpec>();
        }
        this.accessCommandOpSpecList.add(accessCommandOpSpec);
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "AccessCommand";
    }

    public String toString() {
        String result = "AccessCommand: ";
        result = result.replaceFirst(", ", "");
        return result;
    }
}

