/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.BitList;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedByte;
import org.llrp.ltk.types.UnsignedIntegerArray;
import org.llrp.ltk.types.UnsignedShort;

public class FrequencyHopTable
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(147);
    private static final Logger LOGGER = Logger.getLogger(FrequencyHopTable.class);
    protected UnsignedByte hopTableID;
    protected BitList reserved0 = new BitList(8);
    protected UnsignedIntegerArray frequency;

    public FrequencyHopTable() {
    }

    public FrequencyHopTable(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public FrequencyHopTable(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public FrequencyHopTable(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.hopTableID == null) {
            LOGGER.warn(" hopTableID not set");
            throw new MissingParameterException(" hopTableID not set  for Parameter of Type FrequencyHopTable");
        }
        resultBits.append(this.hopTableID.encodeBinary());
        resultBits.append(this.reserved0.encodeBinary());
        if (this.frequency == null) {
            LOGGER.warn(" frequency not set");
            throw new MissingParameterException(" frequency not set  for Parameter of Type FrequencyHopTable");
        }
        resultBits.append(this.frequency.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.hopTableID == null) {
            LOGGER.warn(" hopTableID not set");
            throw new MissingParameterException(" hopTableID not set");
        }
        element.addContent(this.hopTableID.encodeXML("HopTableID", ns));
        if (this.frequency == null) {
            LOGGER.warn(" frequency not set");
            throw new MissingParameterException(" frequency not set");
        }
        element.addContent(this.frequency.encodeXML("Frequency", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.hopTableID = new UnsignedByte(binary, position, UnsignedByte.length());
        position += UnsignedByte.length();
        short fieldCount = new SignedShort(binary, position += this.reserved0.length(), UnsignedShort.length()).toShort();
        tempLength = UnsignedIntegerArray.length() * fieldCount + UnsignedShort.length();
        if (tempLength % 8 > 0) {
            tempLength += 8 - tempLength % 8;
            LOGGER.info("padding needed for frequency ");
        }
        this.frequency = new UnsignedIntegerArray(binary, position, tempLength);
        position += tempLength;
        LOGGER.trace("decoding array of type: UnsignedIntegerArray with " + tempLength + " length");
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("HopTableID", ns);
        if (temp != null) {
            this.hopTableID = new UnsignedByte(temp);
        }
        element.removeChild("HopTableID", ns);
        temp = element.getChild("Frequency", ns);
        if (temp != null) {
            this.frequency = new UnsignedIntegerArray(temp);
        }
        element.removeChild("Frequency", ns);
        if (element.getChildren().size() > 0) {
            String message = "FrequencyHopTable has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setHopTableID(UnsignedByte hopTableID) {
        this.hopTableID = hopTableID;
    }

    public void setFrequency(UnsignedIntegerArray frequency) {
        this.frequency = frequency;
    }

    public UnsignedByte getHopTableID() {
        return this.hopTableID;
    }

    public UnsignedIntegerArray getFrequency() {
        return this.frequency;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "FrequencyHopTable";
    }

    public String toString() {
        String result = "FrequencyHopTable: ";
        result = result + ", hopTableID: ";
        result = result + this.hopTableID;
        result = result + ", frequency: ";
        result = result + this.frequency;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

