/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.generated.interfaces.SpecParameter;
import org.llrp.ltk.generated.parameters.Custom;
import org.llrp.ltk.generated.parameters.RFSurveySpecStopTrigger;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedInteger;
import org.llrp.ltk.types.UnsignedShort;

public class RFSurveySpec
extends TLVParameter
implements SpecParameter {
    public static final SignedShort TYPENUM = new SignedShort(187);
    private static final Logger LOGGER = Logger.getLogger(RFSurveySpec.class);
    protected UnsignedShort antennaID;
    protected UnsignedInteger startFrequency;
    protected UnsignedInteger endFrequency;
    protected RFSurveySpecStopTrigger rFSurveySpecStopTrigger;
    protected List<Custom> customList = new LinkedList<Custom>();

    public RFSurveySpec() {
    }

    public RFSurveySpec(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public RFSurveySpec(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public RFSurveySpec(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set  for Parameter of Type RFSurveySpec");
        }
        resultBits.append(this.antennaID.encodeBinary());
        if (this.startFrequency == null) {
            LOGGER.warn(" startFrequency not set");
            throw new MissingParameterException(" startFrequency not set  for Parameter of Type RFSurveySpec");
        }
        resultBits.append(this.startFrequency.encodeBinary());
        if (this.endFrequency == null) {
            LOGGER.warn(" endFrequency not set");
            throw new MissingParameterException(" endFrequency not set  for Parameter of Type RFSurveySpec");
        }
        resultBits.append(this.endFrequency.encodeBinary());
        if (this.rFSurveySpecStopTrigger == null) {
            LOGGER.warn(" rFSurveySpecStopTrigger not set");
            throw new MissingParameterException(" rFSurveySpecStopTrigger not set");
        }
        resultBits.append(this.rFSurveySpecStopTrigger.encodeBinary());
        if (this.customList == null) {
            LOGGER.info(" customList not set");
        } else {
            for (Custom field : this.customList) {
                resultBits.append(field.encodeBinary());
            }
        }
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.antennaID == null) {
            LOGGER.warn(" antennaID not set");
            throw new MissingParameterException(" antennaID not set");
        }
        element.addContent(this.antennaID.encodeXML("AntennaID", ns));
        if (this.startFrequency == null) {
            LOGGER.warn(" startFrequency not set");
            throw new MissingParameterException(" startFrequency not set");
        }
        element.addContent(this.startFrequency.encodeXML("StartFrequency", ns));
        if (this.endFrequency == null) {
            LOGGER.warn(" endFrequency not set");
            throw new MissingParameterException(" endFrequency not set");
        }
        element.addContent(this.endFrequency.encodeXML("EndFrequency", ns));
        if (this.rFSurveySpecStopTrigger == null) {
            LOGGER.info("rFSurveySpecStopTrigger not set");
            throw new MissingParameterException("rFSurveySpecStopTrigger not set");
        }
        element.addContent(this.rFSurveySpecStopTrigger.encodeXML(this.rFSurveySpecStopTrigger.getClass().getSimpleName(), ns));
        if (this.customList == null) {
            LOGGER.info("customList not set");
        } else {
            for (Custom field : this.customList) {
                element.addContent(field.encodeXML(field.getClass().getName().replaceAll(field.getClass().getPackage().getName() + ".", ""), ns));
            }
        }
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        int tempLength = 0;
        this.antennaID = new UnsignedShort(binary, position, UnsignedShort.length());
        this.startFrequency = new UnsignedInteger(binary, position += UnsignedShort.length(), UnsignedInteger.length());
        this.endFrequency = new UnsignedInteger(binary, position += UnsignedInteger.length(), UnsignedInteger.length());
        position += UnsignedInteger.length();
        SignedShort type = null;
        short tempByteLength = 0;
        tempLength = 0;
        try {
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
        }
        catch (IllegalArgumentException le) {
            LOGGER.warn("RFSurveySpec misses non optional parameter of type RFSurveySpecStopTrigger");
            throw new MissingParameterException("RFSurveySpec misses non optional parameter of type RFSurveySpecStopTrigger");
        }
        if (binary.get(position)) {
            RFSurveySpec rFSurveySpec = this;
            tempLength = rFSurveySpec.rFSurveySpecStopTrigger.length();
        }
        if (type != null && type.equals(RFSurveySpecStopTrigger.TYPENUM)) {
            this.rFSurveySpecStopTrigger = new RFSurveySpecStopTrigger(binary, position, tempLength);
            position += tempLength;
        } else {
            LOGGER.warn("RFSurveySpec misses non optional parameter of type RFSurveySpecStopTrigger");
            throw new MissingParameterException("RFSurveySpec misses non optional parameter of type RFSurveySpecStopTrigger");
        }
        LOGGER.trace(" rFSurveySpecStopTrigger is instantiated with RFSurveySpecStopTrigger with length" + tempLength);
        this.customList = new LinkedList<Custom>();
        LOGGER.trace("decoding parameter customList ");
        while (position < binary.length()) {
            boolean foundOne = false;
            if (binary.get(position)) {
                type = new SignedShort(binary, position + 1, 7);
            } else {
                type = new SignedShort(binary, position + 6, 10);
                tempByteLength = new SignedShort(binary, position + 6 + 10, UnsignedShort.length()).toShort();
                tempLength = 8 * tempByteLength;
            }
            if (type != null && type.equals(Custom.TYPENUM)) {
                Custom cus = new Custom(binary, position, tempLength);
                this.customList.add(cus);
                position += tempLength;
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
        if (this.customList.isEmpty()) {
            LOGGER.trace("RFSurveySpec misses optional parameter of type Custom");
        }
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        List tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("AntennaID", ns);
        if (temp != null) {
            this.antennaID = new UnsignedShort(temp);
        }
        element.removeChild("AntennaID", ns);
        temp = element.getChild("StartFrequency", ns);
        if (temp != null) {
            this.startFrequency = new UnsignedInteger(temp);
        }
        element.removeChild("StartFrequency", ns);
        temp = element.getChild("EndFrequency", ns);
        if (temp != null) {
            this.endFrequency = new UnsignedInteger(temp);
        }
        element.removeChild("EndFrequency", ns);
        temp = element.getChild("RFSurveySpecStopTrigger", ns);
        if (temp != null) {
            this.rFSurveySpecStopTrigger = new RFSurveySpecStopTrigger(temp);
            LOGGER.info("setting parameter rFSurveySpecStopTrigger for parameter RFSurveySpec");
        }
        if (temp == null) {
            LOGGER.warn("RFSurveySpec misses non optional parameter of type rFSurveySpecStopTrigger");
            throw new MissingParameterException("RFSurveySpec misses non optional parameter of type rFSurveySpecStopTrigger");
        }
        element.removeChild("RFSurveySpecStopTrigger", ns);
        this.customList = new LinkedList<Custom>();
        tempList = element.getChildren("Custom", ns);
        if (tempList == null || tempList.isEmpty()) {
            LOGGER.trace("RFSurveySpec misses optional parameter of type customList");
        } else {
            for (Element e : tempList) {
                this.customList.add(new Custom(e));
                LOGGER.trace("adding Custom to customList ");
            }
        }
        element.removeChildren("Custom", ns);
        tempList = element.getChildren("Custom", ns);
        for (Element e : tempList) {
            this.customList.add(new Custom(e));
            atLeastOnce = true;
            LOGGER.trace("adding custom parameter");
        }
        element.removeChildren("Custom", ns);
        if (element.getChildren().size() > 0) {
            String message = "RFSurveySpec has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setAntennaID(UnsignedShort antennaID) {
        this.antennaID = antennaID;
    }

    public void setStartFrequency(UnsignedInteger startFrequency) {
        this.startFrequency = startFrequency;
    }

    public void setEndFrequency(UnsignedInteger endFrequency) {
        this.endFrequency = endFrequency;
    }

    public void setRFSurveySpecStopTrigger(RFSurveySpecStopTrigger rFSurveySpecStopTrigger) {
        this.rFSurveySpecStopTrigger = rFSurveySpecStopTrigger;
    }

    public void setCustomList(List<Custom> customList) {
        this.customList = customList;
    }

    public UnsignedShort getAntennaID() {
        return this.antennaID;
    }

    public UnsignedInteger getStartFrequency() {
        return this.startFrequency;
    }

    public UnsignedInteger getEndFrequency() {
        return this.endFrequency;
    }

    public RFSurveySpecStopTrigger getRFSurveySpecStopTrigger() {
        return this.rFSurveySpecStopTrigger;
    }

    public List<Custom> getCustomList() {
        return this.customList;
    }

    public void addToCustomList(Custom custom) {
        if (this.customList == null) {
            this.customList = new LinkedList<Custom>();
        }
        this.customList.add(custom);
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "RFSurveySpec";
    }

    public String toString() {
        String result = "RFSurveySpec: ";
        result = result + ", antennaID: ";
        result = result + this.antennaID;
        result = result + ", startFrequency: ";
        result = result + this.startFrequency;
        result = result + ", endFrequency: ";
        result = result + this.endFrequency;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

