/*
 * Decompiled with CFR 0.152.
 */
package org.llrp.ltk.generated.parameters;

import org.apache.log4j.Logger;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;
import org.llrp.ltk.exceptions.InvalidLLRPMessageException;
import org.llrp.ltk.exceptions.MissingParameterException;
import org.llrp.ltk.types.LLRPBitList;
import org.llrp.ltk.types.SignedShort;
import org.llrp.ltk.types.TLVParameter;
import org.llrp.ltk.types.UnsignedShort;

public class TransmitPowerLevelTableEntry
extends TLVParameter {
    public static final SignedShort TYPENUM = new SignedShort(145);
    private static final Logger LOGGER = Logger.getLogger(TransmitPowerLevelTableEntry.class);
    protected UnsignedShort index;
    protected SignedShort transmitPowerValue;

    public TransmitPowerLevelTableEntry() {
    }

    public TransmitPowerLevelTableEntry(LLRPBitList list) {
        this.decodeBinary(list);
    }

    public TransmitPowerLevelTableEntry(LLRPBitList list, int bitIndex, int length) {
        this(list.subList(bitIndex, length));
    }

    public TransmitPowerLevelTableEntry(Element element) throws InvalidLLRPMessageException {
        this.decodeXML(element);
    }

    @Override
    public LLRPBitList encodeBinarySpecific() {
        LLRPBitList resultBits = new LLRPBitList();
        if (this.index == null) {
            LOGGER.warn(" index not set");
            throw new MissingParameterException(" index not set  for Parameter of Type TransmitPowerLevelTableEntry");
        }
        resultBits.append(this.index.encodeBinary());
        if (this.transmitPowerValue == null) {
            LOGGER.warn(" transmitPowerValue not set");
            throw new MissingParameterException(" transmitPowerValue not set  for Parameter of Type TransmitPowerLevelTableEntry");
        }
        resultBits.append(this.transmitPowerValue.encodeBinary());
        return resultBits;
    }

    @Override
    public Content encodeXML(String name, Namespace ns) {
        ns = Namespace.getNamespace("llrp", "http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        Element element = new Element(name, ns);
        if (this.index == null) {
            LOGGER.warn(" index not set");
            throw new MissingParameterException(" index not set");
        }
        element.addContent(this.index.encodeXML("Index", ns));
        if (this.transmitPowerValue == null) {
            LOGGER.warn(" transmitPowerValue not set");
            throw new MissingParameterException(" transmitPowerValue not set");
        }
        element.addContent(this.transmitPowerValue.encodeXML("TransmitPowerValue", ns));
        return element;
    }

    @Override
    protected void decodeBinarySpecific(LLRPBitList binary) {
        int position = 0;
        boolean tempLength = false;
        this.index = new UnsignedShort(binary, position, UnsignedShort.length());
        this.transmitPowerValue = new SignedShort(binary, position += UnsignedShort.length(), SignedShort.length());
        position += SignedShort.length();
    }

    @Override
    public void decodeXML(Element element) throws InvalidLLRPMessageException {
        Object tempList = null;
        boolean atLeastOnce = false;
        Element temp = null;
        Namespace ns = Namespace.getNamespace("http://www.llrp.org/ltk/schema/core/encoding/xml/1.0");
        temp = element.getChild("Index", ns);
        if (temp != null) {
            this.index = new UnsignedShort(temp);
        }
        element.removeChild("Index", ns);
        temp = element.getChild("TransmitPowerValue", ns);
        if (temp != null) {
            this.transmitPowerValue = new SignedShort(temp);
        }
        element.removeChild("TransmitPowerValue", ns);
        if (element.getChildren().size() > 0) {
            String message = "TransmitPowerLevelTableEntry has unknown element " + ((Element)element.getChildren().get(0)).getName();
            throw new InvalidLLRPMessageException(message);
        }
    }

    public void setIndex(UnsignedShort index) {
        this.index = index;
    }

    public void setTransmitPowerValue(SignedShort transmitPowerValue) {
        this.transmitPowerValue = transmitPowerValue;
    }

    public UnsignedShort getIndex() {
        return this.index;
    }

    public SignedShort getTransmitPowerValue() {
        return this.transmitPowerValue;
    }

    public static Integer length() {
        return 0;
    }

    @Override
    public SignedShort getTypeNum() {
        return TYPENUM;
    }

    @Override
    public String getName() {
        return "TransmitPowerLevelTableEntry";
    }

    public String toString() {
        String result = "TransmitPowerLevelTableEntry: ";
        result = result + ", index: ";
        result = result + this.index;
        result = result + ", transmitPowerValue: ";
        result = result + this.transmitPowerValue;
        result = result.replaceFirst(", ", "");
        return result;
    }
}

